# ES-Theme-Tiled 
A minimalistic, highly-configurable, grid-centric EmulationStation theme designed for Steam Deck and other Handhelds running Batocera or RetroBat

## Theme Options
* Factbox - How the metadata section should look like 
* Media Style - How the main image(s) of the metadata section should look like (Thumbnail + Cartridge, Mix Image, Image, Thumbnail, Cartridge)
* Video - Should views play and what is the play delay (1s Delay, 2s Delay, 5s Delay, Don't Play)
* Colorway - Theme color scheme (Extra Dark, Dark, Steam OS)
* Font - Font used throught the theme
* Font Size - Preset Sizes for the text (Small, Medium Large)
* Help Icons - Type of Buttons to show in the Help section (Default, Arcade, Playstation, SNES, Switch, XBox)
* Art Style - Art Assets used for the System Grid/Carousel (Modern, NSOIsh, Carbon, Logos)
* System View - Toggle Between Grid and Carousel System views
* System Grid Size - Configure number of columns and rows of the System Grid
* System Grid Background - Choose the background color of the system grid tiles
* GameList Grid Background - Choose the background color of the GameList grid tiles

## **System Views**
<table>
    <tr>
        <td>Grid<img src="screenshots\systemgrid.png"/></td>
        <td>Carousel<img src="screenshots\systemcarousel.png"/></td>
    </tr>
</table>

## **System Art Styles**
<table>
    <tr>
        <td>Modern<img src="screenshots\systemgrid.png" alt="Modern"/></td>
        <td>NSOIsh<img src="screenshots\systemgrid2.png" alt="NSOIsh"/></td>
    </tr>
    <tr>
        <td>Carbon<img src="screenshots\systemgrid3.png" alt="Carbon"/></td>
        <td>System Logos<img src="screenshots\systemgrid4.png" alt="Logos"/></td>
    </tr>
</table>


## **GameList Views**
<table>
    <tr>
        <td>Grid<img src="screenshots\gamelist_grid.png"/></td>
        <td>Grid (Thumbnails)<img src="screenshots\gamelist_gridthumb.png"/></td>
    </tr>
    <tr>
        <td>Grid (Marquees)<img src="screenshots\gamelist_gridmarquee.png"/></td>
        <td>Grid (Cartridges)<img src="screenshots\gamelist_gridcart.png"/></td>
    </tr>
    <tr>
        <td>Detailed<img src="screenshots\gamelist_detailed.png" alt="Carbon"/></td>
        <td></td>
    </tr>
</table>


## Colorways
- Extra Dark
- Dark
- Steam OS

## **Acknowledgments**
Assets for the Modern style and controller icons taken from Alekfull-NX: https://github.com/fagnerpc/Alekfull-NX

Assets for the Carbon style taken from es-theme-carbon: https://github.com/fabricecaruso/es-theme-carbon

Assets for the Controllers style taken from es-de-moderntheme-nsoicons: https://github.com/szymon-kulak/es-de-moderntheme-nsoicons by Szymon Kulak

Assets and code structure for system indicators taken from canvas-es: https://github.com/Siddy212/canvas-es by Siddy212

Used screenshots for systems : https://www.screenscraper.fr/

Thanks to mikakunin for the additional system art