# Retro BIOSes

BIOSes in agreement with: [System.dat](https://github.com/libretro/libretro-database/blob/master/dat/System.dat)

## What's inside

### System, firmware, or BIOS files used by libretro

#### Version 2020-11-02

#### 3DO Company, The - 3DO 🆗

✔️**3do_arcade_saot.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/3do_arcade_saot.bin))

> size 524288
> crc b832da9a
> md5 8970fc987ab89a7f64da9f8a8c4333ff
> sha1 520d3d1b5897800af47f92efd2444a26b7a7dead

✔️**goldstar.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/goldstar.bin))

> size 1048576
> crc b6f5028b
> md5 8639fd5e549bd6238cfee79e3e749114
> sha1 c4a2e5336f77fb5f743de1eea2cda43675ee2de7

✔️**panafz1-kanji.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz1-kanji.bin))

> size 933636
> crc a8e9447c
> md5 b8dc97f778a6245c58e064b0312e8281
> sha1 acd39a8fee1b9d2950d5ab447846c11fb31af63e

✔️**panafz1.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz1.bin))

> size 1048576
> crc c8c8ff89
> md5 f47264dd47fe30f73ab3c010015c155b
> sha1 34bf189111295f74d7b7dfc1f304d98b8d36325a

✔️**panafz10-norsa.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz10-norsa.bin))

> size 1048576
> crc 230e6feb
> md5 1477bda80dc33731a65468c1f5bcbee9
> sha1 f05e642322c03694f06a809c0b90fc27ac73c002

✔️**panafz10.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz10.bin))

> size 1048576
> crc 58242cee
> md5 51f2f43ae2f3508a14d9f56597e2d3ce
> sha1 3c912300775d1ad730dc35757e279c274c0acaad

✔️**panafz10e-anvil-norsa.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz10e-anvil-norsa.bin))

> size 1048576
> crc 9a186221
> md5 cf11bbb5a16d7af9875cca9de9a15e09
> sha1 2765c7b4557cc838b32567d2428d088980295159

✔️**panafz10e-anvil.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz10e-anvil.bin))

> size 1048576
> crc 2495c500
> md5 a48e6746bd7edec0f40cff078f0bb19f
> sha1 a900371f0cdcdc03f79557f11d406fd71251a5fd

✔️**panafz10ja-anvil-kanji.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz10ja-anvil-kanji.bin))

> size 1048576
> crc ff7393de
> md5 428577250f43edc902ea239c50d2240d
> sha1 2e857b957803d0331fd229328df01f3ffab69eee

✔️**panafz1j-kanji.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz1j-kanji.bin))

> size 1048576
> crc 45f478b1
> md5 c23fb5d5e6bb1c240d02cf968972be37
> sha1 884515605ee243577ab20767ef8c1a7368e4e407

✔️**panafz1j-norsa.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz1j-norsa.bin))

> size 1048576
> crc 82ce67c6
> md5 f6c71de7470d16abe4f71b1444883dc8
> sha1 a417587ae3b0b8ef00c830920c21af8bee88e419

✔️**panafz1j.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/panafz1j.bin))

> size 1048576
> crc d9493adc
> md5 a496cfdded3da562759be3561317b605
> sha1 ec7ec62d60ec0459a14ed56ebc66761ef3c80efc

✔️**sanyotry.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/3DO%20Company%2C%20The%20-%203DO/sanyotry.bin))

> size 1048576
> crc d5cbc509
> md5 35fa1a1ebaaeea286dc5cd15487c13ea
> sha1 b01c53da256dde43ffec4ad3fc3adfa8d635e943

#### Arcade 🆗

✔️**airlbios.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/airlbios.zip))

> size 715730
> crc f83ec60f
> md5 7a11bfe0cc72886d032e386db68f890c
> sha1 f2a730530f4989ca0e8860aa4e455b6a5fe69e1d

✔️**awbios.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/awbios.zip))

> size 42296
> crc 67a14ad5
> md5 85254fbe320ca82a768ec2c26bb08def
> sha1 7940c7bf29eee85a5b2fdec78750b19aa22895dc

✔️**bubsys.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/bubsys.zip))

> size 7950
> crc 8fc2fd2e
> md5 f81298afd68a1a24a49a1a2d9f087964
> sha1 1c0ffcd308b0c8c6dbb74ad8b811a0767200d366

✔️**cchip.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/cchip.zip))

> size 2700
> crc 23debecb
> md5 df6f8a3d83c028a5cb9f2f2be60773f3
> sha1 364f2302a145a0fd6de767d7f8484badde1d1a6e

✔️**decocass.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/decocass.zip))

> size 16107
> crc 5de524e5
> md5 b7e1189b341bf6a8e270017c096d21b0
> sha1 30b97b2670b79d0de41cba190324c504846c6fa1

✔️**f355bios.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/f355bios.zip))

> size 1394278
> crc 17516536
> md5 547f3d12aed389058ca06148f1cca0ed
> sha1 b6ff66dcb5547bd91760d239ddf428a655631c53

✔️**f355dlx.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/f355dlx.zip))

> size 2328436
> crc 23ac17be
> md5 1028615bcac4c31634a3364ce5c04044
> sha1 48d1712d1b1cdfeeeb43c6287c17b0b6309cfaab

✔️**hod2bios.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/hod2bios.zip))

> size 1479106
> crc 0ddc6daf
> md5 f4011d3116500354edf7302a90402711
> sha1 782c303cbdfab1027b04db74a63e27bdad5e0c53

✔️**isgsm.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/isgsm.zip))

> size 10207
> crc 26856bf9
> md5 4a56d56e2219c5e2b006b66a4263c01c
> sha1 f590ccf688b4c05fa1da5c5dd92c224545170c3b

✔️**midssio.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/midssio.zip))

> size 163
> crc 7620bd32
> md5 5904b0de768d1d506e766aa7e18994c1
> sha1 54275c9833e497f71f76ab239030cc386c863991

✔️**naomi.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/naomi.zip))

> size 9321533
> crc 6ee50181
> md5 526eda1e2a7920c92c88178789d71d84
> sha1 c96711c01c0158f161791d6fbe75d88329e8ac0a

✔️**neogeo.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/neogeo.zip))

> size 1859335
> crc 81315163
> md5 00dad01abdbf8ea9e79ad2fe11bdb182
> sha1 deb62b0074b8cae4f162c257662136733cfc76ad

✔️**nmk004.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/nmk004.zip))

> size 3556
> crc a6099353
> md5 bfacf1a68792d5348f93cf724d2f1dda
> sha1 489256f5e2001070d2ad94c90d255282c71ed274

✔️**pgm.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/pgm.zip))

> size 2094636
> crc bf3dd2ef
> md5 87cc944eef4c671aa2629a8ba48a08e0
> sha1 c0c001ec80fa860857000f4cfc9844a28498a355

✔️**skns.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/skns.zip))

> size 924762
> crc 5692af22
> md5 3f956c4e7008804cb47cbde49bd5b908
> sha1 4257bd14b541fafbd555cb98ba079a3416a45934

✔️**ym2608.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Arcade/ym2608.zip))

> size 7609
> crc 5b4c29c4
> md5 79ae0d2bb1901b7e606b6dc339b79a97
> sha1 06fc753d015b43ca1787f4cfd9331b1674202e64

#### Atari - 400-800 🆗

✔️**ATARIBAS.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%20400-800/ATARIBAS.ROM))

> size 8192
> crc 7d684184
> md5 0bac0c6a50104045d902df4503a4c30b
> sha1 3693c9cb9bf3b41bae1150f7a8264992468fc8c0

✔️**ATARIOSA.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%20400-800/ATARIOSA.ROM))

> size 10240
> crc 72b3fed4
> md5 eb1f32f5d9f382db1bbfb8d7f9cb343a
> sha1 6dd53356159a129ed12367beb3b24a771d41adb0

✔️**ATARIOSB.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%20400-800/ATARIOSB.ROM))

> size 10240
> crc 3e28a1fe
> md5 a3e8d617c95d08031fe1b20d541434b2
> sha1 f1f0741b1d34fb4350cf7cb8ab3b6ea11cdd8174

✔️**ATARIXL.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%20400-800/ATARIXL.ROM))

> size 16384
> crc 1f9cd270
> md5 06daac977823773a3eea3422fd26a703
> sha1 ae4f523ba08b6fd59f3cae515a2b2410bbd98f55

#### Atari - 5200 🆗

✔️**5200.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%205200/5200.rom))

> size 2048
> crc 4248d3e3
> md5 281f20ea4320404ec820fb7ec0693b38
> sha1 6ad7a1e8c9fad486fbec9498cb48bf5bc3adc530

#### Atari - 7800 🆗

✔️**7800 BIOS (E).rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%207800/7800%20BIOS%20(E).rom))

> size 16384
> crc d5b61170
> md5 397bb566584be7b9764e7a68974c4263
> sha1 5a140136a16d1d83e4ff32a19409ca376a8df874

✔️**7800 BIOS (U).rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%207800/7800%20BIOS%20(U).rom))

> size 4096
> crc 5d13730c
> md5 0763f1ffb006ddbe32e52d497ee848ae
> sha1 d9d134bb6b36907c615a594cc7688f7bfcef5b43

#### Atari - Lynx 🆗

✔️**lynxboot.img** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%20Lynx/lynxboot.img))

> size 512
> crc 0d973c9d
> md5 fcd403db69f54290b51035d82f835e7b
> sha1 e4ed47fae31693e016b081c6bda48da5b70d7ccb

#### Atari - ST 🆗

✔️**tos.img** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Atari%20-%20ST/tos.img))

> size 196608
> crc d3c32283
> md5 c1c57ce48e8ee4135885cee9e63a68a2
> sha1 735793fdba07fe8d5295caa03484f6ef3de931f5

#### Coleco - ColecoVision 🆗

✔️**colecovision.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Coleco%20-%20ColecoVision/colecovision.rom))

> size 8192
> crc 3aa93ef3
> md5 2c66f5911e5b42b8ebe113403548eee7
> sha1 45bedc4cbdeac66c7df59e9e599195c778d86a92

#### Commodore - Amiga 🆗

✔️**kick34005.A500** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Commodore%20-%20Amiga/kick34005.A500))

> size 262144
> crc c4f0f55f
> md5 82a21c1890cae844b3df741f2762d48d
> sha1 891e9a547772fe0c6c19b610baf8bc4ea7fcb785

✔️**kick40063.A600** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Commodore%20-%20Amiga/kick40063.A600))

> size 524288
> crc fc24ae0d
> md5 e40a5dfb3d017ba8779faba30cbd1c8e
> sha1 3b7f1493b27e212830f989f26ca76c02049f09ca

✔️**kick40068.A1200** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Commodore%20-%20Amiga/kick40068.A1200))

> size 524288
> crc 1483a091
> md5 646773759326fbac3b2311fd8c8793ee
> sha1 e21545723fe8374e91342617604f1b3d703094f1

#### Fairchild Channel F 🆗

✔️**sl31253.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Fairchild%20Channel%20F/sl31253.bin))

> size 1024
> crc 04694ed9
> md5 ac9804d4c0e9d07e33472e3726ed15c3
> sha1 81193965a374d77b99b4743d317824b53c3e3c78

✔️**sl31254.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Fairchild%20Channel%20F/sl31254.bin))

> size 1024
> crc 9c047ba3
> md5 da98f4bb3242ab80d76629021bb27585
> sha1 8f70d1b74483ba3a37e86cf16c849d601a8c3d2c

✔️**sl90025.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Fairchild%20Channel%20F/sl90025.bin))

> size 1024
> crc 015c1e38
> md5 95d339631d867c8f1d15a5f2ec26069d
> sha1 759e2ed31fbde4a2d8daf8b9f3e0dffebc90dae2

#### Id Software - Doom 🆗

✔️**prboom.wad** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Id%20Software%20-%20Doom/prboom.wad))

> size 143312
> crc a5751b99
> md5 72ae1b47820fcc93cc0df9c428d0face
> sha1 5f4aed208301449c2e9514edfd325fe9dead76fa

#### J2ME 🆗

✔️**freej2me-lr.jar** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/J2ME/freej2me-lr.jar))

> size 552042
> crc 96a1babf
> md5 ccd92e7156ce2f0ce14c88ffb68a16eb
> sha1 fb231192894e2fd17a5799fbbdf86a4696951bce

✔️**freej2me-sdl.jar** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/J2ME/freej2me-sdl.jar))

> size 552043
> crc 5cca0f35
> md5 4da74084fc1b1bd3d776ed8d3ee648de
> sha1 78f1f41d55efc6b8d81e99c1d9d75248b3f83dc2

✔️**freej2me.jar** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/J2ME/freej2me.jar))

> size 552039
> crc ffb98ffa
> md5 29a92d0867da2917275b7c6c805d256f
> sha1 7d738042268e4ffd0aae8e85e05dd28bce761d1f

#### MacII 🆗

✔️**MacII.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/MacII/MacII.ROM))

> size 262144
> crc 4df6d054
> md5 66223be1497460f1e60885eeb35e03cc
> sha1 db6b504744281369794e26ba71a6e385cf6227fa

#### Magnavox - Odyssey2 🆗

✔️**o2rom.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Magnavox%20-%20Odyssey2/o2rom.bin))

> size 1024
> crc 8016a315
> md5 562d5ebf9e030a40d6fabfc2f33139fd
> sha1 b2e1955d957a475de2411770452eff4ea19f4cee

#### Mattel - Intellivision 🆗

✔️**exec.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Mattel%20-%20Intellivision/exec.bin))

> size 8192
> crc cbce86f7
> md5 62e761035cb657903761800f4437b8af
> sha1 5a65b922b562cb1f57dab51b73151283f0e20c7a

✔️**grom.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Mattel%20-%20Intellivision/grom.bin))

> size 2048
> crc 683a4158
> md5 0cd5946c6473e42e8e4c2137785e427f
> sha1 f9608bb4ad1cfe3640d02844c7ad8e0bcd974917

#### Microsoft - MSX 🆗

✔️**CARTS.SHA** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/CARTS.SHA))

> size 33152
> crc d42f4444
> md5 74b0f217fa0e2b8bb5a2f8e2ecc69da3
> sha1 bf5fb954db868e523febccc68549ed9187961076

✔️**CYRILLIC.FNT** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/CYRILLIC.FNT))

> size 2048
> crc 73af9bc3
> md5 85b38e4128bbc300e675f55b278683a8
> sha1 000ac11b702a4c42e40f135df12fa5f2f13e20a1

✔️**DISK.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/DISK.ROM))

> size 16384
> crc 721f61df
> md5 80dcd1ad1a4cf65d64b7ba10504e8190
> sha1 032cb1c1c75b9a191fa1230978971698d9d2a17f

✔️**FMPAC.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/FMPAC.ROM))

> size 65536
> crc 0e84505d
> md5 6f69cc8b5ed761b03afd78000dfb0e19
> sha1 9d789166e3caf28e4742fe933d962e99618c633d

✔️**FMPAC16.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/FMPAC16.ROM))

> size 16384
> crc 5d6c4d27
> md5 af8537262df8df267072f359399a7635
> sha1 2dc4517ebd5a061f9b5aa6b449cc4d4a2073540c

✔️**ITALIC.FNT** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/ITALIC.FNT))

> size 2048
> crc c90ec498
> md5 c83e50e9f33b8dd893c414691822740d
> sha1 401dd6692dc80628e5f68b7c79be0b0ebbc4d3ee

✔️**KANJI.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/KANJI.ROM))

> size 131072
> crc c9651b32
> md5 febe8782b466d7c3b16de6d104826b34
> sha1 84a645becec0a25d3ab7a909cde1b242699a8662

✔️**MSX.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/MSX.ROM))

> size 32768
> crc 94ee12f3
> md5 aa95aea2563cd5ec0a0919b44cc17d47
> sha1 409e82adac40f6bdd18eb6c84e8b2fbdc7fb5498

✔️**MSX2.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/MSX2.ROM))

> size 32768
> crc 6cdaf3a5
> md5 ec3a01c91f24fbddcbcab0ad301bc9ef
> sha1 6103b39f1e38d1aa2d84b1c3219c44f1abb5436e

✔️**MSX2EXT.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/MSX2EXT.ROM))

> size 16384
> crc 66237ecf
> md5 2183c2aff17cf4297bdb496de78c2e8a
> sha1 5c1f9c7fb655e43d38e5dd1fcc6b942b2ff68b02

✔️**MSX2P.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/MSX2P.ROM))

> size 32768
> crc 00870134
> md5 6d8c0ca64e726c82a4b726e9b01cdf1e
> sha1 e2fbd56e42da637609d23ae9df9efd1b4241b18a

✔️**MSX2PEXT.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/MSX2PEXT.ROM))

> size 16384
> crc b8ba44d3
> md5 7c8243c71d8f143b2531f01afa6a05dc
> sha1 fe0254cbfc11405b79e7c86c7769bd6322b04995

✔️**MSXDOS2.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/MSXDOS2.ROM))

> size 65536
> crc 1c430991
> md5 6418d091cd6907bbcf940324339e43bb
> sha1 c36c9e0f96738a340381e23b4f97245388801a46

✔️**PAINTER.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/PAINTER.ROM))

> size 65536
> crc 1bda68a3
> md5 403cdea1cbd2bb24fae506941f8f655e
> sha1 7fd2a28c4fdaeb140f3c8c8fb90271b1472c97b9

✔️**RS232.ROM** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Microsoft%20-%20MSX/RS232.ROM))

> size 16640
> crc ab6874f8
> md5 279efd1eae0d358eecd4edc7d9adedf3
> sha1 7aec0134ad6a5177f4056fcb6047083e8e00529b

#### NEC - PC Engine - TurboGrafx 16 - SuperGrafx 🆗

✔️**gecard.pce** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC%20Engine%20-%20TurboGrafx%2016%20-%20SuperGrafx/gecard.pce))

> size 32768
> crc 51a12d90
> md5 6d2cb14fc3e1f65ceb135633d1694122
> sha1 014881a959e045e00f4db8f52955200865d40280

✔️**gexpress.pce** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC%20Engine%20-%20TurboGrafx%2016%20-%20SuperGrafx/gexpress.pce))

> size 32768
> crc 51a12d90
> md5 6d2cb14fc3e1f65ceb135633d1694122
> sha1 014881a959e045e00f4db8f52955200865d40280

✔️**syscard1.pce** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC%20Engine%20-%20TurboGrafx%2016%20-%20SuperGrafx/syscard1.pce))

> size 262144
> crc 3f9f95a4
> md5 2b7ccb3d86baa18f6402c176f3065082
> sha1 a39a66da7de6ba94ab84d04eef7afeec7d4ee66a

✔️**syscard2.pce** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC%20Engine%20-%20TurboGrafx%2016%20-%20SuperGrafx/syscard2.pce))

> size 262144
> crc 283b74e0
> md5 3cdd6614a918616bfc41c862e889dd79
> sha1 88da02e2503f7c32810f5d93a34849d470742b6d

✔️**syscard2u.pce** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC%20Engine%20-%20TurboGrafx%2016%20-%20SuperGrafx/syscard2u.pce))

> size 262144
> crc ff2a5ec3
> md5 94279f315e8b52904f65ab3108542afe
> sha1 2bea3dac98f84b2f2f469fa77ea720b8770d598d

✔️**syscard3.pce** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC%20Engine%20-%20TurboGrafx%2016%20-%20SuperGrafx/syscard3.pce))

> size 262144
> crc 6d9a73ef
> md5 38179df8f4ac870017db21ebcbf53114
> sha1 79f5ff55dd10187c7fd7b8daab0b3ffbd1f56a2c

✔️**syscard3u.pce** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC%20Engine%20-%20TurboGrafx%2016%20-%20SuperGrafx/syscard3u.pce))

> size 262144
> crc 2b5b75fe
> md5 0754f903b52e3b3342202bdafb13efa5
> sha1 d02611d99921986147c753df14c7349b31d71950

#### NEC - PC-98 🆗

✔️**2608_bd.wav** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/2608_bd.wav))

> size 19192
> crc bb038714
> md5 d94546e70f17fd899be8df3544ab6cbb
> sha1 0a56c142ef40cec50f3ee56a6e42d0029c9e2818

✔️**2608_hh.wav** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/2608_hh.wav))

> size 36722
> crc 9898b372
> md5 08c54a0c1f774a5538a848a6665a34b4
> sha1 12f676cef249b82480b6f19c454e234b435ca7b6

✔️**2608_rim.wav** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/2608_rim.wav))

> size 5288
> crc 638864c1
> md5 465ea0768b27da404aec45dfc501404b
> sha1 c65592330c9dd84011151daed52f9aec926b7e56

✔️**2608_sd.wav** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/2608_sd.wav))

> size 15558
> crc 542cc58c
> md5 d71004351c8bbfdad53b18222c061d49
> sha1 3c79663ef74c0b0439d13351326eb1c52a657008

✔️**2608_tom.wav** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/2608_tom.wav))

> size 23092
> crc 93c57bba
> md5 96a4ead13f364734f79b0c58af2f0e1f
> sha1 9513fb4a3f41e75a972a273a5104cbd834c1e2c5

✔️**2608_top.wav** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/2608_top.wav))

> size 57016
> crc ab73a296
> md5 593cff6597ab9380d822b8f824fd2c28
> sha1 aa4a8f766a86b830687d5083fd3b9db0652f46fc

✔️**bios.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/bios.rom))

> size 98304
> crc 0a682b93
> md5 cd237e16e7e77c06bb58540e9e9fca68
> sha1 76a7360502fa0296ea93b4c537174610a834d367

✔️**font.bmp** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/font.bmp))

> size 524350
> crc d271798b
> md5 7da1e5b7c482d4108d22a5b09631d967
> sha1 b4f14e58030ed40fff2dc312b58ea4440bdf8cc5

✔️**font.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/font.rom))

> size 288768
> crc 456d9fc7
> md5 38d32748ae49d1815b0614970849fd40
> sha1 78ba9960f135372825ab7244b5e4e73a810002ff

✔️**itf.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/itf.rom))

> size 32768
> crc c1815325
> md5 72ea51443070f0e9212bfc9b793ee28e
> sha1 a2fb11c000ed7c976520622cfb7940ed6ddc904e

✔️**sound.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-98/sound.rom))

> size 16384
> crc fe9f57f2
> md5 524473c1a5a03b17e21d86a0408ff827
> sha1 d5dbc4fea3b8367024d363f5351baecd6adcd8ef

#### NEC - PC-FX 🆗

✔️**fx-scsi.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-FX/fx-scsi.rom))

> size 524288
> crc f3e60e5e
> md5 430e9745f9235c515bc8e652d6ca3004
> sha1 65482a23ac5c10a6095aee1db5824cca54ead6e5

✔️**pcfx.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-FX/pcfx.rom))

> size 1048576
> crc 76ffb97a
> md5 08e36edbea28a017f79f8d4f7ff9b6d7
> sha1 1a77fd83e337f906aecab27a1604db064cf10074

✔️**pcfxbios.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-FX/pcfxbios.bin))

> size 1048576
> crc 76ffb97a
> md5 08e36edbea28a017f79f8d4f7ff9b6d7
> sha1 1a77fd83e337f906aecab27a1604db064cf10074

✔️**pcfxga.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-FX/pcfxga.rom))

> size 1048576
> crc 41c3776b
> md5 5885bc9a64bf80d4530b9b9b978ff587
> sha1 a9372202a5db302064c994fcda9b24d29bb1b41c

✔️**pcfxv101.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/NEC%20-%20PC-FX/pcfxv101.bin))

> size 1048576
> crc 236102c9
> md5 e2fb7c7220e3a7838c2dd7e401a7f3d8
> sha1 8b662f7548078be52a871565e19511ccca28c5c8

#### Nintendo - Famicom Disk System 🆗

✔️**disksys.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Famicom%20Disk%20System/disksys.rom))

> size 8192
> crc 5e607dcf
> md5 ca30b50f880eb660a320674ed365ef7a
> sha1 57fe1bdee955bb48d357e463ccbf129496930b62

#### Nintendo - Gameboy 🆗

✔️**dmg_boot.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Gameboy/dmg_boot.bin))

> size 256
> crc 59c8598e
> md5 32fbbd84168d3482956eb3c5051637f5
> sha1 4ed31ec6b0b175bb109c0eb5fd3d193da823339f

✔️**gb_bios.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Gameboy/gb_bios.bin))

> size 256
> crc 59c8598e
> md5 32fbbd84168d3482956eb3c5051637f5
> sha1 4ed31ec6b0b175bb109c0eb5fd3d193da823339f

#### Nintendo - Game Boy Advance 🆗

✔️**gba_bios.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Game%20Boy%20Advance/gba_bios.bin))

> size 16384
> crc 81977335
> md5 a860e8c0b6d573d191e4ec7db1b1e4f6
> sha1 300c20df6731a33952ded8c436f7f186d25d3492

#### Nintendo - Gameboy Color 🆗

✔️**cgb_boot.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Gameboy%20Color/cgb_boot.bin))

> size 2304
> crc 41884e46
> md5 dbfce9db9deaa2567f6a84fde55f9680
> sha1 1293d68bf9643bc4f36954c1e80e38f39864528d

✔️**gbc_bios.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Gameboy%20Color/gbc_bios.bin))

> size 2304
> crc 41884e46
> md5 dbfce9db9deaa2567f6a84fde55f9680
> sha1 1293d68bf9643bc4f36954c1e80e38f39864528d

#### Nintendo - GameCube 🆗

✔️**gc-dvd-20010608.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-dvd-20010608.bin))

> size 131072
> crc c047465a
> md5 561532ad496f644897952d2cef5bb431
> sha1 27872c201e87b06a19bf85d36c796ef383f8d52d

✔️**gc-dvd-20010831.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-dvd-20010831.bin))

> size 131072
> crc 54c7d10e
> md5 b953eb1a8fc9922b3f7051c1cdc451f1
> sha1 ae7233cae8f94749796e0b740d6021e3b00a8926

✔️**gc-dvd-20020402.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-dvd-20020402.bin))

> size 131072
> crc 8bbef508
> md5 413154dd0e2c824c9b18b807fd03ec4e
> sha1 691e46213d8428befdf568157e670b971ab94e1d

✔️**gc-dvd-20020823.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-dvd-20020823.bin))

> size 131072
> crc 5205222b
> md5 c03f6bbaf644eb9b3ee261dbe199eb42
> sha1 2faaf92bcaffe675f54f7249d30f3791507e22ab

✔️**gc-ntsc-10.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-ntsc-10.bin))

> size 2097152
> crc 6dac1f2a
> md5 fc924a7c879b661abc37cec4f018fdf3
> sha1 a1837968288253ed541f2b11440b68f5a9b33875

✔️**gc-ntsc-11.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-ntsc-11.bin))

> size 2097152
> crc d5e6feea
> md5 019e39822a9ca3029124f74dd4d55ac4
> sha1 239eacd86527ff9a75aeb7282da65797baeef010

✔️**gc-ntsc-12.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-ntsc-12.bin))

> size 2097152
> crc 86573808
> md5 b17148254a5799684c7d783206504926
> sha1 ef9194ab4804aa0aa8540d846caf291b28331165

✔️**gc-pal-10.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-pal-10.bin))

> size 2097152
> crc 4f319f43
> md5 0cdda509e2da83c85bfe423dd87346cc
> sha1 f27c63e5394e2fd1606f70df004c4fc2d6027700

✔️**gc-pal-11.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-pal-11.bin))

> size 2097152
> crc 667d0b64
> md5 339848a0b7c2124cf155276c1e79cbd0
> sha1 f3cd0c7c61cbcefa85e7de3aff4cfa50bc508714

✔️**gc-pal-12.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20GameCube/gc-pal-12.bin))

> size 2097152
> crc ad1b7f16
> md5 db92574caab77a7ec99d4605fd6f2450
> sha1 80b8744ff5e43585392f55546bd03a673d11ef5f

#### Nintendo - Nintendo 64DD 🆗

✔️**64DD_IPL.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Nintendo%2064DD/64DD_IPL.bin))

> size 4194304
> crc 7f933ce2
> md5 8d3d9f294b6e174bc7b1d2fd1c727530
> sha1 bf861922dcb78c316360e3e742f4f70ff63c9bc3

#### Nintendo - Nintendo DS 🆗

✔️**bios7.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Nintendo%20DS/bios7.bin))

> size 16384
> crc 1280f0d5
> md5 df692a80a5b1bc90728bc3dfc76cd948
> sha1 24f67bdea115a2c847c8813a262502ee1607b7df

✔️**bios9.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Nintendo%20DS/bios9.bin))

> size 4096
> crc 2ab23573
> md5 a392174eb3e572fed6447e956bde4b25
> sha1 bfaac75f101c135e32e2aaf541de6b1be4c8c62d

✔️**firmware.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Nintendo%20DS/firmware.bin))

> size 262144
> crc 945f9dc9
> md5 e45033d9b0fa6b0de071292bba7c9d13
> sha1 cfe072921ee3fb93f688743f8beef89043c3e9ad

#### Nintendo - Nintendo Entertainment System 🆗

✔️**NstDatabase.xml** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Nintendo%20Entertainment%20System/NstDatabase.xml))

> size 1009534
> crc ebb2196c
> md5 7bfe8c0540ed4bd6a0f1e2a0f0118ced
> sha1 26322f182540211e9b5e3647675b7c593706ae2b

#### Nintendo - Pokemon Mini 🆗

✔️**bios.min** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Pokemon%20Mini/bios.min))

> size 4096
> crc aed3c14d
> md5 1e4fb124a3a886865acb574f388c803d
> sha1 daad4113713ed776fbd47727762bca81ba74915f

#### Nintendo - Satellaview 🆗

✔️**BS-X.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Satellaview/BS-X.bin))

> size 1048576
> crc f51f07a0
> md5 fed4d8242cfbed61343d53d48432aced
> sha1 604556b2e62860af18db5a77f2956ebc75450020

✔️**BS-X (En).bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Satellaview/BS-X%20(En).bin))

> size 1048576
> crc 347e1c4e
> md5 33b62505da6ca4525e3839db4e1a7bca
> sha1 f3cdff70de5d0f5c52ca3a8f46588b863d48b8ec

✔️**BS-X (En) (DRM-Free).bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Satellaview/BS-X%20(En)%20(DRM-Free).bin))

> size 1048576
> crc 8c573c7e
> md5 4ed9648505ab33a4daec93707b16caba
> sha1 7996bd1c01b99800e0d5d34beff93db283784864

#### Nintendo - SuFami Turbo 🆗

✔️**STBIOS.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20SuFami%20Turbo/STBIOS.bin))

> size 262144
> crc 9b4ca911
> md5 d3a44ba7d42a74d3ac58cb9c14c6a5ca
> sha1 ef86ea192eed03d5c413fdbbfd46043be1d7a127

#### Nintendo - Super Game Boy 🆗

✔️**SGB1.sfc** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Game%20Boy/SGB1.sfc))

> size 262144
> crc 8a4a174f
> md5 b15ddb15721c657d82c5bab6db982ee9
> sha1 973e10840db683cf3faf61bd443090786b3a9f04

✔️**SGB2.sfc** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Game%20Boy/SGB2.sfc))

> size 524288
> crc cb176e45
> md5 8ecd73eb4edf7ed7e81aef1be80031d5
> sha1 e5b2922ca137051059e4269b236d07a22c07bc84

✔️**sgb1.boot.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Game%20Boy/sgb1.boot.rom))

> size 256
> crc ec8a83b9
> md5 d574d4f9c12f305074798f54c091a8b4
> sha1 aa2f50a77dfb4823da96ba99309085a3c6278515

✔️**sgb1.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Game%20Boy/sgb1.program.rom))

> size 262144
> crc 8a4a174f
> md5 b15ddb15721c657d82c5bab6db982ee9
> sha1 973e10840db683cf3faf61bd443090786b3a9f04

✔️**sgb2.boot.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Game%20Boy/sgb2.boot.rom))

> size 256
> crc 53d0dd63
> md5 e0430bca9925fb9882148fd2dc2418c1
> sha1 93407ea10d2f30ab96a314d8eca44fe160aea734

✔️**sgb2.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Game%20Boy/sgb2.program.rom))

> size 524288
> crc cb176e45
> md5 8ecd73eb4edf7ed7e81aef1be80031d5
> sha1 e5b2922ca137051059e4269b236d07a22c07bc84

✔️**sgb2_bios.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Game%20Boy/sgb2_bios.bin))

> size 256
> crc 53d0dd63
> md5 e0430bca9925fb9882148fd2dc2418c1
> sha1 93407ea10d2f30ab96a314d8eca44fe160aea734

✔️**sgb_bios.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Game%20Boy/sgb_bios.bin))

> size 256
> crc ec8a83b9
> md5 d574d4f9c12f305074798f54c091a8b4
> sha1 aa2f50a77dfb4823da96ba99309085a3c6278515

#### Nintendo - Super Nintendo Entertainment System 🆗

✔️**cx4.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/cx4.data.rom))

> size 3072
> crc b6e76a6a
> md5 037ac4296b6b6a5c47c440188d3c72e3
> sha1 a002f4efba42775a31185d443f3ed1790b0e949a

✔️**dsp1.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp1.data.rom))

> size 2048
> crc c8347cbd
> md5 3d81b45fa0c2aa8b852dfb1ece7c0971
> sha1 589c158685fe3cf88c7ca77cb6083f0e4de9c7c3

✔️**dsp1.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp1.program.rom))

> size 6144
> crc db9a4c92
> md5 ae209fbe789fbf11a48aea5ab1197321
> sha1 c5d283604beebb3d832f15a0b3fc60d10dd4bddc

✔️**dsp1b.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp1b.data.rom))

> size 2048
> crc 37a252c6
> md5 1e3f568634a7d8284020dddc0ae905bc
> sha1 19d5e822fe15ee6942e9921c3d8275a761a969df

✔️**dsp1b.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp1b.program.rom))

> size 6144
> crc 66a73998
> md5 d10f446888e097cbf500f3f663cf4f6d
> sha1 03c6c0bdb40846c42aeff6b716e1ea0e001c3ae3

✔️**dsp2.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp2.data.rom))

> size 2048
> crc b3893c70
> md5 e9417e29223b139c3c4b635a2a3b8744
> sha1 aed9167cc2897cd8d0432f0b8f713fabbc48f5c4

✔️**dsp2.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp2.program.rom))

> size 6144
> crc 0c1cf838
> md5 aa6e5922a3ed5ded54f24247c11143c5
> sha1 51a274955ef493cfcf2efad7e2ee54738c81eb15

✔️**dsp3.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp3.data.rom))

> size 2048
> crc 8b41a2bd
> md5 0a81210c0a940b997dd9843281008ee6
> sha1 e7ec3da203a4edba2b17c06d9384787304a025a0

✔️**dsp3.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp3.program.rom))

> size 6144
> crc f29be51c
> md5 d99ca4562818d49cee1f242705bba6f8
> sha1 11b7ba3501a8542af4cdfdbd1c9702ae0a0e3fae

✔️**dsp4.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp4.data.rom))

> size 2048
> crc efa8b9b2
> md5 ee4990879eb68e3cbca239c5bc20303d
> sha1 8f2ffb9c1702aa2f76191e98f3fef43f73e5aab7

✔️**dsp4.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/dsp4.program.rom))

> size 6144
> crc 14b77ae3
> md5 a151023b948b90ffc23a5b594bb6fef2
> sha1 1abee528a59238fd5668fdcffd598d079cb056c2

✔️**st010.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/st010.data.rom))

> size 4096
> crc 216081b2
> md5 254d70762b6f59f99c27c395aba7d07d
> sha1 bd116501ec41c438fff210fd03233c6c9d15a514

✔️**st010.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/st010.program.rom))

> size 49152
> crc 691cbb4f
> md5 1d70019179a59a566a0bb5d3f2845544
> sha1 2d0f34074ed3c6dfd61f767ee8b18e699b9769ac

✔️**st011.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/st011.data.rom))

> size 4096
> crc 803256a7
> md5 10bd3f4aa949737ab9836512c35bcc29
> sha1 798ab84110ca93a6e73a540f4146d21f8d9e1442

✔️**st011.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/st011.program.rom))

> size 49152
> crc a741e9fb
> md5 95222ebf1c0c2990bcf25db43743f032
> sha1 375eca92592621e83881f3a9d7fd5ea3e5b306dc

✔️**st018.data.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/st018.data.rom))

> size 32768
> crc b5255459
> md5 49c898b60d0f15e90d0ba780dd12f366
> sha1 b19c0f8f207d62fdabf4bf71442826063bccc626

✔️**st018.program.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Nintendo%20-%20Super%20Nintendo%20Entertainment%20System/st018.program.rom))

> size 131072
> crc f73d5e10
> md5 dda40ccd57390c96e49d30a041f9a9e7
> sha1 388e3721b94cd074d6ba0eca8616523d2118a6c3

#### Phillips - Videopac+ 🆗

✔️**c52.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Phillips%20-%20Videopac%2B/c52.bin))

> size 1024
> crc a318e8d6
> md5 f1071cdb0b6b10dde94d3bc8a6146387
> sha1 a6120aed50831c9c0d95dbdf707820f601d9452e

✔️**g7400.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Phillips%20-%20Videopac%2B/g7400.bin))

> size 1024
> crc e20a9f41
> md5 c500ff71236068e0dc0d0603d265ae76
> sha1 5130243429b40b01a14e1304d0394b8459a6fbae

✔️**jopac.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Phillips%20-%20Videopac%2B/jopac.bin))

> size 1024
> crc 11647ca5
> md5 279008e4a0db2dc5f1c048853b033828
> sha1 54b8d2c1317628de51a85fc1c424423a986775e4

#### Sega - Dreamcast 🆗

✔️**dc_boot.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Dreamcast/dc_boot.bin))

> size 2097152
> crc 89f2b1a1
> md5 e10c53c2f8b90bab96ead2d368858623
> sha1 8951d1bb219ab2ff8583033d2119c899cc81f18c

✔️**dc_flash.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Dreamcast/dc_flash.bin))

> size 131072
> crc c611b498
> md5 0a93f7940c455905bea6e392dfde92a4
> sha1 94d44d7f9529ec1642ba3771ed3c5f756d5bc872

✔️**naomi_boot.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Dreamcast/naomi_boot.bin))

> size 2097152
> crc d2a1c6bf
> md5 3bffafac42a7767d8dcecf771f5552ba
> sha1 6d27d71aec4dfba98f66316ae74a1426d567698a

#### Sega - Game Gear 🆗

✔️**bios.gg** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Game%20Gear/bios.gg))

> size 1024
> crc 0ebea9d4
> md5 672e104c3be3a238301aceffc3b23fd6
> sha1 914aa165e3d879f060be77870d345b60cfeb4ede

#### Sega - Master System - Mark III 🆗

✔️**bios.sms** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Master%20System%20-%20Mark%20III/bios.sms))

> size 8192
> crc 0072ed54
> md5 840481177270d5642a14ca71ee72844c
> sha1 c315672807d8ddb8d91443729405c766dd95cae7

✔️**bios_E.sms** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Master%20System%20-%20Mark%20III/bios_E.sms))

> size 8192
> crc 0072ed54
> md5 840481177270d5642a14ca71ee72844c
> sha1 c315672807d8ddb8d91443729405c766dd95cae7

✔️**bios_J.sms** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Master%20System%20-%20Mark%20III/bios_J.sms))

> size 8192
> crc 48d44a13
> md5 24a519c53f67b00640d0048ef7089105
> sha1 a8c1b39a2e41137835eda6a5de6d46dd9fadbaf2

✔️**bios_U.sms** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Master%20System%20-%20Mark%20III/bios_U.sms))

> size 8192
> crc 0072ed54
> md5 840481177270d5642a14ca71ee72844c
> sha1 c315672807d8ddb8d91443729405c766dd95cae7

#### Sega - Mega CD - Sega CD 🆗

✔️**bios_CD_E.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20CD%20-%20Sega%20CD/bios_CD_E.bin))

> size 131072
> crc 529ac15a
> md5 e66fa1dc5820d254611fdcdba0662372
> sha1 f891e0ea651e2232af0c5c4cb46a0cae2ee8f356

✔️**bios_CD_J.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20CD%20-%20Sega%20CD/bios_CD_J.bin))

> size 131072
> crc 9d2da8f2
> md5 278a9397d192149e84e820ac621a8edd
> sha1 4846f448160059a7da0215a5df12ca160f26dd69

✔️**bios_CD_U.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20CD%20-%20Sega%20CD/bios_CD_U.bin))

> size 131072
> crc c6d10268
> md5 2efd74e3232ff260e371b99f84024f7f
> sha1 f4f315adcef9b8feb0364c21ab7f0eaf5457f3ed

#### Sega - Mega Drive - Genesis 🆗

✔️**areplay.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20Drive%20-%20Genesis/areplay.bin))

> size 32768
> crc 95ff7c3e
> md5 a0028b3043f9d59ceeb03da5b073b30d
> sha1 1e0f246826be4ebc7b99bb3f9de7f1de347122e5

✔️**bios_MD.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20Drive%20-%20Genesis/bios_MD.bin))

> size 2048
> crc 3f888cf4
> md5 d3293ebaaa7f4eb2a6766b68a0fb4609
> sha1 3f50b76b0529db7f79c396b5e808cc0786ffc311

✔️**ggenie.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20Drive%20-%20Genesis/ggenie.bin))

> size 32768
> crc 14dbce4a
> md5 e8af7fe115a75c849f6aab3701e7799b
> sha1 937e1878ebd104f489e6bdbc410a184f79f1144a

✔️**rom.db** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20Drive%20-%20Genesis/rom.db))

> size 17742
> crc c94e8c8b
> md5 ff4a3572475236e859e3e9ac5c87d1f1
> sha1 02c287d10da6de579af7a4ce73b134bbdf23c970

✔️**sk.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20Drive%20-%20Genesis/sk.bin))

> size 2097152
> crc 0658f691
> md5 4ea493ea4e9f6c9ebfccbdb15110367e
> sha1 88d6499d874dcb5721ff58d76fe1b9af811192e3

✔️**sk2chip.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Mega%20Drive%20-%20Genesis/sk2chip.bin))

> size 262144
> crc 4dcfd55c
> md5 b4e76e416b887f4e7413ba76fa735f16
> sha1 70429f1d80503a0632f603bf762fe0bbaa881d22

#### Sega - Saturn 🆗

✔️**hisaturn.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/hisaturn.bin))

> size 524288
> crc 721e1b60
> md5 3ea3202e2634cb47cb90f3a05c015010
> sha1 49d8493008fa715ca0c94d99817a5439d6f2c796

✔️**mpr-17933.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/mpr-17933.bin))

> size 524288
> crc 4afcf0fa
> md5 3240872c70984b6cbfda1586cab68dbe
> sha1 faa8ea183a6d7bbe5d4e03bb1332519800d3fbc3

✔️**mpr-18100.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/mpr-18100.bin))

> size 524288
> crc 3408dbf4
> md5 cb2cebc1b6e573b7c44523d037edcd45
> sha1 8a22710e09ce75f39625894366cafe503ed1942d

✔️**mpr-18811-mx.ic1** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/mpr-18811-mx.ic1))

> size 2097152
> crc 90412e10
> md5 255113ba943c92a54facd25a10fd780c
> sha1 a67cd4f550751f8b91de2b8b74528ab4e0c11c77

✔️**mpr-19367-mx.ic1** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/mpr-19367-mx.ic1))

> size 2097152
> crc b9644b52
> md5 1cd19988d1d72a3e7caa0b73234c96b4
> sha1 56c1b93da6b660bf393fbf48ca47569000ef4047

✔️**saturn_bios.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/saturn_bios.bin))

> size 524288
> crc 2aba43c2
> md5 af5828fdff51384f99b3c4926be27762
> sha1 2b8cb4f87580683eb4d760e4ed210813d667f0a2

✔️**sega1003.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/sega1003.bin))

> size 524288
> crc b3c63c25
> md5 74570fed4d44b2682b560c8cd44b8b6a
> sha1 7b23b53d62de0f29a23e423d0fe751dfb469c2fa

✔️**sega_100.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/sega_100.bin))

> size 524288
> crc 2aba43c2
> md5 af5828fdff51384f99b3c4926be27762
> sha1 2b8cb4f87580683eb4d760e4ed210813d667f0a2

✔️**sega_100a.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/sega_100a.bin))

> size 524288
> crc f90f0089
> md5 f273555d7d91e8a5a6bfd9bcf066331c
> sha1 3bb41feb82838ab9a35601ac666de5aacfd17a58

✔️**sega_101.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/sega_101.bin))

> size 524288
> crc 224b752c
> md5 85ec9ca47d8f6807718151cbcca8b964
> sha1 df94c5b4d47eb3cc404d88b33a8fda237eaf4720

✔️**vsaturn.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sega%20-%20Saturn/vsaturn.bin))

> size 524288
> crc e4d61811
> md5 ac4e4b6522e200c0d23d371a8cecbfd3
> sha1 4154e11959f3d5639b11d7902b3a393a99fb5776

#### Sharp - X1 🆗

✔️**iplrom.x1** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sharp%20-%20X1/iplrom.x1))

> size 4096
> crc e70011d3
> md5 eeeea1cd29c6e0e8b094790ae969bfa7
> sha1 d3395e9aeb5b8bbba7654dd471bcd8af228ee69a

✔️**iplrom.x1t** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sharp%20-%20X1/iplrom.x1t))

> size 2048
> crc e3995a57
> md5 851e4a5936f17d13f8c39a980cf00d77
> sha1 1c1a0d8c9f4c446ccd7470516b215ddca5052fb2

#### Sharp - X68000 🆗

✔️**cgrom.dat** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sharp%20-%20X68000/cgrom.dat))

> size 786432
> crc 9f3195f1
> md5 cb0a5cfcf7247a7eab74bb2716260269
> sha1 8d72c5b4d63bb14c5dbdac495244d659aa1498b6

✔️**iplrom.dat** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sharp%20-%20X68000/iplrom.dat))

> size 131072
> crc 72bdf532
> md5 7fd4caabac1d9169e289f0f7bbf71d8e
> sha1 0ed038ed2133b9f78c6e37256807424e0d927560

✔️**iplrom30.dat** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sharp%20-%20X68000/iplrom30.dat))

> size 131072
> crc e8f8fdad
> md5 f373003710ab4322642f527f567e020a
> sha1 239e9124568c862c31d9ec0605e32373ea74b86a

✔️**iplromco.dat** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sharp%20-%20X68000/iplromco.dat))

> size 131072
> crc 6c7ef608
> md5 cc78d4f4900f622bd6de1aed7f52592f
> sha1 77511fc58798404701f66b6bbc9cbde06596eba7

✔️**iplromxv.dat** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sharp%20-%20X68000/iplromxv.dat))

> size 131072
> crc 00eeb408
> md5 0617321daa182c3f3d6f41fd02fb3275
> sha1 e33cdcdb69cd257b0b211ef46e7a8b144637db57

#### Sinclair - ZX Spectrum 🆗

✔️**128-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/128-0.rom))

> size 16384
> crc e76799d2
> md5 b4d2692115a9f2924df92a3cbfb358fb
> sha1 4f4b11ec22326280bdb96e3baf9db4b4cb1d02c5

✔️**128-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/128-1.rom))

> size 16384
> crc b96a36be
> md5 6e09e5d3c4aef166601669feaaadc01c
> sha1 80080644289ed93d71a1103992a154cc9802b2fa

✔️**128-spanish-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/128-spanish-0.rom))

> size 16384
> crc 453d86b2
> md5 c1231a70b8129311216acb7479b031d5
> sha1 968937b1c750f0ef6205f01c6db4148da4cca4e3

✔️**128-spanish-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/128-spanish-1.rom))

> size 16384
> crc 6010e796
> md5 4f341936594cbcab75cfa62ce96e3682
> sha1 bea3f397cc705eafee995ea629f4a82550562f90

✔️**128p-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/128p-0.rom))

> size 16384
> crc 124ad9e0
> md5 a249565f03b98d004ee7f019570069cd
> sha1 d07fcdeca892ee80494d286ea9ea5bf3928a1aca

✔️**128p-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/128p-1.rom))

> size 16384
> crc b96a36be
> md5 6e09e5d3c4aef166601669feaaadc01c
> sha1 80080644289ed93d71a1103992a154cc9802b2fa

✔️**256s-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/256s-0.rom))

> size 16384
> crc 0eb40a09
> md5 b9fda5b6a747ff037365b0e2d8c4379a
> sha1 477114ff0fe1388e0979df1423602b21248164e5

✔️**256s-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/256s-1.rom))

> size 16384
> crc 9d513013
> md5 643861ad34831b255bf2eb64e8b6ecb8
> sha1 367b5a102fb663beee8e7930b8c4acc219c1f7b3

✔️**256s-2.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/256s-2.rom))

> size 16384
> crc fd0d3ce1
> md5 d8ad507b1c915a9acfe0d73957082926
> sha1 07783ee295274d8ff15d935bfd787c8ac1d54900

✔️**256s-3.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/256s-3.rom))

> size 16384
> crc 1fe1d003
> md5 ce0723f9bc02f4948c15d3b3230ae831
> sha1 33703e97cc93b7edfcc0334b64233cf81b7930db

✔️**48.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/48.rom))

> size 16384
> crc ddee531f
> md5 4c42a2f075212361c3117015b107ff68
> sha1 5ea7c2b824672e914525d1d5c419d71b84a426a2

✔️**disciple.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/disciple.rom))

> size 8192
> crc 82047489
> md5 78e61a2a02121873c1756b21fd1398b1
> sha1 9a75ed4b293f968985be4c9aa893cd88276d1ced

✔️**disk_plus3.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/disk_plus3.szx))

> size 1568
> crc c2c6cba7
> md5 e6db6b9f6ad15012851115a7bc4b31d8
> sha1 d7896640e18fc6204aa494835b0a430250fb06ce

✔️**gluck.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/gluck.rom))

> size 16384
> crc ca321d79
> md5 d5869034604dbfd2c1d54170e874fd0a
> sha1 015eb96dafb273d4f4512c467e9b43c305fd1bc4

✔️**if1-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/if1-1.rom))

> size 8192
> crc e72a12ae
> md5 5c11c61a2dd2ca4bf39328d9ff42d289
> sha1 4ffd9ed9c00cdc6f92ce69fdd8b618ef1203f48e

✔️**if1-2.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/if1-2.rom))

> size 8192
> crc bb66dd1e
> md5 31b704ae925305e74f50699271fddd9a
> sha1 5cfb6bca4177c45fefd571734576b55e3a127c08

✔️**plus2-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus2-0.rom))

> size 16384
> crc 5d2e8c66
> md5 4ed7af4636308b8a48d7a35e6c5b546b
> sha1 72703f9a3e734f3c23ec34c0727aae4ccbef9a91

✔️**plus2-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus2-1.rom))

> size 16384
> crc 98b1320b
> md5 b3db95931cc844efaeb82db9c171b9f3
> sha1 de8b0d2d0379cfe7c39322a086ca6da68c7f23cb

✔️**plus3-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus2-1.rom))

> size 16384
> crc 7f4a5482
> md5 bc123f625e245c225f92ef05933ed134
> sha1 649fbd233490bf58b35350b0123d36caaaa011eb

✔️**plus3-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus3-1.rom))

> size 16384
> crc 5aeb4675
> md5 617364264c587d20c9fc4746c29679f2
> sha1 f12198108cbb14de4f03c6695bc16d08c85ee214

✔️**plus3-2.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus3-2.rom))

> size 16384
> crc 504755cb
> md5 c363e95dcd0a90e6e7f847e6e47e0179
> sha1 773633dce5ba323a9e00d9d0f9e4d8c295df7c87

✔️**plus3-3.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus3-3.rom))

> size 16384
> crc 04448eaa
> md5 a148bcc575e51389e84fdf5d555c3196
> sha1 65f031caa8148a5493afe42c41f4929deab26b4e

✔️**plus3e-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus3e-0.rom))

> size 16384
> crc a10230c0
> md5 3abdc20e72890a750dd3c745d286dfba
> sha1 a837f66977040f7b51ed053a2483c10f3d070ab7

✔️**plus3e-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus3e-1.rom))

> size 16384
> crc 09b9c3ca
> md5 8361a1d9c8bcef89c0c39293776564ad
> sha1 6a4364f25513e4079f048f2de131a896d30edc64

✔️**plus3e-2.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus3e-2.rom))

> size 16384
> crc a60285a0
> md5 f36c5c2d1f2a682caadeaa6f947db0da
> sha1 0a747cc0b827a94b4fd74cfd818ca792437a38f7

✔️**plus3e-3.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plus3e-3.rom))

> size 16384
> crc 04448eaa
> md5 a148bcc575e51389e84fdf5d555c3196
> sha1 65f031caa8148a5493afe42c41f4929deab26b4e

✔️**plusd.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/plusd.rom))

> size 8192
> crc 569f7e55
> md5 42e5de16fb5e50082bb954ec7ce45851
> sha1 6b841dc5797ef7eb219ad455cd1e434ca3b9d30d

✔️**se-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/se-0.rom))

> size 16384
> crc 8f1047d2
> md5 fb3f86eb1e5a695d9c50c124e7cfb875
> sha1 8608328d7dd66602a4846f046b24fed500f7d828

✔️**se-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/se-1.rom))

> size 16384
> crc 16ed3a9b
> md5 88de4a3129086f34bb9ca559acc51e6c
> sha1 3be5de57dd3bd0a9d15c57cabe9179afe2906a52

✔️**speccyboot-1.4.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/speccyboot-1.4.rom))

> size 8192
> crc 37c591b2
> md5 c54aa8f374b0971f51546c29d5d1eba1
> sha1 16af6f052b38a027dd49ba6e96e3a59d16b62672

✔️**tape_128.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_128.szx))

> size 1464
> crc 8d1c41f4
> md5 8942b43b73ed4eb7f32bd1741709a4dc
> sha1 3b1287bfc6fec9c7dd838f6ea1706698cb96fd16

✔️**tape_16.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_16.szx))

> size 591
> crc ccda9cc2
> md5 fec97eb9ea1b017cae84de78508feb4a
> sha1 ec9e5607ce7faf2d6a5d71e5e21188ca86e963a1

✔️**tape_2048.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_2048.szx))

> size 720
> crc dbc1a386
> md5 116f732bbae4e49d625aaf2f311474d0
> sha1 f2d2227dce697df8aac78883eaf966e71435caa3

✔️**tape_2068.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_2068.szx))

> size 1799
> crc 659b428d
> md5 0b0f267b95d556318bb652af2e8dc25c
> sha1 5af71025c02358b325bf8b4bfaa2662488abf1d2

✔️**tape_48.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_48.szx))

> size 708
> crc f56f230d
> md5 ee2ae810711594db3a134a7432baabff
> sha1 d6e092730f822c9e8828ca12f54eb8d65228f30c

✔️**tape_pentagon.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_pentagon.szx))

> size 1479
> crc c7a272b6
> md5 bd7698603bd9079d337cdedfb04942d9
> sha1 7e1eb0e250cfe1f2f0e50f734378a738e8bf327f

✔️**tape_plus2.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_plus2.szx))

> size 1571
> crc 93195e18
> md5 166d4aa1a5aa4fbd99cc963b4e7c19cc
> sha1 4a6d8941eee86d7e52452f5aaaa73d4bafe9bde1

✔️**tape_plus2a.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_plus2a.szx))

> size 1617
> crc 45727b82
> md5 445d4817d5557bb363a216fbd6eeaa84
> sha1 e0e0f6ebc8261ae9768a6be772eab4718fbc2395

✔️**tape_plus3.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_plus3.szx))

> size 1856
> crc 1a825690
> md5 0dc8828ac1db2e0efa915ac55191e96f
> sha1 3850f7e5e6c90fd4dac988da77717d2647d9c021

✔️**tape_plus3e.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_plus3e.szx))

> size 1970
> crc 4ce6538f
> md5 bf07537f028bbcb3309464bd30da779c
> sha1 92ac0df41f3ea7f147f4d6bae6b8a7d79b4f7e92

✔️**tape_scorpion.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_scorpion.szx))

> size 3500
> crc eb6a7a83
> md5 c10e677d3deb5a445689d3a599880745
> sha1 6abdeb434755d25a280954ce07b50b6a28b36957

✔️**tape_se.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_se.szx))

> size 2146
> crc 92bc2f43
> md5 2518f9334bef8c44804a4185085579b5
> sha1 cc20a8e6fc8c493881b14e00545a42ef75b8aabe

✔️**tape_ts2068.szx** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tape_ts2068.szx))

> size 1840
> crc 06ad712e
> md5 1d360c09d370bb52a9a44b30cc7c59e6
> sha1 562298f5b3a7ed28f0129b066e8ad098a10e2270

✔️**tc2048.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tc2048.rom))

> size 16384
> crc f1b5fa67
> md5 9dd7ecf784a6c04265c073c236f5fadb
> sha1 febb2d495b6eda7cdcb4074935d6e9d9f328972d

✔️**tc2068-0.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tc2068-0.rom))

> size 16384
> crc bf44ec3f
> md5 55d462fccc6c536037404ef4ced08bec
> sha1 1446cb2780a9dedf640404a639fa3ae518b2d8aa

✔️**tc2068-1.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/tc2068-1.rom))

> size 8192
> crc ae16233a
> md5 575d203c6e15e679fba0b73f854ec7a2
> sha1 7e265a2c1f621ed365ea23bdcafdedbc79c1299c

✔️**trdos.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sinclair%20-%20ZX%20Spectrum/trdos.rom))

> size 16384
> crc 10751aba
> md5 0da70a5d2a0e733398e005b96b7e4ba6
> sha1 21695e3f2a8f796386ce66eea8a246b0ac44810c

#### SNK - NeoGeo CD 🆗

✔️**000-lo.lo** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/000-lo.lo))

> size 131072
> crc 5a86cff2
> md5 fc7599f3f871578fe9a0453662d1c966
> sha1 5992277debadeb64d1c1c64b0a92d9293eaf7e4a

✔️**front-sp1.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/front-sp1.bin))

> size 524288
> crc cac62307
> md5 5c2366f25ff92d71788468ca492ebeca
> sha1 53bc1f283cdf00fa2efbb79f2e36d4c8038d743a

✔️**neocd.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/neocd.bin))

> size 524288
> crc df9de490
> md5 f39572af7584cb5b3f70ae8cc848aba2
> sha1 7bb26d1e5d1e930515219cb18bcde5b7b23e2eda

✔️**neocd_f.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/neocd_f.rom))

> size 524288
> crc 6fd2a520
> md5 8834880c33164ccbe6476b559f3e37de
> sha1 a5f4a7a627b3083c979f6ebe1fabc5d2df6d083b

✔️**neocd_sf.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/neocd_sf.rom))

> size 524288
> crc 1101f313
> md5 043d76d5f0ef836500700c34faef774d
> sha1 4a94719ee5d0e3f2b981498f70efc1b8f1cef325

✔️**neocd_st.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/neocd_st.rom))

> size 524288
> crc 01c299cc
> md5 f6325a33c6d63ea4b9162a3fa8c32727
> sha1 19729b51bdab60c42aafef6e20ea9234c7eb8410

✔️**neocd_sz.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/neocd_sz.rom))

> size 524288
> crc 42f6b6c4
> md5 971ee8a36fb72da57aed01758f0a37f5
> sha1 6a947457031dd3a702a296862446d7485aa89dbb

✔️**neocd_t.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/neocd_t.rom))

> size 524288
> crc 56c9ecba
> md5 de3cf45d227ad44645b22aa83b49f450
> sha1 cc92b54a18a8bff6e595aabe8e5c360ba9e62eb5

✔️**neocd_z.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/neocd_z.rom))

> size 524288
> crc 33697892
> md5 11526d58d4c524daef7d5d677dc6b004
> sha1 b0f1c4fa8d4492a04431805f6537138b842b549f

✔️**top-sp1.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/top-sp1.bin))

> size 524288
> crc c36a47c0
> md5 122aee210324c72e8a11116e6ef9c0d0
> sha1 235f4d1d74364415910f73c10ae5482d90b4274f

✔️**uni-bioscd.rom** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/SNK%20-%20NeoGeo%20CD/uni-bioscd.rom))

> size 524288
> crc ff3abc59
> md5 08ca8b2dba6662e8024f9e789711c6fc
> sha1 5142f205912869b673a71480c5828b1eaed782a8

#### Sony - PlayStation 🆗

🔥**PSXONPSP660.BIN** ([download](https://github.com/Abdess/retroarch_system/blob/Other/Sony%20-%20PlayStation/PSXONPSP660.BIN)) ([infos](https://github.com/gingerbeardman/PSX))

  **Note: This BIOS improves emulation, rename it by the name of the BIOS used by your emulator. For example: scph5500.bin.**

> size 524288
> crc 5660f34f
> md5 c53ca5908936d412331790f4426c6c33
> sha1 96880d1ca92a016ff054be5159bb06fe03cb4e14

✔️**scph1000.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph1000.bin))

> size 524288
> crc 3b601fc8
> md5 239665b1a3dade1b5a52c06338011044
> sha1 343883a7b555646da8cee54aadd2795b6e7dd070

✔️**scph1001.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph1001.bin))

> size 524288
> crc 37157331
> md5 924e392ed05558ffdb115408c263dccf
> sha1 10155d8d6e6e832d6ea66db9bc098321fb5e8ebf

✔️**scph1002.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph1002.bin))

> size 524288
> crc 9bb87c4b
> md5 54847e693405ffeb0359c6287434cbef
> sha1 20b98f3d80f11cbf5a7bfd0779b0e63760ecc62c

✔️**scph100.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph100.bin))

> size 524288
> crc f2af798b
> md5 8abc1b549a4a80954addc48ef02c4521
> sha1 339a48f4fcf63e10b5b867b8c93cfd40945faf6c

✔️**scph101.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph101.bin))

> size 524288
> crc 171bdcec
> md5 6e3735ff4c7dc899ee98981385f6f3d0
> sha1 dcffe16bd90a723499ad46c641424981338d8378

✔️**scph102A.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph102A.bin))

> size 524288
> crc 0bad7ea9
> md5 b10f5e0e3d9eb60e5159690680b1e774
> sha1 beb0ac693c0dc26daf5665b3314db81480fa5c7c

✔️**scph102B.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph102B.bin))

> size 524288
> crc 76b880e5
> md5 de93caec13d1a141a40a79f5c86168d6
> sha1 dbc7339e5d85827c095764fc077b41f78fd2ecae


✔️**scph102C.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph102C.bin))

> size 524288
> crc 76b880e5
> md5 de93caec13d1a141a40a79f5c86168d6
> sha1 dbc7339e5d85827c095764fc077b41f78fd2ecae


✔️**scph3000.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph3000.bin))

> size 524288
> crc 3539def6
> md5 849515939161e62f6b866f6853006780
> sha1 b06f4a861f74270be819aa2a07db8d0563a7cc4e


✔️**scph3500.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph3500.bin))

> size 524288
> crc bc190209
> md5 cba733ceeff5aef5c32254f1d617fa62
> sha1 e38466a4ba8005fba7e9e3c7b9efeba7205bee3f


✔️**scph5000.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph5000.bin))

> size 524288
> crc 8c93a399
> md5 eb201d2d98251a598af467d4347bb62f
> sha1 e340db2696274dda5fdc25e434a914db71e8b02b


✔️**scph5500.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph5500.bin))

> size 524288
> crc ff3eeb8c
> md5 8dd7d5296a650fac7319bce665a6a53c
> sha1 b05def971d8ec59f346f2d9ac21fb742e3eb6917

✔️**scph5501.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph5501.bin))

> size 524288
> crc 8d8cb7e4
> md5 490f666e1afb15b7362b406ed1cea246
> sha1 0555c6fae8906f3f09baf5988f00e55f88e9f30b

✔️**scph5502.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph5502.bin))

> size 524288
> crc d786f0b9
> md5 32736f17079d0b2b7024407c39bd3050
> sha1 f6bc2d1f5eb6593de7d089c425ac681d6fffd3f0

✔️**scph5552.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStationscph5552.bin))

> size 524288
> crc d786f0b9
> md5 32736f17079d0b2b7024407c39bd3050
> sha1 f6bc2d1f5eb6593de7d089c425ac681d6fffd3f0

✔️**scph7001.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph7001.bin))

> size 524288
> crc 502224b6
> md5 1e68c231d0896b7eadcad1d7d8e76129
> sha1 14df4f6c1e367ce097c11deae21566b4fe5647a9

✔️**scph7002.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph7002.bin))

> size 524288
> crc 318178bf
> md5 b9d9a0286c33dc6b7237bb13cd46fdee
> sha1 8d5de56a79954f29e9006929ba3fed9b6a418c1d

✔️**scph7003.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph7003.bin))

> size 524288
> crc 8d8cb7e4
> md5 490f666e1afb15b7362b406ed1cea246
> sha1 0555c6fae8906f3f09baf5988f00e55f88e9f30b

✔️**scph7502.bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph7502.bin))

> size 524288
> crc 318178bf
> md5 b9d9a0286c33dc6b7237bb13cd46fdee
> sha1 8d5de56a79954f29e9006929ba3fed9b6a418c1d

✔️**scph9002(7502).bin** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation/scph9002(7502).bin))

> size 524288
> crc 318178bf
> md5 b9d9a0286c33dc6b7237bb13cd46fdee
> sha1 8d5de56a79954f29e9006929ba3fed9b6a418c1d

#### Sony - PlayStation Portable 🆗

✔️**ppge_atlas.zim** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Sony%20-%20PlayStation%20Portable/ppge_atlas.zim))

> size 666530
> crc 7b57fa78
> md5 866855cc330b9b95cc69135fb7b41d38
> sha1 30a33f3651f8e1b0967a5dfe6ff714baebcce41a

#### Wolfenstein 3D 🆗

✔️**ecwolf.pk3** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/Wolfenstein%203D/ecwolf.pk3))

> size 178755
> crc 26dc3fba
> md5 c011b428819eea4a80b455c245a5a04d
> sha1 9259b87edfe9b9f6d0749788a75a6ccf158f50aa

#### ScummVM 🆗

✔️**scummvm.zip** ([download](https://github.com/Abdess/retroarch_system/raw/libretro/ScummVM/scummvm.zip))

> size 9523360
> crc a93f1c4b
> md5 a17e0e0150155400d8cced329563d9c8
> sha1 718c1a00d38e0810a1ad0ffde79f73447f846f01
