/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.bluetooth;

import com.lemonquest.bluetooth.BluetoothSettings;
import com.lemonquest.bluetooth.ClientThread;
import com.lemonquest.bluetooth.Log;
import com.lemonquest.bluetooth.Processor;
import com.lemonquest.bluetooth.ServerThread;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.StreamConnection;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BlueToothProtocol {
    public Hashtable a;
    public EventHandler ui;
    public String userName;
    public Vector foundDevices;
    public Hashtable foundServices;
    public Vector foundServicesName;
    public byte mode;
    private byte a;
    public int searchDeviceIndex;
    private ClientThread a;
    private ServerThread a;
    public static String url = "btspp://localhost:" + BluetoothSettings.UUID + ";authenticate=false" + ";authorize=false" + ";encrypt=false" + ";name=BluetoothApplication";
    public ByteArrayOutputStream a;
    public DataOutputStream a;
    public byte[] b;
    public byte[] a;
    public int a = 0;

    public BlueToothProtocol(EventHandler eventHandler) {
        this.foundDevices = new Vector();
        this.foundServices = new Hashtable();
        this.foundServicesName = new Vector();
        this.a = (byte)-1;
        try {
            this.ui = eventHandler;
            this.setUserName(LocalDevice.getLocalDevice().getFriendlyName());
            return;
        }
        catch (BluetoothStateException bluetoothStateException) {
            this.setUserName("unkownUser");
            eventHandler.error(bluetoothStateException.getMessage(), (byte)1, "BlueToothProtocol");
            bluetoothStateException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            eventHandler.error(exception.getMessage(), (byte)1, "Not support bluetooth");
            exception.printStackTrace();
            return;
        }
    }

    public void handleServerConnection(StreamConnection streamConnection) {
        new a(this, streamConnection).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killClientThread() {
        BlueToothProtocol blueToothProtocol = this;
        synchronized (blueToothProtocol) {
            if (this.a != null) {
                this.a.cancelSearch();
                this.a.a = false;
                this.a = (byte)3;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                this.a = null;
                this.a();
                Log.log("kill current client thread");
                System.gc();
            } else {
                Log.log("can not kill current client thread,is null now");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killServerThread() {
        BlueToothProtocol blueToothProtocol = this;
        synchronized (blueToothProtocol) {
            if (this.a != null) {
                this.a.isRunning = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                this.a.closeServer();
                this.a = null;
                Log.log("kill current server thread");
                System.gc();
            } else {
                Log.log("can not kill current server thread,is null now");
            }
            return;
        }
    }

    public void handleClientConnection(StreamConnection streamConnection, String string) {
        try {
            DataOutputStream dataOutputStream = streamConnection.openDataOutputStream();
            Log.log("Write bt address.");
            this.a(dataOutputStream, LocalDevice.getLocalDevice().getBluetoothAddress());
            this.handleConnection(streamConnection, string, streamConnection.openDataInputStream(), dataOutputStream);
            return;
        }
        catch (Exception exception) {
            this.ui.error(exception.getMessage(), (byte)5, "BlueToothProtocol-handleclientconnection");
            try {
                streamConnection.close();
                return;
            }
            catch (IOException iOException) {
                this.ui.error(iOException.getMessage(), (byte)5, "BlueToothProtocol-close_Clientconnection");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(StreamConnection streamConnection, String string, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws Exception {
        string = string.toLowerCase();
        Hashtable hashtable = this.a;
        synchronized (hashtable) {
            if (!this.a.containsKey(string)) {
                Log.log("Write user name.");
                this.a(dataOutputStream, this.userName);
                Log.log("Read user name.");
                String string2 = this.a(dataInputStream);
                Log.log("userName: " + string2);
                Processor processor = new Processor(this, string, streamConnection, dataInputStream, dataOutputStream, string2);
                processor.start();
                this.a.put(string, processor);
                Log.log("Start message read thread");
            } else {
                streamConnection.close();
            }
            return;
        }
    }

    public boolean hasConnection(String string) {
        try {
            return this.a.containsKey(string.toLowerCase()) || string.toUpperCase().equals(LocalDevice.getLocalDevice().getBluetoothAddress().toUpperCase());
        }
        catch (BluetoothStateException bluetoothStateException) {
            this.ui.error(bluetoothStateException.getMessage(), (byte)5, "clientConnection is exit");
            return true;
        }
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastMessage(byte[] byArray) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Processor processor = (Processor)enumeration.nextElement();
            Vector vector = processor.sendMessages;
            synchronized (vector) {
                processor.sendMessages.addElement(byArray);
                processor.sendMessages.notify();
            }
        }
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setState(byte by) {
        this.a = by;
    }

    public byte getState() {
        return this.a;
    }

    public void startUpService() {
        this.setMode((byte)1);
        this.a = null;
        this.a = new ServerThread(this);
        this.a.start();
        Log.log("create new server thread");
        this.a.clear();
    }

    public void findDevices() {
        if (this.a != 0 && this.a != 2) {
            this.setMode((byte)0);
            this.a = 0;
            if (this.a == null) {
                this.a = new ClientThread(this);
                this.a.a = true;
                this.a.start();
                Log.log("create new find thread");
            }
            this.a();
            this.a.clear();
        }
    }

    public final void a() {
        this.foundDevices.removeAllElements();
        Enumeration enumeration = this.foundServices.keys();
        while (enumeration.hasMoreElements()) {
            this.foundServices.remove(enumeration.nextElement());
        }
        this.foundServicesName.removeAllElements();
    }

    public void makeConnect(int n) {
        if (this.getState() != 2) {
            this.a.ServiceConnIndex = n;
            this.a = (byte)2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void CloseConnection() {
        try {
            Enumeration enumeration = this.a.elements();
            while (true) {
                Processor processor;
                if (!enumeration.hasMoreElements()) {
                    this.killServerThread();
                    this.killClientThread();
                    this.a();
                    return;
                }
                Processor processor2 = processor = (Processor)enumeration.nextElement();
                // MONITORENTER : processor
                Log.log("Close bluetooth connection.--" + processor.a);
                processor.close();
                this.a.remove(processor);
                System.gc();
                // MONITOREXIT : processor2
            }
        }
        catch (Exception exception) {
            Log.log("close connection error");
            exception.printStackTrace();
            return;
        }
    }

    public int getFindServiceSize() {
        return this.foundServicesName.size();
    }

    public String getFindServiceName(int n) {
        String string = (String)this.foundServicesName.elementAt(n);
        return string;
    }

    public void sendMessange() {
        this.broadcastMessage(this.b);
    }

    public void CycleSegment(byte[] byArray) {
        if (this.a != null) {
            this.a = null;
        }
        this.a = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.a, 0, byArray.length);
        this.ui.CycleSegment(this.a);
    }

    public void newSegment() {
        if (this.a != null) {
            this.a = null;
        }
        if (this.a != null) {
            this.a = null;
        }
        this.a = new ByteArrayOutputStream(10);
        this.a = new DataOutputStream(this.a);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.a.writeByte(1);
        this.a.writeByte(bl ? 1 : 0);
    }

    public void writeByte(byte by) throws IOException {
        this.a.writeByte(2);
        this.a.writeByte(by);
    }

    public void writeChar(char c) throws IOException {
        this.a.writeByte(3);
        this.a.writeByte((byte)(c >> 8));
        this.a.writeByte((byte)c);
    }

    public void writeInt(int n) throws IOException {
        this.a.writeByte(4);
        this.a.writeByte((byte)(n >> 24));
        this.a.writeByte((byte)(n >> 16));
        this.a.writeByte((byte)(n >> 8));
        this.a.writeByte((byte)n);
    }

    public void writeShort(short s) throws IOException {
        this.a.writeByte(6);
        this.a.writeByte((byte)(s >> 8));
        this.a.writeByte((byte)s);
    }

    public void writeString(String string) throws IOException {
        this.a.writeByte(7);
        this.a.writeUTF(string == null ? "" : string);
    }

    public void flush() {
        try {
            this.a.flush();
        }
        catch (Exception exception) {}
        this.b = this.a.toByteArray();
        this.sendMessange();
    }

    public boolean readBoolean() {
        this.a += 2;
        return (this.a[this.a - 1] & 1) == 1;
    }

    public byte readByte() {
        this.a += 2;
        return this.a[this.a - 1];
    }

    public char readChar() {
        this.a += 3;
        return (char)BlueToothProtocol.getNumber(this.a, this.a - 2, 2);
    }

    public int readInt() {
        this.a += 5;
        return (int)BlueToothProtocol.getNumber(this.a, this.a - 4, 4);
    }

    public long readLong() {
        this.a += 9;
        return BlueToothProtocol.getNumber(this.a, this.a - 8, 8);
    }

    public short readShort() {
        this.a += 3;
        return (short)BlueToothProtocol.getNumber(this.a, this.a - 2, 2);
    }

    public String readString() {
        byte by = this.a[this.a];
        ++this.a;
        return this.readUTFString(by);
    }

    public void reset() {
        this.a = 0;
    }

    public static long getNumber(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l <<= 8;
            l |= (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    public String readUTFString(byte by) {
        try {
            int n = (int)BlueToothProtocol.getNumber(this.a, this.a, 2) + 2;
            int n2 = this.a;
            this.a += n;
            if (by == 7) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.a, n2, n));
                return dataInputStream.readUTF();
            }
            this.a += 2;
            int n3 = (n - 4) / 2;
            if (n3 == 0) {
                return "";
            }
            char[] cArray = new char[n3];
            int n4 = 0;
            int n5 = n2 + 4;
            while (n4 < n3) {
                cArray[n4] = (char)((this.a[n5] & 0xFF) + ((this.a[n5 + 1] & 0xFF) << 8));
                ++n4;
                n5 += 2;
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public final void a(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeUTF(string);
        dataOutputStream.flush();
    }

    public final String a(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readUTF();
    }

    public static interface EventHandler {
        public void connectReady();

        public void error(String var1, byte var2, String var3);

        public void CycleSegment(byte[] var1);
    }
}

