/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Animation;
import game.Bubbles;
import game.Combo;
import game.Floor;
import game.Game;
import game.GameBoard;
import game.Keys;
import game.Particles;
import game.StarsEffect;
import tinbrain.GCanvas;
import tinbrain.RM;

public class Avatar {
    private static boolean avatarJumped = false;
    private static int normalJumpCounter = 0;
    public static int character;
    private static int sDirection;
    private static int sState;
    public static int sAvatarXPos;
    private static int sAvatarXPosCorrection;
    public static int sAvatarYPos;
    private static int sAvatarWidth;
    public static int sAvatarHeight;
    private static int sMoveAcceleration;
    private static int sAirMoveAcceleration;
    public static int sMoveSpeed;
    private static int sMaxPosX;
    private static int sMinPosX;
    private static int sMaxSpeedX;
    private static int sStartMoveBrake;
    private static int sSpeedRateAfterBounce;
    private static int sEndMoveBrake;
    private static int sSwitchToBrake2;
    private static int sGravity;
    private static int sGravityNormal;
    private static int sGravityWater;
    private static int sGravityFall;
    private static int sGravityFallNormal;
    private static int sGravityFallWater;
    public static int sJumpSpeed;
    private static int sInitialSpeed;
    private static int sStartingJumpSpeed;
    private static int sChangeDirectionSpeed;
    private static int sPeakUpThereshold;
    private static int sStarsThereshold;
    private static int sBalancingThereshold;
    private static Animation sAnimIdle;
    private static Animation sAnimWalkingLeft;
    private static Animation sAnimWalkingRight;
    private static Animation sAnimBalancingLeft;
    private static Animation sAnimBalancingRight;
    private static Animation sAnimScared;
    private static Animation sAnimJumpingStraight;
    private static Animation sAnimJumpingUpLeft;
    private static Animation sAnimJumpingUpRight;
    private static Animation sAnimJumpingAtPeak;
    private static boolean sDisplayJumpStraight;
    private static boolean sIsDisplayingStars;
    private static int sAvatarSprite;
    private static int sAvatarSpriteJump;
    private static int sStartJumpSpeedRate;
    private static boolean sNeedDisplayingRotate;

    public static final void switchGravityWater() {
        sGravity = sGravityWater;
        sGravityFall = sGravityFallWater;
    }

    public static final void switchGravityNormal() {
        sGravity = sGravityNormal;
        sGravityFall = sGravityFallNormal;
    }

    public static final void init() {
        sAvatarSprite = Avatar.getAvatarSpriteId();
        sAvatarSpriteJump = Avatar.getAvatarJumpSpriteId();
        sAvatarXPosCorrection = Avatar.getAvatarXPosCorrection();
        sMaxSpeedX = RM.getValue(67, Game.sGameStyle, 3);
        sMinPosX = GameBoard.getWallWidth();
        sMaxPosX = Game.sGameWidth - GameBoard.getWallWidth();
        sAvatarWidth = Avatar.getAvatarWidth();
        sAvatarHeight = GCanvas.getSpriteHeight(sAvatarSprite);
        sMoveAcceleration = RM.getValue(67, Game.sGameStyle, 0);
        sStartMoveBrake = RM.getValue(67, Game.sGameStyle, 4);
        sEndMoveBrake = RM.getValue(67, Game.sGameStyle, 5);
        sSwitchToBrake2 = RM.getValue(67, Game.sGameStyle, 6);
        sGravityNormal = RM.getValue(67, Game.sGameStyle, 7);
        sGravityFallNormal = RM.getValue(67, Game.sGameStyle, 8);
        sGravityWater = sGravityNormal >> 1;
        sGravityFallWater = sGravityNormal >> 1;
        Avatar.switchGravityNormal();
        sStartingJumpSpeed = RM.getValue(67, Game.sGameStyle, 9);
        sChangeDirectionSpeed = RM.getValue(67, Game.sGameStyle, 10);
        sAirMoveAcceleration = RM.getValue(67, Game.sGameStyle, 1);
        sPeakUpThereshold = RM.getValue(76, Game.sGameStyle, 6);
        sStarsThereshold = RM.getValue(76, Game.sGameStyle, 5);
        sBalancingThereshold = RM.getValue(76, Game.sGameStyle, 7);
        sSpeedRateAfterBounce = RM.getValue(67, Game.sGameStyle, 11);
        sStartJumpSpeedRate = RM.getValue(67, Game.sGameStyle, 12);
        Avatar.initAnim();
    }

    public static final int getAvatarWidth() {
        switch (character) {
            case 0: {
                return RM.getValue(69, 0, 3);
            }
            case 1: {
                return RM.getValue(69, 0, 7);
            }
        }
        return RM.getValue(69, 0, 11);
    }

    public static final int getAvatarHeight() {
        return GCanvas.getSpriteHeight(sAvatarSprite);
    }

    public static final int getAvatarXPosCorrection() {
        switch (character) {
            case 0: {
                return RM.getValue(69, 0, 2);
            }
            case 1: {
                return RM.getValue(69, 0, 6);
            }
        }
        return RM.getValue(69, 0, 10);
    }

    private static final int getAvatarSpriteId() {
        switch (character) {
            case 0: {
                return RM.getValue(69, 0, 0);
            }
            case 1: {
                return RM.getValue(69, 0, 4);
            }
        }
        return RM.getValue(69, 0, 8);
    }

    private static final int getAvatarJumpSpriteId() {
        switch (character) {
            case 0: {
                return RM.getValue(69, 0, 1);
            }
            case 1: {
                return RM.getValue(69, 0, 5);
            }
        }
        return RM.getValue(69, 0, 9);
    }

    public static final void restart() {
        sNeedDisplayingRotate = false;
        sMoveSpeed = 0;
        sJumpSpeed = 0;
        sState = 0;
        sIsDisplayingStars = false;
        sDisplayJumpStraight = false;
        sAvatarXPos = Game.sGameWidth - sAvatarWidth >> 1;
        sAvatarYPos = Game.sGameHeight - sAvatarHeight - GCanvas.getSpriteHeight(RM.getValue(71, Game.sGameStyle, 0));
    }

    private static final void initAnim() {
        sAnimIdle = new Animation(sAvatarSprite, RM.getValue(73, 0), RM.getValue(73, 1), RM.getValue(72, 3));
        sAnimWalkingRight = new Animation(sAvatarSprite, RM.getValue(73, 4), RM.getValue(73, 5), RM.getValue(72, 1));
        sAnimWalkingLeft = new Animation(sAvatarSprite, RM.getValue(73, 2), RM.getValue(73, 3), RM.getValue(72, 1));
        sAnimBalancingLeft = new Animation(sAvatarSprite, RM.getValue(73, 6), RM.getValue(73, 7), RM.getValue(72, 0));
        sAnimBalancingRight = new Animation(sAvatarSprite, RM.getValue(73, 8), RM.getValue(73, 9), RM.getValue(72, 0));
        sAnimScared = new Animation(sAvatarSprite, RM.getValue(73, 10), RM.getValue(73, 11), RM.getValue(72, 4));
        sAnimJumpingStraight = new Animation(sAvatarSprite, RM.getValue(73, 12), RM.getValue(73, 13), RM.getValue(72, 5));
        sAnimJumpingUpLeft = new Animation(sAvatarSprite, RM.getValue(73, 14), RM.getValue(73, 15), RM.getValue(72, 6));
        sAnimJumpingUpRight = new Animation(sAvatarSprite, RM.getValue(73, 16), RM.getValue(73, 17), RM.getValue(72, 6));
        sAnimJumpingAtPeak = new Animation(sAvatarSpriteJump, RM.getValue(73, 18), RM.getValue(73, 19), RM.getValue(72, 7));
    }

    public static final void setState(int n) {
        sState = n;
    }

    private static final void examineBalancing() {
        if (sState == 0) {
            int n = GameBoard.getCurrentFloor(sAvatarYPos);
            Floor floor = GameBoard.getFloor(n);
            if (sAvatarXPos + sAvatarXPosCorrection > floor.getXPos() + floor.getFloorWidth() - sBalancingThereshold) {
                sDirection = 2;
                sState = 2;
            } else if (sAvatarXPos + sAvatarXPosCorrection < floor.getXPos() - sAvatarWidth + sBalancingThereshold) {
                sDirection = 1;
                sState = 2;
            }
        }
    }

    public static final int getPosY() {
        return sAvatarYPos;
    }

    public static final int getPosX() {
        return sAvatarXPos;
    }

    private static final int calcSpeedX() {
        int n = !Avatar.isJumping() && !Avatar.isFalling() ? sMoveAcceleration : sAirMoveAcceleration;
        if (sMoveSpeed + n < sMaxSpeedX) {
            return sMoveSpeed + n;
        }
        if (Combo.sIsCombo) {
            return sMaxSpeedX + 1;
        }
        return sMaxSpeedX;
    }

    private static final int calcSpeedXForBounce() {
        int n = 0;
        n = (sMoveSpeed -= sMoveAcceleration) * sSpeedRateAfterBounce / 100 > 0 ? sMoveSpeed - sSpeedRateAfterBounce / 100 : sMoveSpeed - 1;
        if (sMoveSpeed < 0) {
            n = 0;
        }
        return n;
    }

    private static final int calculateXPos(int n) {
        if (n == 1) {
            if (sAvatarXPos - sMoveSpeed + sAvatarXPosCorrection <= sMinPosX) {
                int n2 = sMinPosX - (sAvatarXPos - sMoveSpeed + sAvatarXPosCorrection);
                sMoveSpeed = Avatar.calcSpeedXForBounce();
                sDirection = 2;
                return sMinPosX + n2 - sAvatarXPosCorrection;
            }
            return sAvatarXPos - sMoveSpeed;
        }
        if (n == 2) {
            if (sAvatarXPos + sMoveSpeed >= sMaxPosX - sAvatarWidth - sAvatarXPosCorrection) {
                int n3 = sAvatarXPos + sMoveSpeed - (sMaxPosX - sAvatarWidth - sAvatarXPosCorrection);
                sMoveSpeed = Avatar.calcSpeedXForBounce();
                sDirection = 1;
                return sMaxPosX - sAvatarWidth - sAvatarXPosCorrection - n3;
            }
            return sAvatarXPos + sMoveSpeed;
        }
        return sAvatarXPos;
    }

    private static final boolean isCollision(int n) {
        Floor floor;
        if (Game.sGameOver) {
            return false;
        }
        int n2 = 0;
        if (sState == 1 && sMoveSpeed > 2) {
            n2 = 0;
        }
        return sAvatarXPos + sAvatarXPosCorrection + sAvatarWidth >= (floor = GameBoard.getFloor(n)).getXPos() - n2 && sAvatarXPos + sAvatarXPosCorrection < floor.getXPos() + floor.getFloorWidth() + n2;
    }

    private static final int calculateBrakeRatio() {
        if (sMoveSpeed > sSwitchToBrake2) {
            return sStartMoveBrake;
        }
        return sEndMoveBrake;
    }

    public static final void brake() {
        sMoveSpeed = sMoveSpeed - Avatar.calculateBrakeRatio() > 0 ? (sMoveSpeed -= Avatar.calculateBrakeRatio()) : 0;
        sAvatarXPos = Avatar.calculateXPos(sDirection);
        if (!Avatar.isJumping() && !Avatar.isFalling()) {
            if (!Avatar.isCollision(Game.sCurrentFloor)) {
                sState = 7;
            }
            if (sMoveSpeed == 0) {
                sState = 0;
                Avatar.examineBalancing();
            }
        }
    }

    public static final void move(int n) {
        if (sDirection != n && sMoveSpeed > sChangeDirectionSpeed) {
            sMoveSpeed = sChangeDirectionSpeed;
        }
        sDirection = n;
        if (!Avatar.isJumping() && !Avatar.isFalling()) {
            sState = 1;
            sNeedDisplayingRotate = false;
        }
        sMoveSpeed = Avatar.calcSpeedX();
        sAvatarXPos = Avatar.calculateXPos(sDirection);
        if (!(Avatar.isJumping() || Avatar.isFalling() || Avatar.isCollision(Game.sCurrentFloor))) {
            sState = 7;
        }
    }

    public static final void update(long l, boolean bl) {
        if ((sAvatarYPos += GameBoard.setScrollSpeed(l, bl)) + sAvatarHeight + sJumpSpeed >= Game.sGameHeight) {
            Combo.sComboLength = 0;
            Game.sGameOver = true;
            Avatar.setState(7);
            return;
        }
        if (sState == 0 && sAvatarYPos > 3 * Game.sGameHeight / 4) {
            sState = 3;
        }
    }

    public static final void updateMovingPlatformsLogic() {
        if (Game.sPowerUpNailsActive) {
            return;
        }
        if (!Avatar.isJumping() && !Avatar.isFalling()) {
            Floor floor = GameBoard.getFloor(Game.sCurrentFloor);
            if (floor.getFloorLong() || floor.getFloorBrick()) {
                return;
            }
            int n = floor.getMovingPlatformSign() * Game.sMovingPlatofrmsSpeed;
            if ((sAvatarXPos += n >> 10) + sAvatarXPosCorrection <= sMinPosX) {
                sAvatarXPos = sMinPosX - sAvatarXPosCorrection;
            }
            if (sAvatarXPos + sAvatarXPosCorrection >= sMaxPosX - sAvatarWidth) {
                sAvatarXPos = sMaxPosX - sAvatarXPosCorrection - sAvatarWidth;
            }
        }
    }

    public static final void updateDestPlatformsLogic() {
        if (!Avatar.isJumping() && !Avatar.isFalling()) {
            Floor floor = GameBoard.getFloor(Game.sCurrentFloor);
            if (floor.getFloorLong() || floor.getFloorBrick()) {
                return;
            }
            if (!floor.getTouched()) {
                floor.setTouched(true);
                floor.setTouchTime(System.currentTimeMillis());
                floor.setFloorTouchedPosY(Avatar.getPosY() + Avatar.getAvatarHeight());
            }
            if (floor.getTouched() && floor.getDestroyed()) {
                Avatar.setState(7);
            }
        }
    }

    public static final boolean isJumping() {
        return sState == 6 || sState == 4 || sState == 5;
    }

    public static final boolean isFalling() {
        return sState == 7;
    }

    public static final void prepareToJump() {
        if (!Avatar.isJumping() && !Avatar.isFalling()) {
            int n;
            if (!Game.sModeReplay && Keys.sAutoJump == 0) {
                Game.sPermitJump = false;
            }
            if ((n = sMoveSpeed * sStartJumpSpeedRate / 10) > sStartingJumpSpeed) {
                if (sMoveSpeed >= sPeakUpThereshold) {
                    sState = 6;
                    sNeedDisplayingRotate = true;
                    if (sMoveSpeed >= sStarsThereshold) {
                        sIsDisplayingStars = true;
                    }
                    sJumpSpeed = n;
                } else {
                    sState = 5;
                    sJumpSpeed = n;
                    sNeedDisplayingRotate = false;
                }
            } else {
                if (Game.sDisplayJumpUp) {
                    sState = 5;
                    Game.sDisplayJumpUp = false;
                } else {
                    sState = 4;
                    sDisplayJumpStraight = true;
                }
                sJumpSpeed = Game.sGameDifficulty == Game.DIFFICULTY_EASY && sMoveSpeed == 0 ? Game.calcPercentage(sStartingJumpSpeed, 120) : sStartingJumpSpeed;
                sNeedDisplayingRotate = false;
            }
            sInitialSpeed = sJumpSpeed;
            if (!Game.sModeReplay) {
                avatarJumped = true;
            }
        }
    }

    public static final void jump() {
        if (Avatar.isJumping()) {
            if (sJumpSpeed > 0) {
                if (sIsDisplayingStars && Combo.sStartFloorCombo > 0 && Combo.sIsCombo) {
                    StarsEffect.addStar(sAvatarXPos + sAvatarXPosCorrection + (sAvatarWidth >> 1), sAvatarYPos);
                    int n = sAvatarXPos + sAvatarXPosCorrection + (sAvatarWidth >> 1);
                    int n2 = sAvatarYPos;
                    int n3 = GCanvas.getSpriteWidth(3);
                    Particles.initEffectByStars(n, n2, n3);
                }
                sJumpSpeed = sJumpSpeed > sGravity ? (sJumpSpeed % sGravity != 0 ? (sJumpSpeed -= sJumpSpeed % sGravity) : (sJumpSpeed -= sGravity)) : 0;
                sAvatarYPos -= sJumpSpeed;
            } else {
                sJumpSpeed = 0;
                sState = 7;
            }
        }
    }

    public static final void fall() {
        if (Avatar.isFalling()) {
            int n;
            int n2;
            if (sIsDisplayingStars) {
                sIsDisplayingStars = true;
                if (Combo.sStartFloorCombo > 0 && Combo.sIsCombo) {
                    StarsEffect.addStar(sAvatarXPos + sAvatarXPosCorrection + (sAvatarWidth >> 1), sAvatarYPos + sAvatarHeight);
                    int n3 = sAvatarXPos + sAvatarXPosCorrection + (sAvatarWidth >> 1);
                    n2 = sAvatarYPos + sAvatarHeight;
                    n = GCanvas.getSpriteWidth(3);
                    Particles.initEffectByStars(n3, n2, n);
                }
            }
            if (Game.sCurrentFloor < 0) {
                Game.sCurrentFloor = 0;
            }
            if (sJumpSpeed < sInitialSpeed) {
                sJumpSpeed = sJumpSpeed + sGravityFall <= sInitialSpeed ? (sJumpSpeed += sGravityFall) : sInitialSpeed;
            }
            Floor floor = GameBoard.getFloor(Game.sCurrentFloor);
            n2 = 0;
            if (floor != null) {
                n2 = floor.getFloorIndex();
            }
            n = GameBoard.getFirstFloorYPos() - n2 * (GameBoard.getFloorsHeight() + GameBoard.getFloorsGap());
            boolean bl = true;
            if (floor != null && floor.getDestroyed()) {
                bl = false;
            }
            if (sAvatarYPos + (sJumpSpeed << 1) + sAvatarHeight > n && floor != null) {
                if (bl && sAvatarXPos + sAvatarXPosCorrection + sAvatarWidth >= floor.getXPos() && sAvatarXPos + sAvatarXPosCorrection < floor.getXPos() + floor.getFloorWidth() && !Game.sGameOver) {
                    Combo.setEndFloorCombo(n2);
                    sAvatarYPos = n - sAvatarHeight;
                    sJumpSpeed = 0;
                    sState = sMoveSpeed == 0 ? 0 : 1;
                    if (Keys.sAutoJump == 0) {
                        Game.sMoveLeftStarted = false;
                        Game.sMoveRightStarted = false;
                    }
                    sDisplayJumpStraight = false;
                    sIsDisplayingStars = false;
                    Avatar.examineBalancing();
                    if (!Game.sModeReplay && avatarJumped) {
                        avatarJumped = false;
                        ++normalJumpCounter;
                    }
                } else {
                    sAvatarYPos += sJumpSpeed;
                }
            } else {
                sAvatarYPos += sJumpSpeed;
            }
        }
    }

    public static final void updateAnim() {
        switch (sState) {
            case 0: {
                sAnimIdle.update();
                break;
            }
            case 1: {
                if (sDirection == 1) {
                    sAnimWalkingLeft.update();
                    break;
                }
                sAnimWalkingRight.update();
                break;
            }
            case 2: {
                if (sDirection == 1) {
                    sAnimBalancingLeft.update();
                    break;
                }
                sAnimBalancingRight.update();
                break;
            }
            case 3: {
                sAnimScared.update();
                break;
            }
            case 4: {
                sAnimJumpingStraight.update();
                break;
            }
            case 5: {
                if (sDirection == 1) {
                    sAnimJumpingUpLeft.update();
                    break;
                }
                sAnimJumpingUpRight.update();
                break;
            }
            case 6: {
                sAnimJumpingAtPeak.update();
                break;
            }
            case 7: {
                if (sNeedDisplayingRotate) {
                    sAnimJumpingAtPeak.update();
                    break;
                }
                if (sDirection == 1) {
                    sAnimJumpingUpLeft.update();
                    break;
                }
                sAnimJumpingUpRight.update();
            }
        }
    }

    private static final int getFrameId() {
        int n = 0;
        switch (sState) {
            case 0: {
                n = sAnimIdle.getFrame();
                break;
            }
            case 1: {
                if (sDirection == 1) {
                    n = sAnimWalkingLeft.getFrame();
                    break;
                }
                n = sAnimWalkingRight.getFrame();
                break;
            }
            case 2: {
                if (sDirection == 1) {
                    n = sAnimBalancingLeft.getFrame();
                    break;
                }
                n = sAnimBalancingRight.getFrame();
                break;
            }
            case 3: {
                n = sAnimScared.getFrame();
                break;
            }
            case 4: {
                n = sAnimJumpingStraight.getFrame();
                break;
            }
            case 5: {
                if (sDirection == 1) {
                    n = sAnimJumpingUpLeft.getFrame();
                    break;
                }
                n = sAnimJumpingUpRight.getFrame();
                break;
            }
            case 6: {
                n = sAnimJumpingAtPeak.getFrame();
                break;
            }
            case 7: {
                n = sDisplayJumpStraight ? sAnimJumpingStraight.getFrame() : (sNeedDisplayingRotate ? sAnimJumpingAtPeak.getFrame() : (sDirection == 1 ? sAnimJumpingUpLeft.getFrame() : sAnimJumpingUpRight.getFrame()));
            }
        }
        return n;
    }

    public static final void draw() {
        if (sState == 6 || sState == 7 && sNeedDisplayingRotate) {
            GCanvas.drawSprite(sAvatarSpriteJump, sAvatarXPos - 2, sAvatarYPos + 2, Avatar.getFrameId());
            if (Game.sPowerUpBubbleActive && !Bubbles.isEndPhase()) {
                GCanvas.drawImage(63, sAvatarXPos + (GCanvas.getSpriteWidth(12) >> 1), sAvatarYPos + (GCanvas.getSpriteHeight(12) >> 1) + GameBoard.sAvatarBubbleOffsetY, 3);
            }
        } else {
            int n = 0;
            int n2 = 0;
            Floor floor = GameBoard.getFloor(Game.sCurrentFloor);
            if (floor != null) {
                n = floor.getShakeOffsetX();
                n = floor.getShakeOffsetY();
            }
            GCanvas.drawSprite(sAvatarSprite, sAvatarXPos + n, sAvatarYPos + 2 + n2, Avatar.getFrameId());
            if (Game.sPowerUpBubbleActive && !Bubbles.isEndPhase()) {
                GCanvas.drawImage(63, sAvatarXPos + (GCanvas.getSpriteWidth(12) >> 1), sAvatarYPos + (GCanvas.getSpriteHeight(12) >> 1) + GameBoard.sAvatarBubbleOffsetY, 3);
            }
        }
    }

    static {
        sNeedDisplayingRotate = false;
    }
}

