#!/bin/sh
# MinUI.pak

# recover from readonly SD card -------------------------------
# touch /mnt/writetest
# sync
# if [ -f /mnt/writetest ] ; then
# 	rm -f /mnt/writetest
# else
# 	e2fsck -p /dev/root > /mnt/SDCARD/RootRecovery.txt
# 	reboot
# fi

export PLATFORM="tg5050"
export SDCARD_PATH="/mnt/SDCARD"
export BIOS_PATH="$SDCARD_PATH/Bios"
export ROMS_PATH="$SDCARD_PATH/Roms"
export SAVES_PATH="$SDCARD_PATH/Saves"
export CHEATS_PATH="$SDCARD_PATH/Cheats"
export SYSTEM_PATH="$SDCARD_PATH/.system/$PLATFORM"
export CORES_PATH="$SYSTEM_PATH/cores"
export USERDATA_PATH="$SDCARD_PATH/.userdata/$PLATFORM"
export SHARED_USERDATA_PATH="$SDCARD_PATH/.userdata/shared"
export LOGS_PATH="$USERDATA_PATH/logs"
export DATETIME_PATH="$SHARED_USERDATA_PATH/datetime.txt"
export HOME="$USERDATA_PATH"

#######################################

if [ -f "/tmp/poweroff" ]; then
	poweroff
	exit 0
fi
if [ -f "/tmp/reboot" ]; then
	reboot
	exit 0
fi

#######################################

mkdir -p "$BIOS_PATH"
mkdir -p "$ROMS_PATH"
mkdir -p "$SAVES_PATH"
mkdir -p "$CHEATS_PATH"
mkdir -p "$USERDATA_PATH"
mkdir -p "$LOGS_PATH"
mkdir -p "$SHARED_USERDATA_PATH/.minui"

export TRIMUI_MODEL=`strings /usr/trimui/bin/MainUI | grep ^Trimui`
if [ "$TRIMUI_MODEL" = "Trimui Smart Pro S" ]; then
	export DEVICE="smartpros"
fi

export IS_NEXT="yes"

#######################################

# taken from stock launch sequence
sync
echo 3 > /proc/sys/vm/drop_caches
sync

#5V enable
# echo 335 > /sys/class/gpio/export
# echo -n out > /sys/class/gpio/gpio335/direction
# echo -n 1 > /sys/class/gpio/gpio335/value

#rumble motor PH12
echo 236 > /sys/class/gpio/export
echo -n out > /sys/class/gpio/gpio236/direction
echo -n 0 > /sys/class/gpio/gpio236/value

#Left/Right Pad PK12/PK16 , run in trimui_inputd
# echo 332 > /sys/class/gpio/export
# echo -n out > /sys/class/gpio/gpio332/direction
# echo -n 1 > /sys/class/gpio/gpio332/value

# echo 336 > /sys/class/gpio/export
# echo -n out > /sys/class/gpio/gpio336/direction
# echo -n 1 > /sys/class/gpio/gpio336/value

#DIP Switch PL11 , run in trimui_inputd
# echo 363 > /sys/class/gpio/export
# echo -n in > /sys/class/gpio/gpio363/direction

#syslogd -S

#######################################

export LD_LIBRARY_PATH=$SYSTEM_PATH/lib:/usr/trimui/lib:$LD_LIBRARY_PATH
export PATH=$SYSTEM_PATH/bin:/usr/trimui/bin:$PATH

echo before leds `cat /proc/uptime` >> /tmp/nextui_boottime

# leds_off
echo 0 > /sys/class/led_anim/max_scale

# start gpio input daemon
trimui_inputd &

echo userspace > /sys/devices/system/cpu/cpu4/cpufreq/scaling_governor
echo 408000 > /sys/devices/system/cpu/cpu4/cpufreq/scaling_min_freq
echo 2160000 > /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq

BIG_PATH=/sys/devices/system/cpu/cpu4/cpufreq/scaling_setspeed
CPU_SPEED_PERF=2160000
echo $CPU_SPEED_PERF > $BIG_PATH

echo schedutil > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
echo 408000 > /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq
echo 2000000 > /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq

#LITTLE_PATH=/sys/devices/system/cpu/cpu0/cpufreq/scaling_setspeed
#CPU_SPEED_PERF_LITTLE=2000000
#echo $CPU_SPEED_PERF_LITTLE > $LITTLE_PATH

echo performance > /sys/devices/platform/soc@3000000/1800000.gpu/devfreq/1800000.gpu/governor

# Very little libretro cores profit from multithreading, even stock OS is 
# only very seldomly using more than 1+2 cores. Use as a baseline, the 
# higher-end cores can just enable more cores themselves if needed.

# little Cortex-A55 CPU0 - 408Mhz to 1416Mhz
echo 1 > /sys/devices/system/cpu/cpu0/online
echo 1 > /sys/devices/system/cpu/cpu1/online

echo 0 > /sys/devices/system/cpu/cpu3/online
echo 0 > /sys/devices/system/cpu/cpu2/online

# big Cortex-A55 CPU4 - 408Mhz to 2160Mhz
echo 1 > /sys/devices/system/cpu/cpu4/online

echo 0 > /sys/devices/system/cpu/cpu7/online
echo 0 > /sys/devices/system/cpu/cpu6/online
echo 0 > /sys/devices/system/cpu/cpu5/online

keymon.elf & # &> $SDCARD_PATH/keymon.txt &
batmon.elf & # &> $SDCARD_PATH/batmon.txt &

# start fresh, will be populated on the next connect
rm -f $USERDATA_PATH/.asoundrc
audiomon.elf & #&> $SDCARD_PATH/audiomon.txt &

# BT handling
bluetoothon=$(nextval.elf bluetooth | sed -n 's/.*"bluetooth": \([0-9]*\).*/\1/p')
if [ "$bluetoothon" -eq 1 ]; then
	$SYSTEM_PATH/etc/bluetooth/bt_init.sh start > /dev/null 2>&1 &
fi
echo after bluetooth `cat /proc/uptime` >> /tmp/nextui_boottime

# wifi handling
wifion=$(nextval.elf wifi | sed -n 's/.*"wifi": \([0-9]*\).*/\1/p')
if [ "$wifion" -eq 1 ]; then
	$SYSTEM_PATH/etc/wifi/wifi_init.sh start > /dev/null 2>&1 &
fi
echo after wifi `cat /proc/uptime` >> /tmp/nextui_boottime

#######################################

AUTO_PATH=$USERDATA_PATH/auto.sh
if [ -f "$AUTO_PATH" ]; then
	echo before auto.sh `cat /proc/uptime` >> /tmp/nextui_boottime
	"$AUTO_PATH"
	echo after auto.sh `cat /proc/uptime` >> /tmp/nextui_boottime
fi

cd $(dirname "$0")

#######################################

# kill show2.elf if running
killall -9 show2.elf > /dev/null 2>&1

EXEC_PATH="/tmp/nextui_exec"
NEXT_PATH="/tmp/next"
touch "$EXEC_PATH"  && sync
while [ -f $EXEC_PATH ]; do
	nextui.elf &> $LOGS_PATH/nextui.txt
	echo $CPU_SPEED_PERF > $BIG_PATH

	if [ -f $NEXT_PATH ]; then
		CMD=`cat $NEXT_PATH`
		eval $CMD
		rm -f $NEXT_PATH
		echo $CPU_SPEED_PERF > $BIG_PATH
	fi

	if [ -f "/tmp/poweroff" ]; then
		poweroff
		exit 0
	fi
	if [ -f "/tmp/reboot" ]; then
		reboot
		exit 0
	fi
done

poweroff # just in case
