/******/ var __webpack_modules__ = ({

/***/ "./src/src/appWindow.js":
/*!******************************!*\
  !*** ./src/src/appWindow.js ***!
  \******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony import */ var _utils_updateWizardHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/updateWizardHelper */ "./src/src/utils/updateWizardHelper.js");
/* harmony import */ var _utils_synoApiProvider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/synoApiProvider */ "./src/src/utils/synoApiProvider.js");


// Namespace definition
Ext.ns('SYNOCOMMUNITY.ARCControl');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (// Window definition
Ext.define('SYNOCOMMUNITY.ARCControl.AppWindow', {
        helper: SYNOCOMMUNITY.ARCControl.Helper,
        apiProvider: SYNOCOMMUNITY.ARCControl.SynoApiProvider,
        formatString: function (str, ...args) {
            return str.replace(/{(\d+)}/g, function (match, number) {
                return typeof args[number] !== 'undefined' ? args[number] : match;
            });
        },
        extend: "SYNO.SDS.PageListAppWindow",
        activePage: "SYNOCOMMUNITY.ARCControl.Overview.Main",
        defaultWinSize: { width: 1200, height: 700 },
        constructor: function (config) {
            const t = this;
            this.apiProvider.init(this.sendWebAPI.bind(this));
            t.callParent([t.fillConfig(config)]);
        },
        fillConfig: function (e) {
            let t;
            t = this.getListItems();
            const i = {
                cls: "syno-app-iscsi",
                width: this.defaultWinSize.width,
                height: this.defaultWinSize.height,
                minWidth: this.defaultWinSize.width,
                minHeight: this.defaultWinSize.height,
                activePage: "SYNOCOMMUNITY.ARCControl.Overview.Main",
                listItems: t,
            };
            return Ext.apply(i, e), i;

        },
        getListItems: function () {
            let items = [
                {
                    text: this.helper.V('ui', 'tab_general'),
                    iconCls: "icon-arc-overview",
                    fn: "SYNOCOMMUNITY.ARCControl.Overview.Main",
                },
                {
                    text: this.helper.V('ui', 'tab_configuration'),
                    iconCls: "icon-arc-setting",
                    fn: "SYNOCOMMUNITY.ARCControl.Setting.Main",
                },
                {
                    text: this.helper.V('ui', 'tab_addons'),
                    iconCls: "icon-arc-addons",
                    fn: "SYNOCOMMUNITY.ARCControl.Addons.Main",
                },
                {
                    text: this.helper.V('ui', 'tab_services'),
                    iconCls: "icon-arc-addons",
                    fn: "SYNOCOMMUNITY.ARCControl.Service.Main",
                },
                {
                    text: this.helper.V('ui', 'tab_disks'),
                    iconCls: "icon-arc-overview",
                    fn: "SYNOCOMMUNITY.ARCControl.Disks.Main",
                },
                {
                    text: this.helper.V('ui', 'tab_debug'),
                    iconCls: "icon-arc-overview",
                    fn: "SYNOCOMMUNITY.ARCControl.Debug.Main",
                },
                {
                    text: this.helper.V('ui', 'tab_loader'),
                    iconCls: "icon-arc-setting",
                    fn: "SYNOCOMMUNITY.ARCControl.Loader.Main",
                }
            ];
            return items;
        },
        onOpen: function (a) {
            const t = this;
            t.mon(t.getPageList().getSelectionModel(), "selectionchange", t.onSelectionModelChange, t);
            SYNOCOMMUNITY.ARCControl.AppWindow.superclass.onOpen.call(this, a);
        },
        onDestroy: function (e) {
            SYNOCOMMUNITY.ARCControl.AppWindow.superclass.onDestroy.call(this);
        },
        onSelectionModelChange: function () {
            const e = this
                , t = e.getActivePage();
            t && ("SYNOCOMMUNITY.ARCControl.Overview.Main" === t.itemId ? e.getPageCt().addClass("iscsi-overview-panel") : e.getPageCt().removeClass("iscsi-overview-panel"));
        },
    }));

/***/ }),

/***/ "./src/src/components/advancedSearchField.js":
/*!***************************************************!*\
  !*** ./src/src/components/advancedSearchField.js ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.AdvancedSearchField", {
        extend: "SYNO.ux.SearchField",
        initEvents: function () {
            this.callParent(arguments),
                this.mon(Ext.getDoc(), "mousedown", this.onMouseDown, this),
                this.mon(this, "keypress", (function (e, t) {
                    t.getKey() === Ext.EventObject.ENTER && (this.searchPanel?.setKeyWord(this.getValue()),
                        this.searchPanel?.onSearch())
                }
                ), this),
                this.mon(this, "destroy", (function () {
                    this.searchPanel?.destroy()
                }
                ), this)
        },
        isInnerComponent: function (event, form) {
            let isInside = false;
            if (event.getTarget(".syno-datetimepicker-inner-menu")) {
                isInside = true;
            }
            form.items.each((item) => {
                if (item instanceof Ext.form.ComboBox) {
                    if (item.view && event.within(item.view.getEl())) {
                        isInside = true;
                        return false;
                    }
                } else if (item instanceof Ext.form.DateField) {
                    if (item.menu && event.within(item.menu.getEl())) {
                        isInside = true;
                        return false;
                    }
                } else if (item instanceof Ext.form.CompositeField && this.isComponentInside(event, item)) {
                    isInside = true;
                    return false;
                }
            }, this);
            return isInside;

        },
        onMouseDown: function (e) {
            const t = this.searchPanel;
            !t || !t.isVisible() || t.inEl || e.within(t.getEl()) || e.within(this.searchtrigger) || this.isInnerComponent(e, this.searchPanel.getForm()) || t.hide()
        },
        onSearchTriggerClick: function () {
            this.searchPanel.isVisible() ? this.searchPanel.hide() : (this.searchPanel.getEl().alignTo(this.wrap, "tr-br?", [6, 0]),
                this.searchPanel.show(),
                this.searchPanel.setKeyWord(this.getValue()))
        },
        onTriggerClick: function () {
            this.callParent(),
                this.searchPanel.onReset()
        }
    }));


/***/ }),

/***/ "./src/src/components/dialogs/updateAvailableDialog.js":
/*!*************************************************************!*\
  !*** ./src/src/components/dialogs/updateAvailableDialog.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Overview.UpdateAvailableDialog", {
        extend: "SYNO.SDS.ModalWindow",
        helper: SYNOCOMMUNITY.ARCControl.Helper,
        constructor: function (a) {
            this.callParent([this.fillConfig(a)]);
        },
        fillConfig: function (a) {
            this.panel = this.createPanel(a);
            this.btnBar = this.createBtnBar(a);
            var c = (a.initHeight || 250) + 200 * (a.msgItemCount || 0);
            var b = {
                cls: "vmm-modal-window",
                width: a.width || 650,
                height: Math.min(c, 650),
                border: false,
                resizable: false,
                layout: "fit",
                items: this.panel,
                fbar: this.btnBar,
            };
            Ext.apply(b, a);
            return b;
        },
        createBtnBar: function (a) {
            var btnBar = {
                xtype: "toolbar",
                buttonAlign: "right",
                cls: "normal-toolbar",
                items: [
                    {
                        xtype: "syno_button",
                        btnStyle: "blue",
                        text: this.helper.T("common", "ok"),
                        scope: this,
                        width: 134,
                        handler: this.onOKClick,
                    }
                ]
            };
            return btnBar;
        },
        createPanel: function (a) {
            var panel = new SYNO.ux.Panel({
                width: a.width ? a.width : 650,
                items: [
                    {
                        xtype: "label",
                        autoHeight: true,
                        id: (this.msgId = Ext.id()),
                        indent: 1,
                        style: "line-height: 25px; margin: 10px;",
                        html: a.message,
                    },
                    {
                        // Display the changelog in a scrollable view
                        xtype: 'box',
                        autoEl: { tag: 'div', html: a.msg.replace(/\n/g, '<br>') },
                        style: 'margin: 10px; overflow-y: auto; border: 1px solid #ccc; padding: 5px;',
                        height: '90%', // Fixed height for the scrollable area
                        anchor: '100%'
                    }    
                ],
            });
            return panel;
        },
        onOKClick: function () {
            if (this.btnOKHandler) {
                this.btnOKHandler();
            }
            this.close();
        },
    }));

/***/ }),

/***/ "./src/src/components/statusBox.js":
/*!*****************************************!*\
  !*** ./src/src/components/statusBox.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Overview.StatusBox", {
        extend: "SYNO.ux.Panel",
        constructor: function (e) {
            this.callParent([this.fillConfig(e)]);
        },
        fillConfig: function (e) {
            (this.appWin = e.appWin),
                (this.data = e.data),
                (this.tpl = new SYNOCOMMUNITY.ARCControl.Overview.StatusBoxTmpl({
                    type: e.type,
                    title: e.title,
                    data: this.data,
                }));
            const t = {
                items: [
                    {
                        itemId: "statusBox",
                        xtype: "box",
                        cls: "iscsi-overview-statusbox-block",
                        html: "",
                    },
                ],
                data: this.data,
                listeners: {
                    scope: this,
                    afterrender: this.onAfterRender,
                    update: this.updateTpl,
                    data_ready: this.onDataReady,
                },
            };
            return Ext.apply(t, e), t;
        },
        onAfterRender: function () {
            this.mon(this.body, "click", this.onMouseClick, this);
        },
        updateTpl: function () {
            this.tpl.overwrite(
                this.getComponent("statusBox").getEl(),
                Ext.apply(
                    {
                        type: this.type,
                        clickType:
                            this.owner.clickedBox === this.type ? "click" : "unclick",
                        errorlevel: this.errorlevel,
                        total: this?.data?.icon,
                        error: 0,
                        warning: 0,
                    },
                    this.tpl.data
                )
            );
        },
        onMouseClick: function () {
            this.owner.fireEvent("selectchange", this.type);
        },
        processArcSummary: function () {
            const luns = [1, 2];
            Ext.each(luns, function (lun) {
                let status = "healthy";
                this.data[status]++;
            }, this);
        },
        //HW info
        processHWSummary: function () {
            const luns = [1, 2];
            Ext.each(luns, function (lun) {
                let status = "healthy";
                this.data[status]++;
            }, this);
        },
        processArcMSummary: function () {
            const luns = [1, 2];
            Ext.each(luns, function (lun) {
                let status = "healthy";
                this.data[status]++;
            }, this);
        },
        onDataReady: function () {
            this.data = { error: 0, warning: 0, healthy: 0 };
            Ext.apply(this.data, this.tpl.data);
            switch (this.storeKey) {
                case "hwinfo_summ":
                    this.processHWSummary();
                    break;
                case "arcinfo_summ":
                    this.processArcSummary();
                    break;
                case "arcminfo_summ":
                    this.processArcMSummary();
            }
            this.data.errorlevel = "healthy";
            this.updateTpl();
        },
    }));

/***/ }),

/***/ "./src/src/components/statusBoxTmpl.js":
/*!*********************************************!*\
  !*** ./src/src/components/statusBoxTmpl.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Overview.StatusBoxTmpl", {
        extend: "Ext.XTemplate",
        helper: SYNOCOMMUNITY.ARCControl.Helper,
        formatString: function (str, ...args) {
            return str.replace(/{(\d+)}/g, function (match, number) {
                return typeof args[number] !== 'undefined' ? args[number] : match;
            });
        },
        constructor: function (e) {
            let t = "";
            switch (e.type) {
                case 'hw_info':
                    t = this.createTplHwInfo();
                    break;
                case 'arc_info':
                    t = this.createTplArcInfo();
                    break;
                case 'arcm_info':
                    t = this.createTplArcmInfo();
                    break;
            }
            t.push(this.fillConfig(e)),
                this.callParent(t);
        },

        getTranslate: (key) => {
            const translations = {
                'hw_info': 'HW Info',
                'arc_info': 'Arc Loader',
                'arcm_info': 'Arc Control',
            };
            return translations[key];
        },
        getStatusText: (type, status) => {
            const statusTexts = {
                'hw_info': 'HW Info',
                'arc_info': 'Arc Loader',
                'arcm_info': 'Arc Control'
            };
            return statusTexts[type];
        },
        isBothErrorWarn: (error, warning) => error !== 0 && warning !== 0,
        showNumber: (number) => {
            return number;
        },

        fillConfig: function (e) {
            const templateConfig = { compiled: true, disableFormats: true },
                translations = {};

            return (
                {
                    // getTranslate: (key) => translations[key],
                    // getStatusText: (type, status) => {
                    //     const statusTexts = {
                    //         'fctarget': translations.status.fctarget[status],
                    //         'target': translations.status.target[status],
                    //         'lun': translations.status.lun[status],
                    //         'event': translations.status.event[status]
                    //     };
                    //     return statusTexts[type];
                    // },
                    // isBothErrorWarn: (error, warning) => error !== 0 && warning !== 0,
                    // showNumber: (number) => number // > 99 ? '99+' : number
                },
                Ext.apply(templateConfig, e)
            );
        },
        createTplHwInfo: function () {
            return [
                '<div class="iscsi-overview-statusbox iscsi-overview-statusbox-{type} iscsi-overview-statusbox-{errorlevel} iscsi-overview-statusbox-{clickType}">',
                '<div class="statusbox-titlebar"></div>',
                '<div class="statusbox-box">',
                '<div class="statusbox-title">',
                "<h3>{[ values.title ]} </h3>",
                "</div>",
                '<div class="statusbox-title-right">',
                "<h3>{[ this.showNumber(values.total) ]}</h3>",
                "</div>",
                '<div class="x-clear"></div>',
                '<div class="statusbox-title-padding">',
                "</div>",
                '<tpl if="! this.isBothErrorWarn(error, warning)">',
                '<div class="statusbox-block statusbox-block-{errorlevel}">',
                '</div>',
                '<div class="statusbox-text" ext:qtip="{[ values.text ]}">{[ values.text ]}</div>',
                '<div class="statusbox-text" ext:qtip="{[ values.text2 ]}">{[ values.text2 ]}</div>',
                '<div class="statusbox-text" ext:qtip="{[ values.text3 ]}">{[ values.text3 ]}</div>',
                "</div>",
                "</tpl>",
                "</div>",
                "</div>",
            ];
        },
        createTplArcInfo: function () {
            return [
                '<div class="iscsi-overview-statusbox iscsi-overview-statusbox-{type} iscsi-overview-statusbox-{errorlevel} iscsi-overview-statusbox-{clickType}">',
                '<div class="statusbox-titlebar"></div>',
                '<div class="statusbox-box">',
                '<div class="statusbox-title">',
                "<h3>{[ values.title ]} </h3>",
                "</div>",
                '<div class="statusbox-title-right">',
                "<h3>{[ this.showNumber(values.total) ]}</h3>",

                "</div>",
                '<div class="x-clear"></div>',
                '<div class="statusbox-title-padding">',
                "</div>",
                '<tpl if="! this.isBothErrorWarn(error, warning)">',
                '<div class="statusbox-block statusbox-block-{errorlevel}">',
                '<div class="statusbox-number">{[ values.arcVersion ]}',
                '</div>',
                // '<div class="statusbox-text" ext:qtip="{[ values.arcControlVersion ]}">{[ values.arcControlVersion ]}</div>',
                "</div>",
                "</tpl>",
                "</div>",
                "</div>",
            ];
        },
        createTplArcmInfo: function () {
            return [
                '<div class="iscsi-overview-statusbox iscsi-overview-statusbox-{type} iscsi-overview-statusbox-{errorlevel} iscsi-overview-statusbox-{clickType}">',
                '<div class="statusbox-titlebar"></div>',
                '<div class="statusbox-box">',
                '<div class="statusbox-title">',
                "<h3>{[ values.title ]} </h3>",
                "</div>",
                '<div class="statusbox-title-right">',
                "<h3>{[ this.showNumber(values.total) ]}</h3>",
                "</div>",
                '<div class="x-clear"></div>',
                '<div class="statusbox-title-padding">',
                "</div>",
                '<tpl if="! this.isBothErrorWarn(error, warning)">',
                '<div class="statusbox-block statusbox-block-{errorlevel}">',
                '<div class="statusbox-number">{[ values.arcControlVersion ]}',
                '</div>',
                // '<div class="statusbox-text" ext:qtip="{[ values.arcControlVersion ]}">{[ values.arcControlVersion ]}</div>',
                "</div>",
                "</tpl>",
                "</div>",
                "</div>",
            ];
        },
    }));

/***/ }),

/***/ "./src/src/panels/debug/generalTab.js":
/*!********************************************!*\
  !*** ./src/src/panels/debug/generalTab.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Debug.GeneralTab", {
        extend: "SYNO.SDS.Utils.FormPanel",
        constructor: function (e) {
            this.getConf = e.owner.getConf.bind(e.owner);
            this.callParent([this.fillConfig(e)])
        },
        fillConfig: function (e) {
            this.suspendLcwPrompt = !1;
            const t = {
                title: "General",
                name: 'debugGeneral',
                id: 'debugGeneral',
                items: [new SYNO.ux.FieldSet({
                    title: 'DSM Cmdline',
                    collapsible: true,
                    collapsed: false,
                    name: 'cmdLine',
                    id: 'cmdLine',
                    columns: 2,
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'DSM Mac Addresses',
                    collapsible: true,
                    name: 'macAdresses',
                    id: 'macAdresses',
                    columns: 2,
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'Modules',
                    collapsible: true,
                    name: 'modules',
                    id: 'modules',
                    columns: 2,
                    items: [],
                })
                ]
            };
            return Ext.apply(t, e),
                t
        },
        initEvents: function () {
            this.mon(this, "activate", this.onActivate, this)
        },
        onActivate: function () {
            self = this;
            if (self.loaded) return;
            this.getConf().then((e) => {
                var config = e.result;
                var cmdLineFieldSet = Ext.getCmp('cmdLine');
                Object.keys(config.bootParameters).forEach((key) => {
                    cmdLineFieldSet.add(
                        {
                            fieldLabel: key,
                            name: key,
                            xtype: 'syno_displayfield',
                            value: config.bootParameters[key]
                        });
                });
                cmdLineFieldSet.doLayout();

                var macAdressesFieldSet = Ext.getCmp('macAdresses');
                config.syno_mac_addresses.forEach((mac_address, index) => {
                    macAdressesFieldSet.add(
                        {
                            fieldLabel: `Mac${index + 1}`,
                            columns: 2,
                            xtype: 'syno_displayfield',
                            value: mac_address
                        });
                });

                var modulesFieldSet = Ext.getCmp('modules');
                config.modules.forEach((list) => {
                    modulesFieldSet.add(
                        {
                            fieldLabel: `Loaded Modules`,
                            columns: 2,
                            xtype: 'syno_displayfield',
                            value: `${list.modules_list}`
                        });
                });
                modulesFieldSet.doLayout();

                var debugGeneral = Ext.getCmp('debugGeneral');
                debugGeneral.doLayout();
                self.loaded = true;
            });
        },
        loadForm: function (e) {
            // this.getForm().setValues(e);
        }
    }));

/***/ }),

/***/ "./src/src/panels/disks/generalTab.js":
/*!********************************************!*\
  !*** ./src/src/panels/disks/generalTab.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Disks.GeneralTab", {
        extend: "SYNO.SDS.Utils.FormPanel",
        constructor: function (e) {
            if (e && e.owner && e.owner.getConf) {
                this.getConf = e.owner.getConf.bind(e.owner);
            } else {
                console.error("Invalid configuration object passed to constructor");
            }
            this.loaded = false;
            this.callParent([this.fillConfig(e)]);
        },
        fillConfig: function (e) {
            this.suspendLcwPrompt = !1;
            const t = {
                title: "System",
                name: 'sysGeneral',
                id: 'sysGeneral',
                autoScroll: true,
                items: [new SYNO.ux.FieldSet({
                    title: 'Hardware Info',
                    collapsible: true,
                    name: 'cpuInfo',
                    id: 'cpuInfo',
                    columns: 2,
                    defaults: { labelStyle: 'font-weight:600;' },
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'GPU Info',
                    collapsible: true,
                    name: 'iGPUInfo',
                    id: 'iGPUInfo',
                    columns: 2,
                    defaults: { labelStyle: 'font-weight:600;' },
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'CPU Clock',
                    collapsible: true,
                    name: 'cpuSpeed',
                    id: 'cpuSpeed',
                    columns: 2,
                    defaults: { labelStyle: 'font-weight:600;' },
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'System Temp',
                    collapsible: true,
                    name: 'sysTemp',
                    id: 'sysTemp',
                    columns: 2,
                    defaults: { labelStyle: 'font-weight:600;' },
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'System Fans',
                    collapsible: true,
                    name: 'fanSpeeds',
                    id: 'fanSpeeds',
                    columns: 2,
                    defaults: { labelStyle: 'font-weight:600;' },
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'Controller Info',
                    collapsible: true,
                    name: 'controllerInfo',
                    id: 'controllerInfo',
                    columns: 2,
                    defaults: { labelStyle: 'font-weight:600;' },
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'NVMe Info',
                    collapsible: true,
                    name: 'nvmeDisks',
                    id: 'nvmeDisks',
                    columns: 2,
                    defaults: { labelStyle: 'font-weight:600;' },
                    items: [],
                }), new SYNO.ux.FieldSet({
                    title: 'Network Info',
                    collapsible: true,
                    name: 'networkInfo',
                    id: 'networkInfo',
                    columns: 2,
                    defaults: { labelStyle: 'font-weight:600;' },
                    items: [],
                })
                ]
            };
            return Ext.apply(t, e),
                t
        },
        initEvents: function () {
            this.mon(this, "activate", this.onActivate, this);

            // --- Add auto-refresh every 5 seconds ---
            if (!this._refreshInterval) {
                this._refreshInterval = setInterval(() => {
                    // Always reload, even if loaded
                    this.loaded = false;
                    this.onActivate();
                }, 5000);
            }
        },

        // Optionally clear interval when destroyed
        onDestroy: function () {
            if (this._refreshInterval) {
                clearInterval(this._refreshInterval);
                this._refreshInterval = null;
            }
            this.callParent(arguments);
        },

        onActivate: function () {
            const self = this;
            if (self.loaded) return;
            this.getConf().then((e) => {
                var config = e.result;

                // CPU Info Section
                var cpuInfoFieldSet = Ext.getCmp('cpuInfo');
                if (cpuInfoFieldSet) {
                    cpuInfoFieldSet.removeAll(true);
                    if (config.cpuInfo && config.cpuInfo.length > 0) {
                        const cpuRows = `<div class="arc-info-rows" style="padding:6px 0;">` +
                            config.cpuInfo.map((cpu) => {
                                return `
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">CPU</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(cpu.model || '')}</div>
                                    </div>
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">Cores</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(cpu.cores || '')}</div>
                                    </div>
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">Governor</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(cpu.governor || '')}</div>
                                    </div>
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">Board</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(cpu.board || '')}</div>
                                    </div>
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">Memory</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(cpu.memory || '')}</div>
                                    </div>
                                `;
                            }).join('') +
                        `</div>`;

                        try {
                            if (cpuInfoFieldSet.body && cpuInfoFieldSet.body.dom) {
                                cpuInfoFieldSet.body.dom.innerHTML = cpuRows;
                            } else if (typeof cpuInfoFieldSet.update === 'function') {
                                cpuInfoFieldSet.update(cpuRows);
                            } else {
                                throw new Error('Cannot find FieldSet body / update method');
                            }
                            if (typeof cpuInfoFieldSet.doLayout === 'function') cpuInfoFieldSet.doLayout();
                        } catch (err) {
                            console.error('cpuInfo HTML injection failed:', err);
                        }
                    } else {
                        cpuInfoFieldSet.destroy();
                    }
                }

                // CPU Speed Section
                var cpuSpeedFieldSet = Ext.getCmp('cpuSpeed');
                if (cpuSpeedFieldSet) {
                    cpuSpeedFieldSet.removeAll(true);
                    if (config.cpuSpeed && config.cpuSpeed.length > 0) {
                        const maxSpeed = 5000;
                        const rowsHtml = `<div class="arc-cpu-bars" style="padding:6px 0;">` +
                            config.cpuSpeed.map((core) => {
                                const speed = Number(core.speed) || 0;
                                const pct = Math.min(100, Math.max(0, Math.round((speed / maxSpeed) * 100)));
                                const label = htmlEncode(core.cpu || 'CPU');
                                return `
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">${label}</div>
                                        <div style="width:400px;height:14px;background:#eee;border-radius:4px;overflow:hidden;margin-right:8px;">
                                            <div style="width:${pct}%;height:100%;background:#2ea3ff;"></div>
                                        </div>
                                        <div style="width:80px;text-align:right;font-family:monospace;padding-left:8px;">${htmlEncode(speed)} MHz</div>
                                    </div>
                                `;
                            }).join('') +
                        `</div>`;

                        try {
                            if (cpuSpeedFieldSet.body && cpuSpeedFieldSet.body.dom) {
                                cpuSpeedFieldSet.body.dom.innerHTML = rowsHtml;
                            } else if (typeof cpuSpeedFieldSet.update === 'function') {
                                cpuSpeedFieldSet.update(rowsHtml);
                            } else {
                                throw new Error('Cannot find FieldSet body / update method');
                            }
                            if (typeof cpuSpeedFieldSet.doLayout === 'function') cpuSpeedFieldSet.doLayout();
                        } catch (err) {
                            console.error('cpuSpeedFieldSet HTML injection failed:', err);
                        }
                    } else {
                        cpuSpeedFieldSet.destroy();
                    }
                }

                // System Temperature Section
                var sysTempFieldSet = Ext.getCmp('sysTemp');
                if (sysTempFieldSet) {
                    sysTempFieldSet.removeAll(true);
                    if (config.sysTemp && config.sysTemp.length > 0) {
                        const maxTemp = 100;
                        const rowsHtml = `<div class="arc-temp-bars" style="padding:6px 0;">` +
                            config.sysTemp.map((sensor) => {
                                const temp = Number(sensor.stemp) || 0;
                                const pct = Math.min(100, Math.max(0, Math.round((temp / maxTemp) * 100)));
                                const label = htmlEncode(sensor.slabel || 'Temp');
                                let innerBg;
                                if (temp < 50) {
                                    innerBg = '#4caf50';
                                } else if (temp < 70) {
                                    innerBg = '#ffeb3b';
                                } else {
                                    innerBg = '#f44336';
                                }

                                return `
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">${label}</div>
                                        <div style="width:400px;height:14px;background:#eee};border-radius:4px;overflow:hidden;margin-right:8px;box-sizing:border-box;">
                                            <div style="width:${pct}%;height:100%;background:${innerBg};"></div>
                                        </div>
                                        <div style="width:80px;text-align:right;font-family:monospace;padding-left:8px;">${htmlEncode(temp)}°C</div>
                                    </div>
                                `;
                            }).join('') +
                        `</div>`;

                        try {
                            if (sysTempFieldSet.body && sysTempFieldSet.body.dom) {
                                sysTempFieldSet.body.dom.innerHTML = rowsHtml;
                            } else if (typeof sysTempFieldSet.update === 'function') {
                                sysTempFieldSet.update(rowsHtml);
                            } else {
                                throw new Error('Cannot find FieldSet body / update method');
                            }
                            if (typeof sysTempFieldSet.doLayout === 'function') sysTempFieldSet.doLayout();
                        } catch (err) {
                            console.error('sysTempFieldSet HTML injection failed:', err);
                        }
                    } else {
                        sysTempFieldSet.destroy();
                    }
                }

                // GPU Info Section
                var iGPUInfoFieldSet = Ext.getCmp('iGPUInfo');
                if (iGPUInfoFieldSet) {
                    iGPUInfoFieldSet.removeAll(true);
                    if (config.iGPUInfo && config.iGPUInfo.length > 0) {
                        const igpuRows = `<div class="arc-info-rows" style="padding:6px 0;">` +
                            config.iGPUInfo.map((dev) => {
                                return `
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">GPU</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(dev.iGPUN || '')}</div>
                                    </div>
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">Clock</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(dev.iGPUC || '')}</div>
                                    </div>
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">Memory</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(dev.iGPUM || '')}</div>
                                    </div>
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">Render Node</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(dev.iGPURD || '')}</div>
                                    </div>
                                `;
                            }).join('') +
                        `</div>`;

                        try {
                            if (iGPUInfoFieldSet.body && iGPUInfoFieldSet.body.dom) {
                                iGPUInfoFieldSet.body.dom.innerHTML = igpuRows;
                            } else if (typeof iGPUInfoFieldSet.update === 'function') {
                                iGPUInfoFieldSet.update(igpuRows);
                            } else {
                                throw new Error('Cannot find FieldSet body / update method');
                            }
                            if (typeof iGPUInfoFieldSet.doLayout === 'function') iGPUInfoFieldSet.doLayout();
                        } catch (err) {
                            console.error('iGPUInfo HTML injection failed:', err);
                        }
                    } else {
                        iGPUInfoFieldSet.destroy();
                    }
                }

                // Storage Controllers Section
                var storageControllersFieldSet = Ext.getCmp('controllerInfo');
                if (storageControllersFieldSet) {
                    storageControllersFieldSet.removeAll(true);
                    if (config.storageControllers && config.storageControllers.length > 0) {
                        const controllerRows = `<div class="arc-info-rows" style="padding:6px 0;">` +
                            config.storageControllers.map((controller, index) => {
                                const disks = (controller.disk_list || []).map((disk) => {
                                    const smartDetailsLink = disk.smart
                                        ? `<a href="#" class="smart-details-link" data-disk="${htmlEncode(disk.disk)}" style="color:#2ea3ff;text-decoration:underline;">Details</a>`
                                        : '';
                                    return `
                                        <div style="display:flex;align-items:center;margin:15px 0;">
                                            <div style="width:150px;font-weight:600;padding-right:8px;">${htmlEncode(disk.disk || '')}</div>
                                            <div style="flex:1;font-family:monospace;">
                                                ${htmlEncode(disk.model || '')} | Size: ${htmlEncode(disk.capacity || '')} GiB | Temp: ${htmlEncode(disk.temp || '')}°C | Status: ${htmlEncode(disk.status || '')} | ${htmlEncode(disk.smart || '')} | ${smartDetailsLink}
                                            </div>
                                        </div>
                                    `;
                                }).join('');

                                return `
                                    <div style="margin-bottom:15px;">
                                        <div style="display:flex;align-items:center;margin:15px 0;">
                                            <div style="width:150px;font-weight:600;padding-right:8px;">${htmlEncode(`Controller ${index}`) || ''}</div>
                                            <div style="flex:1;font-family:monospace;font-weight:600;">
                                                ${htmlEncode(controller.controller || 'Unknown Controller')} | Disks: ${htmlEncode(controller.disks || '0')}
                                            </div>
                                        </div>
                                        ${disks}
                                    </div>
                                `;
                            }).join('') +
                        `</div>`;

                        try {
                            if (storageControllersFieldSet.body && storageControllersFieldSet.body.dom) {
                                storageControllersFieldSet.body.dom.innerHTML = controllerRows;
                            } else if (typeof storageControllersFieldSet.update === 'function') {
                                storageControllersFieldSet.update(controllerRows);
                            } else {
                                throw new Error('Cannot find FieldSet body / update method');
                            }
                            if (typeof storageControllersFieldSet.doLayout === 'function') storageControllersFieldSet.doLayout();
                        } catch (err) {
                            console.error('storageControllers HTML injection failed:', err);
                        }
                    } else {
                        storageControllersFieldSet.destroy();
                    }
                }

                // NVMe Disks Section
                var nvmeDisksFieldSet = Ext.getCmp('nvmeDisks');
                if (nvmeDisksFieldSet) {
                    nvmeDisksFieldSet.removeAll(true);
                    if (config.nvmeDisks && config.nvmeDisks.length > 0) {
                        const nvmeRows = `<div class="arc-info-rows" style="padding:6px 0;">` +
                            config.nvmeDisks.map((dev) => {
                                const smartDetailsLink = `<a href="#" class="smart-details-link" data-disk="${htmlEncode(dev.disk)}" style="color:#2ea3ff;text-decoration:underline;">Details</a>`;
                                return `
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">${htmlEncode(dev.disk || '')}</div>
                                        <div style="flex:1;font-family:monospace;">
                                            ${htmlEncode(dev.model || '')} | Size: ${htmlEncode(dev.capacity || '')} GiB | Temp: ${htmlEncode(dev.temp || '')}°C | Crit Error: ${htmlEncode(dev.critwarn || '')} | Unsafe Shutdown: ${htmlEncode(dev.unsafeshutdown || '')} | ${smartDetailsLink}
                                        </div>
                                    </div>
                                `;
                            }).join('') +
                        `</div>`;

                        try {
                            if (nvmeDisksFieldSet.body && nvmeDisksFieldSet.body.dom) {
                                nvmeDisksFieldSet.body.dom.innerHTML = nvmeRows;
                            } else if (typeof nvmeDisksFieldSet.update === 'function') {
                                nvmeDisksFieldSet.update(nvmeRows);
                            } else {
                                throw new Error('Cannot find FieldSet body / update method');
                            }
                            if (typeof nvmeDisksFieldSet.doLayout === 'function') nvmeDisksFieldSet.doLayout();
                        } catch (err) {
                            console.error('nvmeDisks HTML injection failed:', err);
                        }
                    } else {
                        nvmeDisksFieldSet.destroy();
                    }
                }

                // Fan Speeds Section
                var fanSpeedsFieldSet = Ext.getCmp('fanSpeeds');
                if (fanSpeedsFieldSet) {
                    fanSpeedsFieldSet.removeAll(true);
                    if (config.fanSpeeds && config.fanSpeeds.length > 0) {
                        const fanRows = `<div class="arc-info-rows" style="padding:6px 0;">` +
                            config.fanSpeeds.map((dev) => {
                                return `
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">${htmlEncode(dev.fan || '')}</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(dev.rpm || '')} RPM</div>
                                    </div>
                                `;
                            }).join('') +
                        `</div>`;

                        try {
                            if (fanSpeedsFieldSet.body && fanSpeedsFieldSet.body.dom) {
                                fanSpeedsFieldSet.body.dom.innerHTML = fanRows;
                            } else if (typeof fanSpeedsFieldSet.update === 'function') {
                                fanSpeedsFieldSet.update(fanRows);
                            } else {
                                throw new Error('Cannot find FieldSet body / update method');
                            }
                            if (typeof fanSpeedsFieldSet.doLayout === 'function') fanSpeedsFieldSet.doLayout();
                        } catch (err) {
                            console.error('fanSpeeds HTML injection failed:', err);
                        }
                    } else {
                        fanSpeedsFieldSet.destroy();
                    }
                }

                // Network Info Section
                var networkInfoFieldSet = Ext.getCmp('networkInfo');
                if (networkInfoFieldSet) {
                    networkInfoFieldSet.removeAll(true);
                    if (config.networkInfo && config.networkInfo.length > 0) {
                        const netRows = `<div class="arc-info-rows" style="padding:6px 0;">` +
                            config.networkInfo.map((dev) => {
                                return `
                                    <div style="display:flex;align-items:center;margin:15px 0;">
                                        <div style="width:150px;font-weight:600;padding-right:8px;">${htmlEncode(dev.net || '')}</div>
                                        <div style="flex:1;font-family:monospace;">${htmlEncode(dev.model || '')} | Status: ${htmlEncode(dev.status || '')} | Speed: ${htmlEncode(dev.speed || '')} (${htmlEncode(dev.maxspeed || '')}) | Mac: ${htmlEncode(dev.mac || '')}</div>
                                    </div>
                                `;
                            }).join('') +
                        `</div>`;

                        try {
                            if (networkInfoFieldSet.body && networkInfoFieldSet.body.dom) {
                                networkInfoFieldSet.body.dom.innerHTML = netRows;
                            } else if (typeof networkInfoFieldSet.update === 'function') {
                                networkInfoFieldSet.update(netRows);
                            } else {
                                throw new Error('Cannot find FieldSet body / update method');
                            }
                            if (typeof networkInfoFieldSet.doLayout === 'function') networkInfoFieldSet.doLayout();
                        } catch (err) {
                            console.error('networkInfo HTML injection failed:', err);
                        }
                    } else {
                        networkInfoFieldSet.destroy();
                    }
                }

                // Call doLayout at the end for all field sets
                [cpuInfoFieldSet, cpuSpeedFieldSet, sysTempFieldSet, iGPUInfoFieldSet, storageControllersFieldSet, nvmeDisksFieldSet, fanSpeedsFieldSet, networkInfoFieldSet].forEach(fieldSet => {
                    if (fieldSet && !fieldSet.destroyed && typeof fieldSet.doLayout === 'function') {
                        fieldSet.doLayout();
                    }
                });

                // Bind click event to "Details" links
                if (!self.smartDetailsListenerAdded) {
                    document.addEventListener('click', function (event) {
                        if (event.target && event.target.classList.contains('smart-details-link')) {
                            event.preventDefault();
                            const disk = event.target.getAttribute('data-disk');
                            if (disk) {
                                self.showSmartPopup(disk);
                            }
                        }
                    });
                    self.smartDetailsListenerAdded = true;
                }

                var sysGeneral = Ext.getCmp('sysGeneral');
                if (sysGeneral && typeof sysGeneral.doLayout === 'function') {
                    sysGeneral.doLayout();
                }
                self.loaded = true;
            }).catch((error) => {
                console.error('Error fetching configuration:', error);
            });
        },

        // Add the showSmartPopup method
        showSmartPopup: function (disk) {
            const self = this;

            // Fetch SMART data
            Ext.Ajax.request({
                url: '/webman/3rdparty/arc-control/scripts/getSmartInfo.cgi',
                method: 'GET',
                params: { action: 'smartctl', disk },
                success: function (response) {
                    // Show SMART data in a new window
                    const smartOutput = htmlEncode(response.responseText);
                    self.showPrompt(
                        `Smart Status for ${disk}`,
                        '',
                        smartOutput,
                        null
                    );
                },
                failure: function (response) {
                    // Show error message in a new window
                    const errorContent = `Failed to fetch Smart Status for ${disk}: ${response.statusText}`;
                    self.showPrompt(
                        `Smart Status for ${disk}`,
                        '',
                        errorContent,
                        null
                    );
                }
            });
        },

        // Add the showPrompt method (if not already present)
        showPrompt: function (title, message, text, yesCallback) {
            var window = new SYNOCOMMUNITY.ARCControl.Overview.UpdateAvailableDialog({
                owner: this.appWin || null,
                title: title,
                message: message,
                msg: text,
                msgItemCount: 3,
                confirmCheck: true,
                btnOKHandler: yesCallback
            });
            window.open();
        },

        loadForm: function (e) {
            // this.getForm().setValues(e);
        }
    }));

// Global HTML encoding function
const htmlEncode = (str) => {
    if (!str) return '';
    return String(str)
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#39;');
};

/***/ }),

/***/ "./src/src/panels/healthPanel.js":
/*!***************************************!*\
  !*** ./src/src/panels/healthPanel.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony import */ var _utils_synoApiProvider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/synoApiProvider */ "./src/src/utils/synoApiProvider.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Overview.HealthPanel", {
        extend: "SYNO.ux.Panel",
        apiProvider: SYNOCOMMUNITY.ARCControl.SynoApiProvider,
        constructor: function (e) {
            this.appWin = e.appWin;
            this.owner = e.owner;
            this.helper = e.owner.helper;
            this.apiProvider.init(this);
            this.callParent([this.fillConfig(e)]);
        },
        onDataReady: function () {
            let status = "normal";
            this.iconTemplate.overwrite(this.getComponent("icon").getEl(), { status: status, 
                style:"background-image:url('webapi/entry.cgi?api=SYNO.Core.Synohdpack&version=1&method=getHDIcon&res=72&retina=false&path=webman/3rdparty/arc-control/images/arc-control-{0}.png&app_version=0.1'); background-size: cover;"
            }),
                this.titleTemplate.overwrite(this.upperPanel.getComponent("title").getEl(), {
                    status: status,
                }),
                this.updateDescription("current");
            // this.getComponent("arcActionsPanel")?.setVisible(true);
            this.owner.fireEvent("data_ready");
        },


        fillConfig: function (e) {
            this.poolLinkId = Ext.id();
            this.iconTemplate = this.createIconTpl();
            this.titleTemplate = this.createTitleTpl();
            this.upperPanel = this.createUpperPanel();
            this.lowerPanel = this.createLowerPanel();

            this.descriptionMapping = {
                normal: this.helper.V('ui', 'greetings_text'),
                target_abnormal: []
            };

            const panelConfig = {
                layout: "hbox",
                cls: "iscsi-overview-health-panel",
                autoHeight: true,
                items: [
                    { xtype: "box", itemId: "icon", cls: "health-icon-block" },
                    {
                        xtype: "syno_panel",
                        itemId: "rightPanel",
                        cls: "health-text-block",
                        flex: 1,
                        height: 90,
                        layout: "vbox",
                        layoutConfig: { align: "stretch" },
                        items: [this.upperPanel, this.lowerPanel],
                    }
                ],
                listeners: { scope: this, data_ready: this.onDataReady },
            };
            return Ext.apply(panelConfig, e), panelConfig;
        },
        createIconTpl: function () {
            return new Ext.XTemplate('<div class="health-icon {status}" style="{style}"></div>', {
                compiled: !0,
                disableFormats: !0,
            });
        },
        createTitleTpl: function () {
            return new Ext.XTemplate(
                '<div class="health-text-title {status}">{[this.getStatusText(values.status)]}</div>',
                {
                    compiled: !0,
                    disableFormats: !0,
                    statusText: {
                        normal: "Healthy",
                        warning: "Warning",
                        error: "Error"
                    },
                    getStatusText: function (e) {
                        return this.statusText[e];
                    },
                }
            );
        },
        createUpperPanel: function () {
            return new SYNO.ux.Panel({
                layout: "hbox",
                items: [
                    {
                        xtype: "box",
                        itemId: "title",
                        flex: 1,
                        cls: "iscsi-overview-health-title-block",
                    },
                    {
                        xtype: "syno_button",
                        itemId: "leftBtn",
                        hidden: !0,
                        cls: "iscsi-overview-health-prev-btn",
                        scope: this,
                        handler: this.onLeftBtnClick,
                        text: " ",
                    },
                    {
                        xtype: "syno_button",
                        itemId: "rightBtn",
                        hidden: !0,
                        cls: "iscsi-overview-health-next-btn",
                        scope: this,
                        handler: this.onRightBtnClick,
                        text: " ",
                    },
                ],
            });
        },
        createLowerPanel: function () {
            return new SYNO.ux.Panel({
                flex: 1,
                items: [
                    {
                        xtype: "syno_displayfield",
                        itemId: "desc",
                        cls: "health-text-content",
                        htmlEncode: !1,
                    },
                ],
            });
        },
        updateDescription: function (status) {
            const self = this;
            this.descriptions = [];
            let description,
                statusDescription,
                index = -1;
            const
                descriptionCount = this.descriptions.length,
                rightPanel = this.getComponent("rightPanel"),
                descriptionField = this.lowerPanel.getComponent("desc"),
                leftButton = this.upperPanel.getComponent("leftBtn"),
                rightButton = this.upperPanel.getComponent("rightBtn");
                initialHeight = descriptionField.getHeight();
            let panelHeight = rightPanel.getHeight(),
                isHeightChanged = false;
            statusDescription = this.descriptionMapping.normal;
            descriptionField.setValue(self.owner.systemInfoTxt);

            const updatedHeight = descriptionField.getHeight();
            if (
                (updatedHeight !== initialHeight && ((panelHeight = panelHeight - initialHeight + updatedHeight), (isHeightChanged = true)),
                    isHeightChanged && ((rightPanel.height = panelHeight), this.doLayout(), this.owner.doLayout()),
                    this.descriptions.length <= 1)
            )
                return leftButton.hide(), void rightButton.hide();
            (leftButton.hidden || rightButton.hidden) && (leftButton.show(), rightButton.show(), this.doLayout());
        },
        prepareSummaryStatus: function (status, data) {
            // Function body goes here
        },
    }));

/***/ }),

/***/ "./src/src/panels/loader/generalTab.js":
/*!*********************************************!*\
  !*** ./src/src/panels/loader/generalTab.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony import */ var _utils_synoApiProvider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/synoApiProvider */ "./src/src/utils/synoApiProvider.js");
/* harmony import */ var _utils_terminalHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/terminalHelper */ "./src/src/utils/terminalHelper.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Loader.GeneralTab", {
        extend: "SYNO.SDS.Utils.FormPanel",
        constructor: function (e) {
            // ensure appWin is available on this instance
            this.appWin = e && e.appWin ? e.appWin : this.appWin || null;
            this.callParent([this.fillConfig(e)]);
        },
        _prefix: '/webman/3rdparty/arc-control/scripts/',
        callCustomScript: function (scriptName) {
            return new Promise((resolve, reject) => {
                Ext.Ajax.request({
                    url: `${this._prefix}${scriptName}`,
                    method: 'GET',
                    timeout: 60000,
                    headers: {
                        'Content-Type': 'text/html'
                    },
                    success: function (response) {
                        if (typeof response?.responseText === 'string') {
                            resolve(Ext.decode(response?.responseText));
                        } else {
                            resolve(response?.responseText);
                        }
                    },
                    failure: function (result) {
                        if (typeof result?.responseText === 'string' && result?.responseText && !result?.responseText.startsWith('<')) {
                            var response = Ext.decode(result?.responseText);
                            reject(response?.error);
                        } else {
                            reject('Failed with status: ' + result?.status);
                        }
                    }
                });
            });
        },
        fillConfig: function (e) {
            this.suspendLcwPrompt = !1;

            const t = {
                title: "General",
                checkFormDirty: false,
                items: [
                    new SYNO.ux.FieldSet({
                        title: 'Loader Disk',
                        collapsible: true,
                        columns: 2,
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'Mount/unmount the loader disk.'
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Mount Loaderdisk',
                                btnStyle: 'blue',
                                handler: function () {
                                    this.callCustomScript('loaderDisk.cgi?action=mountall')
                                        .then((response) => {
                                            if (response.success) {
                                                // After mounting, check the status
                                                this.callCustomScript('loaderDisk.cgi?action=status')
                                                    .then((statusResponse) => {
                                                        if (statusResponse.success) {
                                                            this.showResponseMsg({ success: true, message: 'Loader disk mounted successfully and verified.' });
                                                        }
                                                    })
                                                    .catch((err) => {
                                                        this.showErrorMsg('Failed to verify mount status: ' + err);
                                                    });
                                            } else {
                                                this.showResponseMsg(response);
                                            }
                                        })
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Unmount Loaderdisk',
                                btnStyle: 'red',
                                handler: function () {
                                    this.callCustomScript('loaderDisk.cgi?action=unmount')
                                        .then((statusResponse) => {
                                                if (statusResponse.success) {
                                                    this.showResponseMsg({ success: true, message: 'Loader disk unmounted successfully and verified.' });
                                                }
                                            })
                                            .catch((err) => {
                                                this.showErrorMsg('Failed to verify unmount status: ' + err);
                                            });
                                },
                                scope: this
                            }
                        ]
                    }),
                    new SYNO.ux.FieldSet({
                        title: 'Loader Terminal',
                        collapsible: true,
                        columns: 2,
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'Use the loader terminal to manage the loader. (Do not use this until this text is removed)'
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Start Terminal',
                                btnStyle: 'red',
                                handler: function (button) {
                                    const self = this; // capture component
                                    const buttonRef = button;
                                    // Check if the loader disk is fully mounted
                                    this.callCustomScript('loaderDisk.cgi?action=status')
                                        .then((statusResponse) => {
                                            if (statusResponse.success) {
                                                // If the loader disk is mounted, proceed to check terminal status
                                                Ext.Ajax.request({
                                                    url: '/webman/3rdparty/arc-control/scripts/terminal.cgi?action=status',
                                                    method: 'GET',
                                                    success: function (response) {
                                                        const result = Ext.decode(response.responseText);
                                                        if (result.running) {
                                                            SYNOCOMMUNITY.ARCControl.TerminalHelper.stopTerminal()
                                                                .then(() => {
                                                                    buttonRef.setText('Start Terminal');
                                                                })
                                                                .catch((err) => {
                                                                    // use appWin message box for consistency
                                                                    if (self && self.appWin && self.appWin.getMsgBox) {
                                                                        self.appWin.getMsgBox().alert(self.appWin.title, `Failed to stop terminal: ${err}`);
                                                                    }
                                                                });
                                                        } else {
                                                            SYNOCOMMUNITY.ARCControl.TerminalHelper.startTerminal({
                                                                title: 'Terminal',
                                                                shell: '/usr/bin/arcsu sh -c "PATH=${PATH}:/mnt/initrd/bin && LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/mnt/initrd/lib && /mnt/initrd/opt/arc/arc.sh"'
                                                            })
                                                                .then(() => {
                                                                    buttonRef.setText('Stop Terminal');
                                                                })
                                                                .catch((err) => {
                                                                    if (self && self.appWin && self.appWin.getMsgBox) {
                                                                        self.appWin.getMsgBox().alert(self.appWin.title, `Failed to start terminal: ${err}`);
                                                                    }
                                                                });
                                                        }
                                                    },
                                                    failure: function (response) {
                                                        if (self && self.appWin && self.appWin.getMsgBox) {
                                                            self.appWin.getMsgBox().alert(self.appWin.title, `Failed to determine terminal status: HTTP ${response.status}`);
                                                        }
                                                    }
                                                });
                                            } else {
                                                // If the loader disk is not fully mounted, show an error message
                                                this.showErrorMsg('Loader disk is not fully mounted. Please mount the loader disk before starting the terminal.');
                                            }
                                        })
                                        .catch((err) => {
                                            this.showErrorMsg('Failed to verify loader disk status: ' + err);
                                        });
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Show Terminal',
                                btnStyle: 'blue',
                                handler: function () {
                                    const self = this;
                                    Ext.Ajax.request({
                                        url: '/webman/3rdparty/arc-control/scripts/terminal.cgi?action=status',
                                        method: 'GET',
                                        success: function (response) {
                                            const result = Ext.decode(response.responseText);
                                            if (result.running) {
                                                SYNOCOMMUNITY.ARCControl.TerminalHelper.showTerminalPopup({
                                                    title: 'Terminal'
                                                });
                                            } else {
                                                if (self && self.appWin && self.appWin.getMsgBox) {
                                                    self.appWin.getMsgBox().alert(self.appWin.title, 'The terminal is not running. Please start the terminal first.');
                                                }
                                            }
                                        },
                                        failure: function (response) {
                                            if (self && self.appWin && self.appWin.getMsgBox) {
                                                self.appWin.getMsgBox().alert(self.appWin.title, `Failed to determine terminal status: HTTP ${response.status}`);
                                            }
                                        }
                                    });
                                },
                                scope: this
                            }
                        ]
                    })
                ]
            };
            return Ext.apply(t, e),
                t;
        },
        initEvents: function () {
            this.mon(this, "activate", this.onActivate, this);
        },
        onActivate: function () {
        },
        showResponseMsg: function (response) {
            this.appWin.getMsgBox().alert(
                response.success ? 'Success' : 'Error',
                response.message
            );
        },
        showErrorMsg: function (error) {
            this.appWin.getMsgBox().alert('Error', error);
        }
    }));

/***/ }),

/***/ "./src/src/panels/service/generalTab.js":
/*!**********************************************!*\
  !*** ./src/src/panels/service/generalTab.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony import */ var _utils_synoApiProvider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/synoApiProvider */ "./src/src/utils/synoApiProvider.js");
/* harmony import */ var _utils_terminalHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/terminalHelper */ "./src/src/utils/terminalHelper.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Service.GeneralTab", {
        extend: "SYNO.SDS.Utils.FormPanel",
        constructor: function (e) {
            // ensure appWin is available on this instance
            this.appWin = e && e.appWin ? e.appWin : this.appWin || null;
            this.callParent([this.fillConfig(e)]);
        },
        _prefix: '/webman/3rdparty/arc-control/scripts/',
        callCustomScript: function (scriptName) {
            return new Promise((resolve, reject) => {
                Ext.Ajax.request({
                    url: `${this._prefix}${scriptName}`,
                    method: 'GET',
                    timeout: 60000,
                    headers: {
                        'Content-Type': 'text/html'
                    },
                    success: function (response) {
                        if (typeof response?.responseText === 'string') {
                            resolve(Ext.decode(response?.responseText));
                        } else {
                            resolve(response?.responseText);
                        }
                    },
                    failure: function (result) {
                        if (typeof result?.responseText === 'string' && result?.responseText && !result?.responseText.startsWith('<')) {
                            var response = Ext.decode(result?.responseText);
                            reject(response?.error);
                        } else {
                            reject('Failed with status: ' + result?.status);
                        }
                    }
                });
            });
        },
        fillConfig: function (e) {
            this.suspendLcwPrompt = !1;

            const defaultHddBay = 'RACK_0_Bay';
            const defaultSsdBay = '1X1';

            const t = {
                title: "General",
                checkFormDirty: false,
                items: [
                    new SYNO.ux.FieldSet({
                        title: 'StoragePanel (require storagepanel Addon)',
                        collapsible: true,
                        columns: 2,
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'This patch sets the StoragePanel view - to see the changes, please refresh the page.'
                            },
                            {
                                xtype: 'syno_combobox',
                                fieldLabel: 'HDD BAY',
                                itemId: 'hddBayDropdown',
                                id: 'hddBayDropdown',
                                store: [
                                    'RACK_0_Bay', 'RACK_2_Bay', 'RACK_4_Bay', 'RACK_8_Bay', 'RACK_10_Bay',
                                    'RACK_12_Bay', 'RACK_12_Bay_2', 'RACK_16_Bay', 'RACK_20_Bay', 'RACK_24_Bay',
                                    'RACK_60_Bay', 'TOWER_1_Bay', 'TOWER_2_Bay', 'TOWER_4_Bay', 'TOWER_4_Bay_J',
                                    'TOWER_4_Bay_S', 'TOWER_5_Bay', 'TOWER_6_Bay', 'TOWER_8_Bay', 'TOWER_12_Bay'
                                ],
                                editable: false,
                                queryMode: 'local',
                                allowBlank: false,
                                emptyText: 'Select HDD BAY',
                                value: defaultHddBay,
                                listeners: {
                                    change: function (combo, newValue) {
                                        const hddPreview = document.getElementById('hddBayPreview');
                                        if (hddPreview) {
                                            const match = newValue.match(/(RACK|TOWER)_(\d+)_Bay/);
                                            if (match) {
                                                const type = match[1].toLowerCase();
                                                const bayCount = match[2];
                                                hddPreview.src = `/webman/3rdparty/arc-control/images/panel/model_${bayCount}bay_${type}.png`;
                                            } else {
                                                console.warn('Invalid HDD_BAY value:', newValue);
                                                hddPreview.src = '';
                                            }
                                        }
                                    },
                                    scope: this
                                }
                            },
                            {
                                xtype: 'syno_combobox',
                                fieldLabel: 'M.2 BAY',
                                itemId: 'ssdBayDropdown',
                                id: 'ssdBayDropdown',
                                store: [
                                    '1X1', '1X2', '1X3', '1X4', '1X6', '1X8',
                                    '2X2', '2X3', '2X4', '2X6', '2X8', '3X4', '4X4'
                                ],
                                editable: false,
                                queryMode: 'local',
                                allowBlank: false,
                                emptyText: 'Select M.2 BAY',
                                value: defaultSsdBay,
                                listeners: {
                                    change: function (combo, newValue) {
                                        const ssdPreview = document.getElementById('ssdBayPreview');
                                        if (ssdPreview) {
                                            ssdPreview.src = `/webman/3rdparty/arc-control/images/panel/${newValue}.png`;
                                        }
                                    },
                                    scope: this
                                }
                            },
                            {
                                xtype: 'fieldset',
                                collapsible: false,
                                collapsed: false,
                                columns: 2,
                                border: false,
                                layout: 'table',
                                layoutConfig: {
                                    columns: 2 
                                },
                                defaults: {
                                    style: 'padding: 20px;',
                                    width: '50%'
                                },
                                items: [
                                    {
                                        xtype: 'box',
                                        itemId: 'hddBayPreviewBox',
                                        autoEl: {
                                            tag: 'img',
                                            id: 'hddBayPreview',
                                            src: `/webman/3rdparty/arc-control/images/panel/model_0bay_rack.png`,
                                            style: `
                                                display: block;
                                                max-width: 250px;
                                                max-height: 150px;
                                                margin: 0 auto;
                                            `
                                        }
                                    },
                                    {
                                        xtype: 'box',
                                        itemId: 'ssdBayPreviewBox',
                                        autoEl: {
                                            tag: 'img',
                                            id: 'ssdBayPreview',
                                            src: `/webman/3rdparty/arc-control/images/panel/1X1.png`,
                                            style: `
                                                display: block;
                                                max-width: 250px;
                                                max-height: 150px;
                                                margin: 0 auto;
                                            `
                                        }
                                    }
                                ]
                            },
                                                        {
                                xtype: 'syno_button',
                                text: 'Apply StoragePanel',
                                btnStyle: 'blue',
                                handler: function () {
                                    const hddDropdown = document.getElementById('hddBayDropdown');
                                    const ssdDropdown = document.getElementById('ssdBayDropdown');
                            
                                    if (!hddDropdown || !ssdDropdown) {
                                        self.appWin.getMsgBox().alert('Error', 'Dropdowns not found.');
                                        return;
                                    }
                            
                                    const hddBay = hddDropdown.value;
                                    const ssdBay = ssdDropdown.value;
                            
                                    if (!hddBay || !ssdBay) {
                                        self.appWin.getMsgBox().alert('Error', 'Please select both HDD_BAY and SSD_BAY options.');
                                        return;
                                    }
                            
                                    const url = `applyPatch.cgi?name=storagepanel&hdd=${encodeURIComponent(hddBay)}&ssd=${encodeURIComponent(ssdBay)}`;
                                    console.log('Constructed URL:', url);
                            
                                    this.callCustomScript(url)
                                        .then((response) => {
                                            this.showResponseMsg(response);
                                            this.getForm().reset();
                                            this.onActivate();
                                        })
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Set StoragePanel to auto',
                                btnStyle: 'green',
                                handler: function () {
                                    this.callCustomScript('applyPatch.cgi?name=storagepanel&option=auto')
                                        .then((response) => {
                                            this.showResponseMsg(response);
                                            this.getForm().reset();
                                            this.onActivate();
                                        })
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Reset StoragePanel',
                                btnStyle: 'red',
                                handler: function () {
                                    this.callCustomScript('applyPatch.cgi?name=storagepanel&option=reset')
                                        .then((response) => {
                                            this.showResponseMsg(response);
                                            this.getForm().reset();
                                            this.onActivate();
                                        })
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            }
                        ]
                    }),
                    new SYNO.ux.FieldSet({
                        title: 'Drive Database Patch (require hdddb Addon)',
                        collapsible: true,
                        columns: 2,
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'This will re-apply the Drive Database patch.'
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Apply Patch',
                                btnStyle: 'blue',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=hdddb&option=patch')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            }
                        ]
                    }),
                    new SYNO.ux.FieldSet({
                        title: 'Surveillance Local Display Fix (require apppatch Addon)',
                        collapsible: true,
                        columns: 2,
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'This patch fixes the local display issue in Surveillance Station.'
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Apply Fix',
                                btnStyle: 'blue',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=apppatch&option=localdisplay')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            }
                        ]
                    }),
                    new SYNO.ux.FieldSet({
                        title: 'Photos Face Patch (require apppatch Addon)',
                        collapsible: true,
                        columns: 2,
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'This patch enables face recognition features in Photo Station.'
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Apply Patch',
                                btnStyle: 'blue',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=apppatch&option=photosface')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            }
                        ]
                    }),
                    new SYNO.ux.FieldSet({
                        title: 'Fancontrol (require SA6400 and fancontrol Addon)',
                        collapsible: true,
                        columns: 2,
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'On = Fancontrol by DSM, Off = Fancontrol by BIOS, PWM Training = Read PWM values (Approx. 5 minutes - Wait until the training is finished and fans are back to normal.)'
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Fancontrol On',
                                btnStyle: 'green',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=fancontrol&option=on')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Fancontrol Off',
                                btnStyle: 'red',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=fancontrol&option=off')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'PWM Training',
                                btnStyle: 'blue',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=fancontrol&option=training')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            }
                        ]
                    }),
                    new SYNO.ux.FieldSet({
                        title: 'Ledcontrol (require SA6400 and ledcontrol Addon)',
                        collapsible: true,
                        columns: 2,
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'For UGREEN NAS: On = Leds On, Off = Leds Off, Auto = Leds Auto (Activity and Temperature controlled)'
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Leds On',
                                btnStyle: 'green',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=ledcontrol&option=on')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Leds Off',
                                btnStyle: 'red',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=ledcontrol&option=off')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Leds Auto',
                                btnStyle: 'blue',
                                handler: function() {
                                    this.callCustomScript('applyPatch.cgi?name=ledcontrol&option=auto')
                                        .then(this.showResponseMsg.bind(this))
                                        .catch(this.showErrorMsg.bind(this));
                                },
                                scope: this
                            }
                        ]
                    }),
                    new SYNO.ux.FieldSet({
                        title: 'External Patch',
                        collapsible: true,
                        columns: 2,
                        style: 'margin-bottom: 20px;',
                        items: [
                            {
                                xtype: 'syno_displayfield',
                                value: 'This patch allows you to install/patch packages with the AppInstaller.'
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Launch AppInstaller',
                                btnStyle: 'blue',
                                handler: function () {
                                    const self = this;
                                    this.callCustomScript('getAppInstaller.cgi')
                                        .then((response) => {
                                            if (response.success) {
                                                SYNOCOMMUNITY.ARCControl.TerminalHelper.showTerminalPopup({
                                                    title: 'AppInstaller'
                                                });
                                            } else {
                                                if (self && self.appWin && self.appWin.getMsgBox) {
                                                    self.appWin.getMsgBox().alert(self.appWin.title, response.message || 'Failed to start AppInstaller.');
                                                }
                                            }
                                        })
                                        .catch((err) => {
                                            if (self && self.appWin && self.appWin.getMsgBox) {
                                                self.appWin.getMsgBox().alert(self.appWin.title, `Failed to start AppInstaller: ${err}`);
                                            }
                                        });
                                },
                                scope: this
                            },
                            {
                                xtype: 'syno_button',
                                text: 'Stop AppInstaller',
                                btnStyle: 'red',
                                handler: function () {
                                    const self = this;
                                    Ext.Ajax.request({
                                        url: '/webman/3rdparty/arc-control/scripts/terminal.cgi?action=status',
                                        method: 'GET',
                                        success: function (response) {
                                            const result = Ext.decode(response.responseText);
                                            if (result.running) {
                                                SYNOCOMMUNITY.ARCControl.TerminalHelper.stopTerminal()
                                                    .then(() => {
                                                        if (self && self.appWin && self.appWin.getMsgBox) {
                                                            self.appWin.getMsgBox().alert(self.appWin.title, 'AppInstaller has been stopped.');
                                                        }
                                                    })
                                                    .catch((err) => {
                                                        if (self && self.appWin && self.appWin.getMsgBox) {
                                                            self.appWin.getMsgBox().alert(self.appWin.title, `Failed to stop AppInstaller: ${err}`);
                                                        }
                                                    });
                                            } else {
                                                if (self && self.appWin && self.appWin.getMsgBox) {
                                                    self.appWin.getMsgBox().alert(self.appWin.title, 'The AppInstaller is not running.');
                                                }
                                            }
                                        },
                                        failure: function (response) {
                                            if (self && self.appWin && self.appWin.getMsgBox) {
                                                self.appWin.getMsgBox().alert(self.appWin.title, `Failed to determine AppInstaller status: HTTP ${response.status}`);
                                            }
                                        }
                                    });
                                },
                                scope: this
                            }
                        ]
                    })
                ]
            };
            return Ext.apply(t, e),
                t;
        },
        initEvents: function () {
            this.mon(this, "activate", this.onActivate, this);
        },
                onActivate: function () {
            Ext.Ajax.request({
                url: '/webman/3rdparty/arc-control/scripts/applyPatch.cgi?name=storagepanel&option=read',
                method: 'GET',
                success: (response) => {
                    const result = Ext.decode(response.responseText);
                    if (result.success) {
                        const hddDropdown = document.getElementById('hddBayDropdown');
                        const ssdDropdown = document.getElementById('ssdBayDropdown');
                        const hddPreview = document.getElementById('hddBayPreview');
                        const ssdPreview = document.getElementById('ssdBayPreview');
        
                        if (hddDropdown) {
                            hddDropdown.value = result.hddBay;
                            // Manually trigger the change event for hddBayDropdown
                            hddDropdown.dispatchEvent(new Event('change'));
        
                            // Update the HDD preview image
                            if (hddPreview) {
                                const match = result.hddBay.match(/(RACK|TOWER)_(\d+)_Bay/);
                                if (match) {
                                    const type = match[1].toLowerCase();
                                    const bayCount = match[2];
                                    hddPreview.src = `/webman/3rdparty/arc-control/images/panel/model_${bayCount}bay_${type}.png`;
                                } else {
                                    console.warn('Invalid HDD_BAY value:', result.hddBay);
                                    hddPreview.src = '';
                                }
                            }
                        }
        
                        if (ssdDropdown) {
                            // Normalize server value: treat "1X0" as "1X1" and default to "1X1" if missing
                            let ssdValue = result.ssdBay || '1X1';
                            if (ssdValue === '1X0') {
                                ssdValue = '1X1';
                            }
                            ssdDropdown.value = ssdValue;
                            // Manually trigger the change event for ssdBayDropdown
                            ssdDropdown.dispatchEvent(new Event('change'));
        
                            // Update the SSD preview image
                            if (ssdPreview) {
                                ssdPreview.src = `/webman/3rdparty/arc-control/images/panel/${ssdValue}.png`;
                            }
                        }
                    }
                },
                failure: () => {
                    console.warn('Failed to fetch storage panel defaults.');
                }
            });
        },
        showResponseMsg: function (response) {
            this.appWin.getMsgBox().alert(
                response.success ? 'Success' : 'Error',
                response.message
            );
        },
        showErrorMsg: function (error) {
            this.appWin.getMsgBox().alert('Error', error);
        }
    }));

/***/ }),

/***/ "./src/src/panels/settings/arcConfigTab.js":
/*!*************************************************!*\
  !*** ./src/src/panels/settings/arcConfigTab.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Setting.ArcConfigTab", {
        extend: "SYNO.SDS.Utils.FormPanel",
        constructor: function (e) {
            this.callParent([this.fillConfig(e)]);
        },
        fillConfig: function (e) {
            this.suspendLcwPrompt = !1;
            const ethFields = [];

            const t = {
                title: "Arc Config",
                items: [
                    new SYNO.ux.FieldSet({
                        title: 'Arc Config',
                        collapsible: true,
                        items: [
                            {
                                fieldLabel: 'Serial Number',
                                name: 'sn',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'MAC for eth0',
                                name: 'eth0',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'MAC for eth1',
                                name: 'eth1',
                                allowBlank: true,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'Governor',
                                name: 'governor',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'Kernel',
                                name: 'kernel',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'Kernelload',
                                name: 'kernelload',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'Kernel Panic Timeout',
                                name: 'kernelpanic',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'Modules Blacklist',
                                name: 'modblacklist',
                                allowBlank: true,
                                xtype: 'syno_textfield',
                            }, {
                                boxLabel: 'Mount USB as Internal',
                                name: 'usbmount',
                                xtype: 'syno_checkbox',
                            }, {
                                boxLabel: 'Hotplug/Sort Disks',
                                name: 'hddsort',
                                xtype: 'syno_checkbox',
                            }, {
                                fieldLabel: 'Boot IP Timeout',
                                name: 'bootipwait',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                boxLabel: 'Official Driver Priority',
                                name: 'odp',
                                xtype: 'syno_checkbox',
                            }
                        ]
                    })
                ]
            };
            return Ext.apply(t, e),
                t;
        },
        initEvents: function () {
            this.mon(this, "activate", this.onActivate, this);
        },
        onActivate: function () {},
        loadForm: function (e) {
            this.getForm().setValues(e);
        },
        promptLcwDialog: function (e, t) {
            t && !this.suspendLcwPrompt && this.appWin.getMsgBox().show({
                title: this.title,
                msg: "ddd",
                buttons: {
                    yes: {
                        text: Ext.MessageBox.buttonText.yes,
                        btnStyle: "red"
                    },
                    no: {
                        text: Ext.MessageBox.buttonText.no
                    }
                },
                fn: function (e) {
                    "yes" !== e && this.form.findField("lcw_enabled").setValue(!1);
                },
                scope: this,
                icon: Ext.MessageBox.ERRORRED,
                minWidth: Ext.MessageBox.minWidth
            });
        }
    }));

/***/ }),

/***/ "./src/src/panels/settings/bootInfoTab.js":
/*!************************************************!*\
  !*** ./src/src/panels/settings/bootInfoTab.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Setting.BootInfoTab", {
        extend: "SYNO.SDS.Utils.FormPanel",
        constructor: function (e) {
            this.callParent([this.fillConfig(e)])
        },
        fillConfig: function (e) {
            this.suspendLcwPrompt = !1;
            const t = {
                title: "Bootscreen",
                items: [
                    new SYNO.ux.FieldSet({
                        title: 'Bootscreen Informations',
                        collapsible: true,
                        name: 'bootscreen',
                        items: [
                            {
                                boxLabel: 'DSM Information',
                                name: 'dsminfo',
                                xtype: 'syno_checkbox',
                            }, {
                                boxLabel: 'System Information',
                                name: 'systeminfo',
                                xtype: 'syno_checkbox',
                            }, {
                                boxLabel: 'Disk Information',
                                name: 'diskinfo',
                                xtype: 'syno_checkbox',
                            }, {
                                boxLabel: 'HardwareID Information',
                                name: 'hwidinfo',
                                xtype: 'syno_checkbox',
                            }, {
                                boxLabel: 'QR Code for DSM Connection',
                                name: 'dsmlogo',
                                xtype: 'syno_checkbox',
                            }
                        ]
                    })
                ]
            };
            return Ext.apply(t, e),
                t
        },
        initEvents: function () {
            this.mon(this, "activate", this.onActivate, this)
        },
        onActivate: function () {
        },
        loadForm: function (e) {
            this.getForm().setValues(e);
        },
        promptLcwDialog: function (e, t) {
            t && !this.suspendLcwPrompt && this.appWin.getMsgBox().show({
                title: this.title,
                msg: "ddd",
                buttons: {
                    yes: {
                        text: Ext.MessageBox.buttonText.yes,
                        btnStyle: "red"
                    },
                    no: {
                        text: Ext.MessageBox.buttonText.no
                    }
                },
                fn: function (e) {
                    "yes" !== e && this.form.findField("lcw_enabled").setValue(!1)
                },
                scope: this,
                icon: Ext.MessageBox.ERRORRED,
                minWidth: Ext.MessageBox.minWidth
            })
        }
    }));

/***/ }),

/***/ "./src/src/panels/settings/generalTab.js":
/*!***********************************************!*\
  !*** ./src/src/panels/settings/generalTab.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Setting.GeneralTab", {
        extend: "SYNO.SDS.Utils.FormPanel",
        constructor: function (e) {
            this.callParent([this.fillConfig(e)])
        },
        fillConfig: function (e) {
            this.suspendLcwPrompt = !1;
            const t = {
                title: "General",
                items: [
                    new SYNO.ux.FieldSet({
                        title: 'DSM Settings',
                        collapsible: true,
                        columns: 2,
                        items: [{
                                fieldLabel: 'Model',
                                name: 'model',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'Version',
                                name: 'productver',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'Platform',
                                name: 'platform',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'PAT Url',
                                name: 'paturl',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'PAT Checksum',
                                name: 'pathash',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }
                        ]
                    }),
                    new SYNO.ux.FieldSet({
                        title: 'Boot Settings',
                        collapsible: true,
                        columns: 2,
                        items: [{
                                fieldLabel: 'VID',
                                name: 'vid',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'PID',
                                name: 'pid',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'SataDOM',
                                name: 'satadom',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                fieldLabel: 'LKM',
                                name: 'lkm',
                                allowBlank: false,
                                xtype: 'syno_textfield',
                            }, {
                                boxLabel: 'RD Compressed',
                                name: 'rd-compressed',
                                xtype: 'syno_checkbox',
                            }
                        ]
                    })
                ]
            };
            return Ext.apply(t, e),
                t
        },
        initEvents: function () {
            this.mon(this, "activate", this.onActivate, this)
        },
        onActivate: function () {
        },
        loadForm: function (e) {
            this.getForm().setValues(e);
        },
        promptLcwDialog: function (e, t) {
            t && !this.suspendLcwPrompt && this.appWin.getMsgBox().show({
                title: this.title,
                msg: "ddd",
                buttons: {
                    yes: {
                        text: Ext.MessageBox.buttonText.yes,
                        btnStyle: "red"
                    },
                    no: {
                        text: Ext.MessageBox.buttonText.no
                    }
                },
                fn: function (e) {
                    "yes" !== e && this.form.findField("lcw_enabled").setValue(!1)
                },
                scope: this,
                icon: Ext.MessageBox.ERRORRED,
                minWidth: Ext.MessageBox.minWidth
            })
        }
    }));


/***/ }),

/***/ "./src/src/panels/statusBoxsPanel.js":
/*!*******************************************!*\
  !*** ./src/src/panels/statusBoxsPanel.js ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Overview.StatusBoxsPanel", {
        extend: "SYNO.ux.Panel",
        apiProvider: SYNOCOMMUNITY.ARCControl.SynoApiProvider,
        constructor: function (e) {
            this.appWin = e.appWin;
            this.owner = e.owner;
            this.helper = e.owner.helper;
            this.data = {};
            this.apiProvider.init(this);
            this.callParent([this.fillConfig(e)]);
        },
        onDataReady: function (data) {
            this.loadData(data);
            Ext.each(this.statusBoxes, (e) => {
                e.fireEvent("data_ready");
            });

            this.owner.fireEvent("data_ready");
        },
        fillConfig: function (e) {
            const statusBoxConfig = { owner: this, appWin: e.appWin, flex: 1 };
            this.selectedBox = "hw_info";
            this.statusBoxes = [
                new SYNOCOMMUNITY.ARCControl.Overview.StatusBox(
                    Ext.apply({
                        type: "hw_info", title: "DSM Info", storeKey: "hwinfo_summ",
                        data: {
                            title: "DSM Info",
                            icon: "🖥️",
                            text: this?.data?.systemInfoTxt ?? "--",
                            text2: this?.data?.systemInfoTxt ?? "--",
                            text3: this?.data?.systemInfoTxt ?? "--",
                            error: 0,
                            warning: 0,
                            healthy: 2,
                            type: "healthy"
                        }
                    }, statusBoxConfig)),
                new SYNO.ux.Panel({ width: 10 }),

                new SYNOCOMMUNITY.ARCControl.Overview.StatusBox(
                    Ext.apply({
                        type: "arc_info", title: "Arc Loader", storeKey: "arcinfo_summ",
                        data: {
                            title: "Arc Loader",
                            icon: "💊",
                            text: "This is some long text Arc",
                            version: this?.data?.arcVersion ?? "--",
                            error: 0,
                            warning: 0,
                            type: "healthy"
                        }
                    }, statusBoxConfig),
                ),
                new SYNO.ux.Panel({ width: 10 }),

                new SYNOCOMMUNITY.ARCControl.Overview.StatusBox(
                    Ext.apply(
                        {
                            type: "arcm_info", title: "Arc Control", storeKey: "arcminfo_summ",
                            data: {
                                title: "Arc Control",
                                icon: "🛡️",
                                text: "This is some long text Arc Control",
                                version: this?.data?.arcControlVersion ?? "--",
                                error: 0,
                                warning: 0,
                                type: "healthy"
                            }
                        }, statusBoxConfig)
                ),
            ];
            const panelConfig = {
                hidden: true,
                cls: "iscsi-overview-status-panel",
                layout: "hbox",
                layoutConfig: { align: "stretch" },
                items: this.statusBoxes,
                listeners: {
                    scope: this,
                    selectchange: this.onSelectChange,
                    data_ready: this.onDataReady,
                },
            };
            return Ext.apply(panelConfig, e), panelConfig;
        },
        onSelectChange: function (e) {
            console.log("--onSelectChange StatusBoxsPanel")
            // (this.clickedBox = e),
            //     Ext.each(this.statusBoxs, (e) => {
            //         e.fireEvent("update");
            //     }),
            //     this.owner.panels.detailPanel.fireEvent("select", e);
        },
        loadData: function (data) {
            const self = this;
            self.show();
            self.statusBoxes.forEach((statusBox) => {
                if (statusBox.tpl && statusBox.tpl.data) {
                    Ext.apply(statusBox.tpl.data, data);
                    statusBox.updateTpl();
                }
            });
        }
    }));

/***/ }),

/***/ "./src/src/tabs/addons.js":
/*!********************************!*\
  !*** ./src/src/tabs/addons.js ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Addons.Main", {
        extend: "SYNO.ux.GridPanel",
        helper: SYNOCOMMUNITY.ARCControl.Helper,
        itemsPerPage: 1e3,
        constructor: function (e) {
            this.appWin = e.appWin;
            const self = this;
            Ext.apply(self, e);
            let config = self.fillConfig(e);
            self.itemsPerPage = self.appWin.appInstance.getUserSettings(self.itemId + "-dsPageLimit") || self.itemsPerPage;
            self.callParent([config]);
            self.mon(
                self,
                "resize",
                (e, width, height) => {
                    self.updateFbarItems(width);
                },
                self
            );
        },
        getPageRecordStore: function () {
            return new Ext.data.SimpleStore({
                fields: ["value", "display"],
                data: [
                    [100, 100],
                    [500, 500],
                    [1e3, 1e3],
                    [3e3, 3e3],
                ],
            });
        },
        getCategoryStore: function () {
            return new Ext.data.SimpleStore({
                fields: ["value", "display"],
                data: [
                    ["", this.helper.V('ui', 'addons_all')],
                ],
            });
        },
        onChangeDisplayRecord: function (e, t, i) {
            const self = this,
                addonsStore = self.addonsStore;
            const newItemsPerPage = e.getValue();
            if (self.itemsPerPage !== newItemsPerPage) {
                self.itemsPerPage = newItemsPerPage;
                self.paging.pageSize = self.itemsPerPage;
                addonsStore.load({ params: { offset: 0, limit: self.itemsPerPage } });
                self.appWin.appInstance.setUserSettings(
                    self.itemId + "-dsPageLimit",
                    self.itemsPerPage
                );
            }
        },
        onChangeCategory: function (e, t, i) {
            const s = this,
                n = s.addonsStore,
                a = e.getValue();
            a !== n.baseParams.category &&
                (Ext.apply(n.baseParams, { category: a }), s.loadData());
        },
        initPageComboBox: function (e) {
            return new SYNO.ux.ComboBox({
                name: "page_rec",
                hiddenName: "page_rec",
                hiddenId: Ext.id(),
                store: e,
                displayField: "display",
                valueField: "value",
                triggerAction: "all",
                value: this.itemsPerPage,
                editable: !1,
                width: 72,
                mode: "local",
                listeners: { select: { fn: this.onChangeDisplayRecord, scope: this } },
            });
        },
        initCategoryComboBox: function (e) {
            return new SYNO.ux.ComboBox({
                name: "category",
                store: e,
                displayField: "display",
                valueField: "value",
                value: "",
                width: 120,
                mode: "local",
                listeners: { select: { fn: this.onChangeCategory, scope: this } },
            });
        },
        initPagingToolbar: function () {
            return new SYNO.ux.PagingToolbar({
                store: this.addonsStore,
                displayInfo: !0,
                pageSize: this.itemsPerPage,
                showRefreshBtn: !0,
                cls: "iscsi-log-toolbar",
                items: [
                    {
                        xtype: "tbtext",
                        style: "padding-right: 4px",
                        text: "Items per page",
                    },
                    this.initPageComboBox(this.getPageRecordStore()),
                ],
            });
        },
        initToolbar: function () {
            const e = this,
                t = new SYNO.ux.Toolbar();
            return (

                (e.saveButton = new SYNO.ux.Button({
                    xtype: "syno_button",
                    text: e.helper.V("ui", "save_addons_btn"),
                    handler: e.onAddonsSave,
                    btnStyle: "blue",
                    scope: e,
                })),
                (e.searchField = new SYNOCOMMUNITY.ARCControl.AdvancedSearchField({
                    iconStyle: "filter",
                    owner: e,
                })),
                (e.searchField.searchPanel = e.searchPanel),
                t.add(e.saveButton),
                t.add("->"),
                t.add(e.initCategoryComboBox(e.getCategoryStore())),
                t.add({ xtype: "tbspacer", width: 4 }),
                t.add(e.searchField),
                t
            );
        },
        initEvents: function () {
            this.mon(this, "activate", this.onActive, this);
        },
        getStore: function () {
            var gridStore = new SYNO.API.JsonStore({
                autoDestroy: true,
                appWindow: this.appWin,
                restful: true,
                root: "result",
                url: `/webman/3rdparty/arc-control/scripts/getAddons.cgi`,
                idProperty: "name",
                fields: [{
                    name: 'name',
                    type: 'string'
                }, {
                    name: 'version',
                    type: 'string'
                }, {
                    name: 'description',
                    type: 'object'
                }, {
                    name: 'installed',
                    type: 'boolean'
                }],
                listeners: {
                    exception: this.loadException,
                    beforeload: this.onBeforeStoreLoad,
                    load: this.onAfterStoreLoad,
                    scope: this,
                }
            });
            return gridStore;
        },
        getColumnModel: function () {
            this.Col1 = new SYNO.ux.EnableColumn({
                header: this.helper.V("ui", "col_installed"),
                dataIndex: "installed",
                name: "installed",
                id: "installed",
                width: 100,
                align: "center",
                enableFastSelectAll: false,
                disabled: false,
                bindRowClick: true
            });

            return new Ext.grid.ColumnModel({
                columns: [
                    {
                        header: this.helper.V("ui", "col_name"),
                        width: 60,
                        dataIndex: 'name'
                    }, {
                        header: this.helper.V("ui", "col_version"),
                        width: 30,
                        dataIndex: 'version'
                    }, {
                        header: this.helper.V("ui", "col_description"),
                        width: 300,
                        dataIndex: 'description'
                    }, this.Col1,
                ],
                defaults: { sortable: true, menuDisabled: !1 },
            });
        },
        fillConfig: function (e) {
            const t = this;
            (t.addonsStore = t.getStore()),
                (t.paging = t.initPagingToolbar());
            const i = {
                border: !1,
                trackResetOnLoad: !0,
                layout: "fit",
                itemId: "iscsi_log",
                tbar: t.initToolbar(),
                enableColumnMove: !1,
                enableHdMenu: !1,
                bbar: t.paging,
                store: t.addonsStore,
                colModel: t.getColumnModel(),
                view: new SYNO.ux.FleXcroll.grid.BufferView({
                    rowHeight: 27,
                    scrollDelay: 30,
                    borderHeight: 1,
                    emptyText: "no_log_available",
                    templates: {
                        cell: new Ext.XTemplate(
                            '<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} x-selectable {css}" style="{style}" tabIndex="-1" {cellAttr}>',
                            '<div class="{this.selectableCls} x-grid3-cell-inner x-grid3-col-{id}" {attr}>{value}</div>',
                            "</td>",
                            { selectableCls: SYNO.SDS.Utils.SelectableCLS }
                        ),
                    },
                }),
                plugins: [this.Col1],
                selModel: new Ext.grid.RowSelectionModel({
                    singleSelect: false
                }),
                loadMask: !0,
                stripeRows: !0,
                listeners: {
                    cellclick: {
                        delay: 100,
                        scope: this,
                        fn: this.onCellClick
                    },
                }
            };
            return Ext.apply(i, e), i;
        },
        onCellClick: function (grid, recordIndex, i, s) {
            // Ensure `grid.store` and `grid.store.data` are defined
            if (!grid.store || !grid.store.data || typeof grid.store.data.get !== "function") {
                console.error("Store or data is not initialized in onCellClick:", grid.store);
                return;
            }

            var record = grid.store.data.get(recordIndex);
            var id = grid.getColumnModel().getColumnAt(i).id;

            if (id === 'installed') {
                record.data.installed = !record.data.installed;
                grid.getView().refresh();
            }
        },
        isBelong: function (e, t) {
            let i;
            for (i in t) if (t[i] !== e[i]) return !1;
            return !0;
        },
        isTheSame: function (e, t) {
            return this.isBelong(e, t) && this.isBelong(t, e);
        },
        onSearch: function (e, t) {
            const i = this,
                s = i.addonsStore;
            if (!i.isTheSame(s.baseParams, t)) {
                const e = ["name", "description"];
                if (
                    (t.date_from &&
                        (t.date_from =
                            Date.parseDate(
                                t.date_from,
                                SYNO.SDS.DateTimeUtils.GetDateFormat()
                            ) / 1e3),
                        t.date_to)
                ) {
                    const e = Date.parseDate(
                        t.date_to,
                        SYNO.SDS.DateTimeUtils.GetDateFormat()
                    );
                    e.setDate(e.getDate() + 1), (t.date_to = e / 1e3 - 1);
                }
                e.forEach((e) => {
                    s.baseParams[e] = t[e];
                }),
                    i.loadData();
            }
            i.searchField.searchPanel.hide();
        },
        onActive: function () {
            if (this.loaded) return;
            this.loadData();
        },
        enableButtonCheck: function () {
            this.addonsStore.getTotalCount()
                ? (this.saveButton.enable())
                : (this.saveButton.disable());
        },
        loadData: function () {
            const e = this.addonsStore;
            const t = { offset: 0, limit: this.itemsPerPage };
            e.load({ params: t });
            this.enableButtonCheck();
            this.loaded = true;
        },
        loadException: function () {
            this.appWin.clearStatusBusy(), this.setMask(!0);
        },
        onBeforeStoreLoad: function (e, t) {
            this.appWin.setStatusBusy();
        },
        onAfterStoreLoad: function (e, t, i) {
            const s = this;

            // Ensure `t` is defined and is an array
            if (!Array.isArray(t)) {
                console.error("Invalid data format received in onAfterStoreLoad:", t);
                s.setMask(true); // Mask the grid if data is invalid
                return;
            }

            // Filter out system addons
            const filteredRecords = t.filter(record => record.data && !record.data.system);

            s.appWin.clearStatusBusy();
            filteredRecords.length < 1 ? s.setMask(true) : s.setMask(false);
            s.setPagingToolbar(e, s.paging);
            this.enableButtonCheck();

            // Update the grid with filteredRecords
            e.loadData(filteredRecords);
        },
        setMask: function (e) {
            SYNOCOMMUNITY.ARCControl.SetEmptyIcon(this, e);
        },
        setPagingToolbar: function (e, t) {
            this.setPagingToolbarVisible(t, e.getTotalCount() > this.itemsPerPage);
        },
        setPagingToolbarVisible: function (e, t) {
            e.setButtonsVisible(!0);
        },
        updateFbarItems: function (e) {
            this.isVisible();
        },
        showMsg: function (msg) {
            this.owner.getMsgBox().alert("title", msg);
        },
        onAddonsSave: function (e) {
            var installedAddons = this.addonsStore.getRange().filter(x => { return x.data.installed == true }).map((x) => { return x.id });
            var newAddons = {};
            installedAddons.forEach((x) => {
                newAddons[x] = '';
            });
            var arcConfigJson = localStorage.getItem("arcConfig");
            var arcConfig = JSON.parse(arcConfigJson);
            arcConfig.user_config.addons = newAddons;
            this.appWin.setStatusBusy();
            this.appWin.handleFileUpload(arcConfig.user_config);
        },
        destroy: function () {
            this.rowNav && (Ext.destroy(this.rowNav), (this.rowNav = null)),
                this.searchField && this.searchField.fireEvent("destroy"),
                this.callParent([this]);
        },
    }));

/***/ }),

/***/ "./src/src/tabs/debug.js":
/*!*******************************!*\
  !*** ./src/src/tabs/debug.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Debug.Main", {
    extend: "SYNO.SDS.Utils.TabPanel",
    API: {},
    constructor: function (e) {
        (this.appWin = e.appWin),
            (this.owner = e.owner),
            this.callParent([this.fillConfig(e)]);
    },
    _prefix: '/webman/3rdparty/arc-control/scripts/',
    callCustomScript: function (scriptName) {

        return new Promise((resolve, reject) => {
            Ext.Ajax.request({
                url: `${this._prefix}${scriptName}`,
                method: 'GET',
                timeout: 60000,
                headers: {
                    'Content-Type': 'text/html'
                },
                success: function (response) {
                    // if response text is string need to decode it
                    if (typeof response?.responseText === 'string') {
                        resolve(Ext.decode(response?.responseText));
                    } else {
                        resolve(response?.responseText);
                    }
                },
                failure: function (result) {
                    if (typeof result?.responseText === 'string' && result?.responseText && !result?.responseText.startsWith('<')) {
                        var response = Ext.decode(result?.responseText);
                        reject(response?.error);
                    }
                    else {
                        reject('Failed with status: ' + result?.status);
                    }
                }
            });
        });
    },
    fillConfig: function (e) {
        this.generalTab = new SYNOCOMMUNITY.ARCControl.Debug.GeneralTab({
            appWin: this.appWin,
            owner: this,
            itemId: "GeneralTab",
        });

        const tabs = [this.generalTab];

        const settingsConfig = {
            title: "Settings",
            autoScroll: true,
            useDefaultBtn: false,
            labelWidth: 200,
            fieldWidth: 240,
            activeTab: 0,
            deferredRender: false,
            items: tabs,
            listeners: {
                activate: this.updateAllForm,
                scope: this
            },
        };

        return Ext.apply(settingsConfig, e);
    },
    loadAllForms: function (e) {
        this.items.each((t) => {
            if (Ext.isFunction(t.loadForm)) {
                if (t.itemId == "SynoInfoTab") {
                    t.loadForm(e.synoinfo);
                } else {
                    t.loadForm(e);
                }
            }
        });
    },
    updateEnv: function (e) {
    },
    updateAllForm: async function () {
        this.setStatusBusy();
        try {
            const e = await this.getConf();
            this.loadAllForms(e), this.updateEnv(e);
        } catch (e) {
            SYNO.Debug(e);
        }
        this.clearStatusBusy();
    },
    getConf: function () {
        return this.callCustomScript('getBootInfo.cgi')
    },
    setConf: function () {
        var user_config = this.getParams();
        var arcConfigJson = localStorage.getItem("arcConfig");
        var arcConfigOrig = JSON.parse(arcConfigJson);
        arcConfigOrig.user_config = user_config;
        localStorage.setItem("arcConfig", JSON.stringify(arcConfigOrig));

        return this.appWin.handleFileUpload(user_config);
    }
}));


/***/ }),

/***/ "./src/src/tabs/disks.js":
/*!*******************************!*\
  !*** ./src/src/tabs/disks.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Disks.Main", {
    extend: "SYNO.SDS.Utils.TabPanel",
    API: {},
    constructor: function (e) {
        (this.appWin = e.appWin),
            (this.owner = e.owner),
            this.callParent([this.fillConfig(e)]);
    },
    _prefix: '/webman/3rdparty/arc-control/scripts/',
    callCustomScript: function (scriptName) {
        return new Promise((resolve, reject) => {
            Ext.Ajax.request({
                url: `${this._prefix}${scriptName}`,
                method: 'GET',
                timeout: 60000,
                headers: {
                    'Content-Type': 'text/html'
                },
                success: function (response) {
                    // if response text is string need to decode it
                    if (typeof response?.responseText === 'string') {
                        resolve(Ext.decode(response?.responseText));
                    } else {
                        resolve(response?.responseText);
                    }
                },
                failure: function (result) {
                    if (typeof result?.responseText === 'string' && result?.responseText && !result?.responseText.startsWith('<')) {
                        var response = Ext.decode(result?.responseText);
                        reject(response?.error);
                    }
                    else {
                        reject('Failed with status: ' + result?.status);
                    }
                }
            });
        });
    },
    fillConfig: function (e) {
        this.generalTab = new SYNOCOMMUNITY.ARCControl.Disks.GeneralTab({
            appWin: this.appWin,
            owner: this,
            itemId: "GeneralTab",
        });

        const tabs = [this.generalTab];

        const settingsConfig = {
            title: "Settings",
            autoScroll: true,
            useDefaultBtn: false,
            labelWidth: 200,
            fieldWidth: 240,
            activeTab: 0,
            deferredRender: false,
            items: tabs,
            listeners: {
                activate: this.updateAllForm,
                scope: this
            },
        };

        return Ext.apply(settingsConfig, e);
    },
    loadAllForms: function (e) {
        this.items.each((t) => {
            if (Ext.isFunction(t.loadForm)) {
                if (t.itemId == "SynoInfoTab") {
                    t.loadForm(e.synoinfo);
                } else {
                    t.loadForm(e);
                }
            }
        });
    },
    updateEnv: function (e) {
    },
    updateAllForm: async function () {
        this.setStatusBusy();
        try {
            const e = await this.getConf();
            this.loadAllForms(e), this.updateEnv(e);
        } catch (e) {
            SYNO.Debug(e);
        }
        this.clearStatusBusy();
    },
    getConf: function () {
        return this.callCustomScript('getSysInfo.cgi')
    }
}));


/***/ }),

/***/ "./src/src/tabs/loader.js":
/*!********************************!*\
  !*** ./src/src/tabs/loader.js ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Loader.Main", {
    extend: "SYNO.SDS.Utils.TabPanel",
    API: {},
    constructor: function (e) {
        (this.appWin = e.appWin),
            (this.owner = e.owner),
            this.callParent([this.fillConfig(e)]);
    },
    _prefix: '/webman/3rdparty/arc-control/scripts/',
    callCustomScript: function (scriptName) {

        return new Promise((resolve, reject) => {
            Ext.Ajax.request({
                url: `${this._prefix}${scriptName}`,
                method: 'GET',
                timeout: 60000,
                headers: {
                    'Content-Type': 'text/html'
                },
                success: function (response) {
                    // if response text is string need to decode it
                    if (typeof response?.responseText === 'string') {
                        resolve(Ext.decode(response?.responseText));
                    } else {
                        resolve(response?.responseText);
                    }
                },
                failure: function (result) {
                    if (typeof result?.responseText === 'string' && result?.responseText && !result?.responseText.startsWith('<')) {
                        var response = Ext.decode(result?.responseText);
                        reject(response?.error);
                    }
                    else {
                        reject('Failed with status: ' + result?.status);
                    }
                }
            });
        });
    },
    fillConfig: function (e) {
        this.generalTab = new SYNOCOMMUNITY.ARCControl.Loader.GeneralTab({
            appWin: this.appWin,
            owner: this,
            itemId: "GeneralTab",
        });

        const tabs = [this.generalTab];

        const settingsConfig = {
            title: "Settings",
            autoScroll: true,
            useDefaultBtn: false,
            labelWidth: 200,
            fieldWidth: 240,
            activeTab: 0,
            deferredRender: false,
            items: tabs,
            listeners: {
                activate: this.updateAllForm,
                scope: this
            },
        };

        return Ext.apply(settingsConfig, e);
    },
    loadAllForms: function (e) {
        this.items.each((t) => {
            if (Ext.isFunction(t.loadForm)) {
                if (t.itemId == "SynoInfoTab") {
                    t.loadForm(e.synoinfo);
                } else {
                    t.loadForm(e);
                }
            }
        });
    },
    updateEnv: function (e) {
    },
    updateAllForm: async function () {
        this.setStatusBusy();
        try {
            this.loadAllForms(e), this.updateEnv(e);
        } catch (e) {
            SYNO.Debug(e);
        }
        this.clearStatusBusy();
    }
}));


/***/ }),

/***/ "./src/src/tabs/main.js":
/*!******************************!*\
  !*** ./src/src/tabs/main.js ***!
  \******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony import */ var _components_dialogs_updateAvailableDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../components/dialogs/updateAvailableDialog */ "./src/src/components/dialogs/updateAvailableDialog.js");
/* harmony import */ var _utils_terminalHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/terminalHelper */ "./src/src/utils/terminalHelper.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Overview.Main", {
        extend: "SYNO.ux.Panel",
        helper: SYNOCOMMUNITY.ARCControl.Helper,
        apiProvider: SYNOCOMMUNITY.ARCControl.SynoApiProvider,
        formatString: function (str, ...args) {
            return str.replace(/{(\d+)}/g, function (match, number) {
                return typeof args[number] !== 'undefined' ? args[number] : match;
            });
        },
        handleFileUpload: function (jsonData) {
            if (jsonData) {
                this.apiProvider._handleFileUpload(jsonData)
                    .then(() => {
                        this.showMsg(this.helper.V('ui', 'arc_config_applied'));
                        this.appWin.clearStatusBusy();
                    })
                    .catch((error) => {
                        this.showMsg(`Error executing script: ${error}`);
                        this.appWin.clearStatusBusy();
                    });
            }
        },
        constructor: function (e) {
            this.installed = false;
            this.appWin = e.appWin;
            this.data = {
                myText: "test text"
            };
            this.appWin.handleFileUpload = this.handleFileUpload.bind(this);
            this.loaded = false;
            this.callParent([this.fillConfig(e)]);
            this.apiProvider.init(this.sendWebAPI.bind(this));
            this.mon(
                this,
                "data_ready",
                () => {
                    if (this.getActivePage)
                        this.getActivePage().fireEvent("data_ready");
                },
                this
            );
        },

        createActionsSection: function () {
            return new SYNO.ux.Panel({
                title: 'Actions',
                layout: 'vbox',
                items: [
                    {
                        xtype: 'syno_panel',
                        layout: 'hbox',
                        items: [
                            {
                                xtype: 'syno_compositefield',
                                items: [
                                    {
                                        xtype: 'box',
                                        itemId: 'loaderLabel',
                                        autoEl: {
                                            tag: 'div',
                                            html: 'Actions',
                                            style: 'font-weight:600; font-family:inherit; width:120px; display:inline-block; padding-top: 5px;'
                                        }
                                    },
                                    {
                                        xtype: 'syno_button',
                                        btnStyle: 'red',
                                        text: this.helper.V('health_panel', 'btn_from_build'),
                                        handler: () => {
                                            this.appWin.getMsgBox().confirm(
                                                this.appWin.title,
                                                "Reboot to Build Mode?",
                                                (btn) => {
                                                    if (btn === 'yes') {
                                                        this.apiProvider.loaderBuild()
                                                            .then(() => {})
                                                            .catch(() => {});
                                                    }
                                                }
                                            );
                                        },
                                    },
                                    {
                                        xtype: 'syno_button',
                                        btnStyle: 'green',
                                        text: this.helper.V('health_panel', 'btn_from_update'),
                                        handler: () => {
                                            this.appWin.getMsgBox().confirm(
                                                this.appWin.title,
                                                "Reboot to Update Mode?",
                                                (btn) => {
                                                    if (btn === 'yes') {
                                                        this.apiProvider.loaderUpdate()
                                                            .then(() => {})
                                                            .catch(() => {});
                                                    }
                                                }
                                            );
                                        },
                                    },
                                    {
                                        xtype: 'syno_button',
                                        btnStyle: 'blue',
                                        text: this.helper.V('health_panel', 'btn_from_config'),
                                        handler: () => {
                                            this.appWin.getMsgBox().confirm(
                                                this.appWin.title,
                                                "Reboot to Config Mode?",
                                                (btn) => {
                                                    if (btn === 'yes') {
                                                        this.apiProvider.loaderConfig()
                                                            .then(() => {})
                                                            .catch(() => {});
                                                    }
                                                }
                                            );
                                        },
                                    }
                                ]
                            },
                        ],
                    },
                ]
            });
        },

        createTerminalSection: function () {
            const self = this; // capture overview instance so we can use self.appWin in nested callbacks

            return {
                title: 'Terminal',
                xtype: 'syno_panel',
                layout: 'vbox',
                items: [
                    {
                        xtype: 'syno_panel',
                        layout: 'hbox',
                        items: [
                            {
                                xtype: 'syno_compositefield',
                                items: [
                                    {
                                        xtype: 'box',
                                        itemId: 'terminalLabel',
                                        autoEl: {
                                            tag: 'div',
                                            html: 'Terminal',
                                            style: 'font-weight:600; font-family:inherit; width:120px; display:inline-block; padding-top: 5px;'
                                        }
                                    },
                                    {
                                        xtype: 'syno_button',
                                        btnStyle: 'red',
                                        text: 'Start Terminal',
                                        itemId: 'startStopTerminalButton',
                                        handler: function () {
                                            const button = this;
                                            Ext.Ajax.request({
                                                url: '/webman/3rdparty/arc-control/scripts/terminal.cgi?action=status',
                                                method: 'GET',
                                                success: function (response) {
                                                    const result = Ext.decode(response.responseText);
                                                    if (result.running) {
                                                        SYNOCOMMUNITY.ARCControl.TerminalHelper.stopTerminal()
                                                            .then(() => {
                                                                button.setText('Start Terminal');
                                                            })
                                                            .catch((err) => {
                                                                // use appWin message box instead of TerminalHelper.showMsg
                                                                self.appWin.getMsgBox().alert(self.appWin.title, `Failed to stop terminal: ${err}`);
                                                            });
                                                    } else {
                                                        SYNOCOMMUNITY.ARCControl.TerminalHelper.startTerminal({
                                                            title: 'Terminal',
                                                            shell: 'login'
                                                        })
                                                            .then(() => {
                                                                button.setText('Stop Terminal');
                                                            })
                                                            .catch((err) => {
                                                                self.appWin.getMsgBox().alert(self.appWin.title, `Failed to start terminal: ${err}`);
                                                            });
                                                    }
                                                },
                                                failure: function (response) {
                                                    self.appWin.getMsgBox().alert(self.appWin.title, `Failed to determine terminal status: HTTP ${response.status}`);
                                                }
                                            });
                                        }
                                    },
                                    {
                                        xtype: 'syno_button',
                                        btnStyle: 'blue',
                                        text: 'Show Terminal',
                                        itemId: 'showTerminalButton',
                                        handler: function () {
                                            Ext.Ajax.request({
                                                url: '/webman/3rdparty/arc-control/scripts/terminal.cgi?action=status',
                                                method: 'GET',
                                                success: function (response) {
                                                    const result = Ext.decode(response.responseText);
                                                    if (result.running) {
                                                        SYNOCOMMUNITY.ARCControl.TerminalHelper.showTerminalPopup({
                                                            title: 'Terminal'
                                                        });
                                                    } else {
                                                        self.appWin.getMsgBox().alert(self.appWin.title, 'The terminal is not running. Please start the terminal first.');
                                                    }
                                                },
                                                failure: function (response) {
                                                    self.appWin.getMsgBox().alert(self.appWin.title, `Failed to determine terminal status: HTTP ${response.status}`);
                                                }
                                            });
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            };
        },

        createDiagnosticsSection: function () {
            return new SYNO.ux.Panel({
                title: 'Diagnostics',
                itemId: 'diagnosticsPanel',
                columns: 1,
                defaults: { labelStyle: 'font-weight:600;' },
                items: [
                    {
                        xtype: 'syno_panel',
                        plain: true,
                        deferredRender: false,
                        items: [
                            {
                                xtype: 'box',
                                itemId: 'diagnosticsBox',
                                autoEl: { html: '<div id="arc-diagnostics" style="padding:8px"></div>' }
                            }
                        ]
                    }
                ]
            });
        },

        loadDiagnosticsSection: async function () {
            try {
                const resp = await this.apiProvider.callCustomScript('getSysHome.cgi');
                const result = resp && resp.result ? resp.result : {};

                const cpuInfo = Array.isArray(result.cpuInfo) && result.cpuInfo.length ? result.cpuInfo[0] : {};
                const cpuModel = cpuInfo.model || '';
                const board = cpuInfo.board || '';
                const memory = cpuInfo.memory || '';
                const governor = cpuInfo.governor || ''; // Add Governor
                const gpuName = Array.isArray(result.iGPUInfo) && result.iGPUInfo.length ? result.iGPUInfo[0].iGPUN : ''; // Add GPU Name

                let highestSpeed = 0;
                if (Array.isArray(result.cpuSpeed) && result.cpuSpeed.length > 0) {
                    const latestReading = result.cpuSpeed[result.cpuSpeed.length - 1];
                    highestSpeed = Number(latestReading.speed) || 0;
                }

                let highestTemp = null;
                if (Array.isArray(result.sysTemp) && result.sysTemp.length > 0) {
                    const latestReading = result.sysTemp[result.sysTemp.length - 1];
                    const tempValue = Number(latestReading.stemp);
                    if (!Number.isNaN(tempValue)) {
                        highestTemp = tempValue;
                    }
                }

                const maxSpeed = 5000;
                const speedPct = Math.min(100, Math.max(0, Math.round((highestSpeed / maxSpeed) * 100)));
                const maxTemp = 100;
                const tempPct = highestTemp !== null ? Math.min(100, Math.max(0, Math.round((highestTemp / maxTemp) * 100))) : 0;

                let tempColor = '#4caf50';
                if (highestTemp !== null) {
                    if (highestTemp < 50) tempColor = '#4caf50';
                    else if (highestTemp < 70) tempColor = '#ffeb3b';
                    else tempColor = '#f44336';
                }

                const encode = (s) => {
                    const str = String(s == null ? '' : s);
                    return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
                };

                const diagnosticsHtml = `
                    <div style="font-family:inherit;">
                        <div style="display:flex;align-items:center;margin:15px 0;">
                            <div style="width:120px;font-weight:600;padding-right:8px;">CPU</div>
                            <div style="flex:1;font-family:monospace;">${encode(cpuModel)}</div>
                        </div>
                        <div style="display:flex;align-items:center;margin:15px 0;">
                            <div style="width:120px;font-weight:600;padding-right:8px;">Board</div>
                            <div style="flex:1;font-family:monospace;">${encode(board)}</div>
                        </div>
                        <div style="display:flex;align-items:center;margin:15px 0;">
                            <div style="width:120px;font-weight:600;padding-right:8px;">Memory</div>
                            <div style="flex:1;font-family:monospace;">${encode(memory)}</div>
                        </div>
                        ${gpuName ? `
                        <div style="display:flex;align-items:center;margin:15px 0;">
                            <div style="width:120px;font-weight:600;padding-right:8px;">GPU</div>
                            <div style="flex:1;font-family:monospace;">${encode(gpuName)}</div>
                        </div>` : ''}
                        <div style="display:flex;align-items:center;margin:15px 0;">
                            <div style="width:120px;font-weight:600;padding-right:8px;">Governor</div>
                            <div style="flex:1;font-family:monospace;">${encode(governor)}</div>
                        </div>
                        <div style="display:flex;align-items:center;margin:15px 0;">
                            <div style="width:120px;font-weight:600;padding-right:8px;">Clock</div>
                            <div style="width:360px;height:14px;background:#eee;border-radius:4px;overflow:hidden;margin-right:8px;">
                                <div style="width:${speedPct}%;height:100%;background:#2ea3ff;"></div>
                            </div>
                            <div style="width:80px;text-align:right;font-family:monospace;padding-left:8px;">${encode(highestSpeed)} MHz</div>
                        </div>
                        ${highestTemp !== null ? `
                        <div style="display:flex;align-items:center;margin:15px 0;">
                            <div style="width:120px;font-weight:600;padding-right:8px;">Temp</div>
                            <div style="width:360px;height:14px;background:#eee;border-radius:4px;overflow:hidden;margin-right:8px;box-sizing:border-box;">
                                <div style="width:${tempPct}%;height:100%;background:${tempColor};"></div>
                            </div>
                            <div style="width:80px;text-align:right;font-family:monospace;padding-left:8px;">${encode(highestTemp)}°C</div>
                        </div>` : ''}
                    </div>
                `;

                let fs = (this.panels && this.panels.diagnosticsPanel) ? this.panels.diagnosticsPanel : null;

                try {
                    if (!fs && this.down && typeof this.down === 'function') {
                        fs = this.down('#diagnosticsPanel') || this.down('fieldset[itemId=diagnosticsPanel]') || null;
                    }
                    if (!fs && this.getComponent && typeof this.getComponent === 'function') {
                        fs = this.getComponent('diagnosticsPanel') || null;
                    }
                } catch (e) {
                    fs = fs || null;
                }

                if (!fs && typeof Ext !== 'undefined' && Ext.ComponentQuery && typeof Ext.ComponentQuery.query === 'function') {
                    try {
                        fs = Ext.ComponentQuery.query('#diagnosticsPanel', this)[0] ||
                             Ext.ComponentQuery.query('fieldset[itemId=diagnosticsPanel]', this)[0] || fs || null;
                    } catch (e) {
                        fs = fs || null;
                    }
                }

                if (!fs) {
                    const domNode = (typeof document !== 'undefined') ? document.getElementById('arc-diagnostics') : null;
                    if (domNode) {
                        domNode.innerHTML = diagnosticsHtml;
                    }
                    return;
                }

                let inner = null;
                try {
                    if (fs.down && typeof fs.down === 'function') inner = fs.down('syno_panel') || fs.down('panel') || null;
                    if (!inner && fs.items && fs.items.items && fs.items.items.length) inner = fs.items.items[0];
                    if (!inner && fs.getComponent && typeof fs.getComponent === 'function') inner = fs.getComponent(0) || null;
                } catch (e) { inner = null; }

                const container = inner || fs;

                let box = null;
                try {
                    if (container.down && typeof container.down === 'function') box = container.down('#diagnosticsBox') || container.down('box[itemId=diagnosticsBox]');
                    if (!box && container.getComponent && typeof container.getComponent === 'function') box = container.getComponent('diagnosticsBox');
                    if (!box && container.query && typeof container.query === 'function') box = container.query('#diagnosticsBox')[0] || null;
                } catch (e) { box = null; }

                if (box) {
                    if (typeof box.update === 'function') {
                        box.update(diagnosticsHtml);
                    } else if (box.el && box.el.dom) {
                        box.el.dom.innerHTML = diagnosticsHtml;
                    } else if (!box.rendered) {
                        if (box.autoEl) box.autoEl.html = diagnosticsHtml;
                        else box.autoEl = { tag: 'div', html: diagnosticsHtml, style: 'padding:8px' };
                    } else if (box.getEl && typeof box.getEl === 'function') {
                        const el = box.getEl();
                        if (el && el.dom) el.dom.innerHTML = diagnosticsHtml;
                    } else {
                        const domNode = (typeof document !== 'undefined') ? document.getElementById('arc-diagnostics') : null;
                        if (domNode) domNode.innerHTML = diagnosticsHtml;
                    }

                    const refreshLayout = (cmp) => {
                        try {
                            if (!cmp) return;
                            if (cmp.body && cmp.body.dom && cmp.body.dom.style) {
                                cmp.body.dom.style.height = 'auto';
                                cmp.body.dom.style.minHeight = '40px';
                            }
                            if (typeof cmp.doLayout === 'function') cmp.doLayout();
                            if (typeof cmp.updateLayout === 'function') cmp.updateLayout();
                            if (cmp.ownerCt && typeof cmp.ownerCt.doLayout === 'function') cmp.ownerCt.doLayout();
                        } catch (e) { /* ignore */ }
                    };
                    refreshLayout(container || fs);
                    refreshLayout(fs);
                    try {
                        const el = (box && (box.el && box.el.dom)) || (box && box.getEl && box.getEl() && box.getEl().dom) || null;
                        if (el && el.parentNode && el.parentNode.style) {
                            el.parentNode.style.height = 'auto';
                        }
                    } catch (e) { /* ignore */ }
                    return;
                }

                try {
                    if (typeof container.removeAll === 'function') container.removeAll(true);
                    container.add({
                        xtype: 'box',
                        itemId: 'diagnosticsBox',
                        autoEl: { tag: 'div', html: diagnosticsHtml, style: 'padding:8px' }
                    });
                    try {
                        if (container.body && container.body.dom && container.body.dom.style) {
                            container.body.dom.style.height = 'auto';
                            container.body.dom.style.minHeight = '40px';
                        }
                    } catch (e) {}
                    if (typeof container.doLayout === 'function') container.doLayout();
                    if (typeof fs.doLayout === 'function') fs.doLayout();
                    if (typeof container.updateLayout === 'function') container.updateLayout();
                } catch (addErr) {
                    if (fs.body && fs.body.dom) {
                        fs.body.dom.innerHTML = diagnosticsHtml;
                        try { fs.body.dom.style.height = 'auto'; fs.body.dom.style.minHeight = '40px'; } catch(e){}
                    } else {
                        const domNode = (typeof document !== 'undefined') ? document.getElementById('arc-diagnostics') : null;
                        if (domNode) domNode.innerHTML = diagnosticsHtml;
                        else console.error('loadDiagnosticsSection: Failed to render diagnostics', addErr);
                    }
                }
            } catch (err) {
                // Suppress the error silently
            }
        },

        updateDiagnosticsSummary: function () {
            try {
                if (typeof this.loadDiagnosticsSection === 'function') return this.loadDiagnosticsSection();
            } catch (err) {
                // Suppress the error silently
            }
        },

        startDiagnosticsTimer: function () {
            if (this._diagnosticsInterval) return;
            try {
                if (typeof this.loadDiagnosticsSection === 'function') {
                    this.loadDiagnosticsSection().catch(() => {});
                }
            } catch (e) { /* ignore */ }
            this._diagnosticsInterval = setInterval(() => {
                try {
                    if (typeof this.loadDiagnosticsSection === 'function') {
                        this.loadDiagnosticsSection().catch(() => {});
                    }
                } catch (e) { /* ignore */ }
            }, 5000);
        },

        stopDiagnosticsTimer: function () {
            if (this._diagnosticsInterval) {
                clearInterval(this._diagnosticsInterval);
                this._diagnosticsInterval = null;
            }
        },

        startTerminalStatusTimer: function () {
            if (this._terminalStatusInterval) return;

            this.updateTerminalButtonStatus();

            this._terminalStatusInterval = setInterval(() => {
                this.updateTerminalButtonStatus();
            }, 2000);
        },

        stopTerminalStatusTimer: function () {
            if (this._terminalStatusInterval) {
                clearInterval(this._terminalStatusInterval);
                this._terminalStatusInterval = null;
            }
        },

        updateTerminalButtonStatus: function () {
            const terminalPanel = document.querySelector('[itemId="arcTerminalPanel"]');

            if (!terminalPanel) {
                return;
            }

            const button = terminalPanel.querySelector('[itemId="startStopTerminalButton"]');
            if (!button) {
                return;
            }

            Ext.Ajax.request({
                url: '/webman/3rdparty/arc-control/scripts/terminal.cgi?action=status',
                method: 'GET',
                success: function (response) {
                    const result = Ext.decode(response.responseText);
                    if (result.running) {
                        button.innerText = 'Stop Terminal';
                    } else {
                        button.innerText = 'Start Terminal';
                    }
                }
            });
        },
        destroy: function () {
            // cleanup timer
            try { this.stopDiagnosticsTimer(); } catch (e) {}
            try { this.stopTerminalStatusTimer(); } catch (e) {}
            if (this.callParent) this.callParent(arguments);
        },

        fillConfig: function (e) {
            this.panels = {
                healthPanel: new SYNOCOMMUNITY.ARCControl.Overview.HealthPanel({
                    appWin: e.appWin,
                    owner: this,
                }),
                statusBoxsPanel: new SYNOCOMMUNITY.ARCControl.Overview.StatusBoxsPanel({
                    appWin: e.appWin,
                    owner: this,
                }),
                diagnosticsPanel: this.createDiagnosticsSection(),
                actionsPanel: {
                    xtype: "syno_panel",
                    itemId: "arcActionsPanel",
                    cls: "iscsi-overview-statusbox iscsi-overview-statusbox-lun iscsi-overview-statusbox-healthy iscsi-overview-statusbox-click",
                    flex: 1,
                    height: 35,
                    hidden: true,
                    layout: "vbox",
                    layoutConfig: { align: "stretch" },
                    items: [this.createActionsSection()],
                },
                terminalPanel: {
                    xtype: "syno_panel",
                    itemId: "arcTerminalPanel",
                    cls: "iscsi-overview-statusbox iscsi-overview-statusbox-lun iscsi-overview-statusbox-healthy iscsi-overview-statusbox-click",
                    flex: 1,
                    height: 70,
                    hidden: true,
                    layout: "vbox",
                    layoutConfig: { align: "stretch" },
                    items: [this.createTerminalSection()],
                },
            };
            const t = {
                itemId: "taskTabPanel",
                deferredRender: false,
                layoutOnTabChange: true,
                border: false,
                plain: true,
                activeTab: 0,
                region: "center",
                height: 500,
                layout: "vbox",
                cls: "blue-border",
                layoutConfig: { align: "stretch" },
                items: Object.values(this.panels),
                listeners: {
                    scope: this,
                    activate: this.onActivate,
                    deactivate: this.onDeactive,
                    data_ready: this.onDataReady,
                },
            };
            return Ext.apply(t, e), t;
        }, _getArcConfig: async function () {
            const arcConfigJson = localStorage.getItem('arcConfig');
            if (arcConfigJson) {
                return JSON.parse(arcConfigJson);
            }
            return await self.getConf();
        },
        showPrompt: function (title, message, text, yesCallback) {
            var window = new SYNOCOMMUNITY.ARCControl.Overview.UpdateAvailableDialog({
                owner: this.appWin,
                title: title,
                message: message,
                msg: text,
                msgItemCount: 3,
                confirmCheck: true,
                btnOKHandler: yesCallback
            });
            window.open();
        },
        onActivate: function () {
            const self = this;
            if (this.loaded) {
                try {
                    this.startDiagnosticsTimer();
                } catch (e) {
                    // Suppress the error silently
                }
                
                try {
                    this.startTerminalStatusTimer();
                } catch (e) {
                    // Suppress the error silently
                }
                return;
            }
            self.appWin.setStatusBusy({ text: 'Loading System Info...' });
            (async () => {
                try {
                    const [systemInfo, packages, arcCheckVersion] = await Promise.all([
                        self.apiProvider.getSytemInfo(),
                        self.apiProvider.getPackagesList(),
                        self.apiProvider.checkARCVersion()
                    ]);
                    self.systemInfo = systemInfo;
                    var isModernDSM = systemInfo.version_string.includes("7.2.2");
                    self.apiProvider.setIsModernDSM(isModernDSM);

                    if (systemInfo && packages) {
                        self.arcCheckVersion = arcCheckVersion;
                        self.systemInfoTxt = `Welcome to Arc Control`;
                        const arcControlPackage = packages.packages.find((packageInfo) => packageInfo.id == 'arc-control');

                        self.panels?.healthPanel?.fireEvent(
                            "select",
                            self.panels?.healthPanel?.clickedBox
                        );
                        self.panels.statusBoxsPanel.fireEvent(
                            "select",
                            self.panels.statusBoxsPanel.clickedBox
                        );
                        await self.updateAllForm();

                        try {
                            await self.loadDiagnosticsSection();
                            Ext.defer(() => { try { self.loadDiagnosticsSection().catch(() => {}); } catch (e) {} }, 400);
                            Ext.defer(() => { this.startDiagnosticsTimer(); }, 200);
                        } catch (diagErr) {
                            // Suppress the error silently
                        }

                        var data = {
                            text: `Model: ${systemInfo?.model}`,
                            text2: `Memory: ${systemInfo?.ram} MB`,
                            text3: `Version: ${systemInfo?.version_string}`,
                            arcControlVersion: `${arcControlPackage?.version}`,
                            arcVersion: self.arcConfig.arc_version,
                        };
                        Ext.apply(data, self.data);
                        self.installed = true;
                        self.panels?.healthPanel?.fireEvent("data_ready");
                        self.panels?.statusBoxsPanel?.fireEvent("data_ready", data);
                        self.loaded = true;
                    }

                    if (arcCheckVersion && self.isUpdateAvailable(arcCheckVersion)) {
                        self.showPrompt(self.helper.V('ui', 'prompt_update_available_title'),
                            self.helper.formatString(self.helper.V('ui', 'prompt_update_available_message'), arcCheckVersion.tag),
                            arcCheckVersion.notes);
                    }
                } catch (error) {
                    self.appWin.clearStatusBusy();
                    self.showMsg(`Error during Arc Control initialization: mountloader Addon missing`);
                    return;
                }
            })();
        },
        isUpdateAvailable: function (arcCheckVersion) {
            if (arcCheckVersion?.status !== "update available" || arcCheckVersion?.tag == "null" || this.arcConfig.arc_version === arcCheckVersion?.tag) {
                return false;
            }

            const currentVersion = this.arcConfig.arc_version.split('.').map(Number);
            const newVersion = arcCheckVersion.tag.split('.').map(Number);

            for (let i = 0; i < Math.max(currentVersion.length, newVersion.length); i++) {
                const current = currentVersion[i] || 0;
                const newVer = newVersion[i] || 0;
                if (newVer > current) {
                    return true;
                } else if (newVer < current) {
                    return false;
                }
            }

            return false;
        },

        showMsg: function (msg) {
            this.owner.getMsgBox().alert("title", msg);
        },
        updateAllForm: async function () {
            this.owner.setStatusBusy();
            try {
                const arcConfig = await this.getConf();
                var configName = 'arcConfig';

                this.appWin[configName] = arcConfig;
                this[configName] = arcConfig;

                localStorage.setItem(configName, JSON.stringify(arcConfig));
            } catch (e) {
                SYNO.Debug(e);
            } finally {
                this.owner.clearStatusBusy();
            }
        },

        getConf: function () {
            return this.apiProvider.callCustomScript('getConfig.cgi')
        },
        onDeactive: function () {
            this.panels?.healthPanel?.fireEvent(
                "deactivate",
                this.panels?.healthPanel?.clickedBox
            );
            try { this.stopDiagnosticsTimer(); } catch (e) {}
            try { this.stopTerminalStatusTimer(); } catch (e) {}
        },
        onDataReady: async function () {
            const e = this;
            e.loaded = true;
            e.getComponent("arcActionsPanel")?.setVisible(true);
            e.getComponent("arcTerminalPanel")?.setVisible(true);
            e.doLayout();
            e.appWin.clearStatusBusy();
        },
        getActivateOverviewPanel: function () {
            if (this.getActiveTab()) {
                return this.getActiveTab().overviewPanel;
            }
            return null;
        },
    }));
    try {
    if (undefined.panels && undefined.panels.healthPanel && typeof undefined.panels.healthPanel.on === 'function') {
        undefined.panels.healthPanel.on('select', () => {
            try {
                // make diagnostics panel visible if it's hidden
                try {
                    const diagCmp = undefined.getComponent ? undefined.getComponent('diagnosticsPanel') : (undefined.panels && undefined.panels.diagnosticsPanel);
                    if (diagCmp && typeof diagCmp.setVisible === 'function') {
                        diagCmp.setVisible(true);
                    }
                } catch (e) { /* ignore */ }

                // ensure diagnostics HTML is loaded/rendered
                if (typeof undefined.loadDiagnosticsSection === 'function') {
                    undefined.loadDiagnosticsSection().catch(() => {});
                }

                // try to scroll the diagnostics DOM node into view if present
                try {
                    const domNode = document.getElementById('arc-diagnostics') || document.querySelector('[itemId="diagnosticsPanel"]');
                    if (domNode && typeof domNode.scrollIntoView === 'function') {
                        domNode.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    }
                } catch (e) { /* ignore */ }
            } catch (e) { /* ignore */ }
        }, undefined);
    }
} catch (e) { /* ignore */ }

/***/ }),

/***/ "./src/src/tabs/service.js":
/*!*********************************!*\
  !*** ./src/src/tabs/service.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Service.Main", {
    extend: "SYNO.SDS.Utils.TabPanel",
    API: {},
    constructor: function (e) {
        (this.appWin = e.appWin),
            (this.owner = e.owner),
            this.callParent([this.fillConfig(e)]);
    },
    _prefix: '/webman/3rdparty/arc-control/scripts/',
    callCustomScript: function (scriptName) {

        return new Promise((resolve, reject) => {
            Ext.Ajax.request({
                url: `${this._prefix}${scriptName}`,
                method: 'GET',
                timeout: 60000,
                headers: {
                    'Content-Type': 'text/html'
                },
                success: function (response) {
                    // if response text is string need to decode it
                    if (typeof response?.responseText === 'string') {
                        resolve(Ext.decode(response?.responseText));
                    } else {
                        resolve(response?.responseText);
                    }
                },
                failure: function (result) {
                    if (typeof result?.responseText === 'string' && result?.responseText && !result?.responseText.startsWith('<')) {
                        var response = Ext.decode(result?.responseText);
                        reject(response?.error);
                    }
                    else {
                        reject('Failed with status: ' + result?.status);
                    }
                }
            });
        });
    },
    fillConfig: function (e) {
        this.generalTab = new SYNOCOMMUNITY.ARCControl.Service.GeneralTab({
            appWin: this.appWin,
            owner: this,
            itemId: "GeneralTab",
        });

        const tabs = [this.generalTab];

        const settingsConfig = {
            title: "Settings",
            autoScroll: true,
            useDefaultBtn: false,
            labelWidth: 200,
            fieldWidth: 240,
            activeTab: 0,
            deferredRender: false,
            items: tabs,
            listeners: {
                activate: this.updateAllForm,
                scope: this
            },
        };

        return Ext.apply(settingsConfig, e);
    },
    loadAllForms: function (e) {
        this.items.each((t) => {
            if (Ext.isFunction(t.loadForm)) {
                if (t.itemId == "SynoInfoTab") {
                    t.loadForm(e.synoinfo);
                } else {
                    t.loadForm(e);
                }
            }
        });
    },
    updateEnv: function (e) {
    },
    updateAllForm: async function () {
        this.setStatusBusy();
        try {
            this.loadAllForms(e), this.updateEnv(e);
        } catch (e) {
            SYNO.Debug(e);
        }
        this.clearStatusBusy();
    }
}));


/***/ }),

/***/ "./src/src/tabs/setting.js":
/*!*********************************!*\
  !*** ./src/src/tabs/setting.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Ext.define("SYNOCOMMUNITY.ARCControl.Setting.Main", {
        extend: "SYNO.SDS.Utils.TabPanel",
        helper: SYNOCOMMUNITY.ARCControl.Helper,
        API: {},
        constructor: function (e) {
            (this.appWin = e.appWin),
                (this.owner = e.owner),
                this.callParent([this.fillConfig(e)]);
        },
        fillConfig: function (e) {
            this.generalTab = new SYNOCOMMUNITY.ARCControl.Setting.GeneralTab({
                appWin: this.appWin,
                owner: this,
                itemId: "GeneralTab",
            });

            this.arcConfigTab = new SYNOCOMMUNITY.ARCControl.Setting.ArcConfigTab({
                appWin: this.appWin,
                owner: this,
                itemId: "ArcConfigTab",
            });

            this.bootInfoTab = new SYNOCOMMUNITY.ARCControl.Setting.BootInfoTab({
                appWin: this.appWin,
                owner: this,
                itemId: "BootInfoTab",
            });

            const tabs = [this.generalTab, this.arcConfigTab, this.bootInfoTab];

            const settingsConfig = {
                title: "Settings",
                autoScroll: true,
                useDefaultBtn: true,
                labelWidth: 200,
                fieldWidth: 240,
                activeTab: 0,
                deferredRender: false,
                items: tabs,
                listeners: {
                    activate: this.updateAllForm,
                    scope: this
                },
            };

            return Ext.apply(settingsConfig, e);
        },
        loadAllForms: function (e) {
            this.items.each((t) => {
                if (Ext.isFunction(t.loadForm)) {
                    if (t.itemId === "SynoInfoTab") {
                        t.loadForm(e.synoinfo);
                    } else if (t.itemId === "BootInfoTab") {
                        t.loadForm(e.bootscreen);
                    } else {
                        t.loadForm(e);
                    }
                }
            });
        },
        updateEnv: function (e) {
        },
        updateAllForm: async function () {
            this.setStatusBusy();
            try {
                const e = await this.getConf();
                this.loadAllForms(e), this.updateEnv(e);
            } catch (e) {
                SYNO.Debug(e);
            }
            this.clearStatusBusy();
        },
        applyHandler: function () {
            this.confirmApply() && this.doApply().catch(() => { });
        },
        doApply: async function () {
            this.setStatusBusy();
            try {
                await this.setConf(); // Save the configuration to localStorage and upload it
                await this.updateAllForm(); // Refresh the forms with the updated configuration
                this.clearStatusBusy();
                this.setStatusOK();
            } catch (e) {
                SYNO.Debug(e);
                this.clearStatusBusy();
                this.appWin.getMsgBox().alert(this.title, this.API.getErrorString(e));
                throw e;
            }
        },
        getParams: function () {
            const generalTab = this.generalTab.getForm().getValues();
            const arcConfigTab = this.arcConfigTab.getForm().getValues();
            const bootInfoTab = this.bootInfoTab.getForm().getValues();
            const bootInfoTabFixed = {
                bootscreen: bootInfoTab
            };

            var arcConfigJson = localStorage.getItem("arcConfig");
            var arcConfig = JSON.parse(arcConfigJson);
            return Object.assign(arcConfig?.user_config, generalTab, arcConfigTab, bootInfoTabFixed);
        },
        getConf: function () {
            var arcConfigJson = localStorage.getItem("arcConfig");
            var arcConfig = JSON.parse(arcConfigJson);

            return arcConfig?.user_config;
        },
        setConf: function () {
            var user_config = this.getParams();
            var arcConfigJson = localStorage.getItem("arcConfig");
            var arcConfigOrig = JSON.parse(arcConfigJson);
            arcConfigOrig.user_config = user_config;
            localStorage.setItem("arcConfig", JSON.stringify(arcConfigOrig));

            return this.appWin.handleFileUpload(user_config);
        },
        confirmApply: function () {
            if (!this.isAnyFormDirty())
                return (
                    this.setStatusError({
                        text: this.helper.V("ui", "frm_validation_no_change"),
                        clear: !0,
                    }),
                    !1
                );
            const e = this.getAllForms().find((e) => !e.isValid());
            return (
                !e ||
                (this.setActiveTab(e.itemId),
                    this.setStatusError({
                        text: this.helper.V("ui", "frm_validation_fill_required_fields"),
                    }),
                    !1)
            );
        },
        onPageConfirmLostChangeSave: function () {
            return this.confirmApply() ? this.doApply() : Promise.reject();
        },
    }));

/***/ }),

/***/ "./src/src/utils/synoApiProvider.js":
/*!******************************************!*\
  !*** ./src/src/utils/synoApiProvider.js ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SYNOCOMMUNITY.ARCControl.SynoApiProvider = {
        sendWebAPI: null,
        _prefix: '/webman/3rdparty/arc-control/scripts/',
        init: function (sendWebAPI, isModernDSM = true) {
            this.sendWebAPI = sendWebAPI;
            this.isModernDSM = isModernDSM;
        },
        setIsModernDSM: function (isModernDSM) {
            this.isModernDSM = isModernDSM;
        },
        getSytemInfo: function () {
            const that = this;
            return new Promise((resolve, reject) => {
                const args = {
                    api: 'SYNO.DSM.Info',
                    method: 'getinfo',
                    version: 2,
                    callback: function (success, message) {
                        success ? resolve(message) : reject('Unable to get system info!');
                    }
                };
                that.sendWebAPI(args);
            });
        },
        getPackagesList: function () {
            const that = this;
            return new Promise((resolve, reject) => {
                const params = {
                    additional: ["maintainer", "dsm_app_launch_name", "url", "available_operation", "install_type"],
                    ignore_hidden: false,
                };
                const args = {
                    api: 'SYNO.Core.Package',
                    method: 'list',
                    version: 2,
                    params: params,
                    callback: function (success, message) {
                        success ? resolve(message) : reject('Unable to get packages!');
                    }
                };
                that.sendWebAPI(args);
            });
        },
        getSharesList: function () {
            const that = this;
            return new Promise((resolve, reject) => {
                let params = {
                    filetype: 'dir', // URL-encode special characters if needed
                    sort_by: 'name',
                    check_dir: true,
                    additional: ["real_path"],
                    enum_cluster: false,
                    node: 'fm_root'
                };
                let args = {
                    api: 'SYNO.FileStation.List',
                    method: 'list_share',
                    version: 2,
                    params: params,
                    callback: function (success, message) {
                        success ? resolve(message) : reject('Unable to get getSharesList!');
                    }
                };
                that.sendWebAPI(args);
            });
        },
        _handleFileUpload: function (jsonData) {
            let url = `${this._prefix}uploadConfigFile.cgi`;
            return new Promise((resolve, reject) => {
                Ext.Ajax.request({
                    url: url,
                    method: 'POST',
                    jsonData: jsonData,
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    success: function (response) {
                        resolve(Ext.decode(response.responseText));
                    },
                    failure: function (response) {
                        reject('Failed with status: ' + response.status);
                    }
                });
            });
        },
        checkARCVersion: function () {
            return this.callCustomScript('getArcReleaseInfo.cgi');
        },
        getUpdateFileInfo: function (file) {
            return new Promise((resolve, reject) => {
                Ext.Ajax.request({
                    url: `${this._prefix}readUpdateFile.cgi`,
                    method: 'GET',
                    timeout: 60000,
                    params: {
                        file: file
                    },
                    headers: {
                        'Content-Type': 'text/html'
                    },
                    success: function (response) {
                        // if response text is string need to decode it
                        if (typeof response?.responseText === 'string' && response?.responseText != "") {
                            resolve(Ext.decode(response?.responseText));
                        } else {
                            resolve(response?.responseText);
                        }
                    },
                    failure: function (result) {
                        if (typeof result?.responseText === 'string' && result?.responseText) {
                            var response = Ext.decode(result?.responseText);
                            reject(response?.error);
                        }
                        else {
                            reject('Failed with status: ' + result?.status);
                        }
                    },
                });
            });
        },
        callCustomScript: function (scriptName) {
            return new Promise((resolve, reject) => {
                Ext.Ajax.request({
                    url: `${this._prefix}${scriptName}`,
                    method: 'GET',
                    timeout: 60000,
                    headers: {
                        'Content-Type': 'text/html',
                    },
                    success: function (response) {
                        // Handle plain text or JSON response
                        if (typeof response?.responseText === 'string' && response?.responseText.trim() !== "") {
                            try {
                                // Attempt to decode as JSON
                                resolve(Ext.decode(response?.responseText));
                            } catch (e) {
                                // If not JSON, resolve as plain text
                                resolve(response?.responseText);
                            }
                        } else {
                            resolve(response?.responseText);
                        }
                    },
                    failure: function (result) {
                        if (typeof result?.responseText === 'string' && result?.responseText.trim() !== "") {
                            try {
                                // Attempt to decode error response as JSON
                                var response = Ext.decode(result?.responseText);
                                reject(response?.error || 'Unknown error');
                            } catch (e) {
                                // If not JSON, reject with plain text error
                                reject(result?.responseText);
                            }
                        } else {
                            reject('Failed with status: ' + result?.status);
                        }
                    },
                });
            });
        },
        loaderBuild: function () {
            return this.callCustomScript('loaderBuild.cgi');
        },
        loaderUpdate: function () {
            return this.callCustomScript('loaderUpdate.cgi');
        },
        loaderConfig: function () {
            return this.callCustomScript('loaderConfig.cgi');
        }
    });

/***/ }),

/***/ "./src/src/utils/terminalHelper.js":
/*!*****************************************!*\
  !*** ./src/src/utils/terminalHelper.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
// Namespace definition
Ext.ns('SYNOCOMMUNITY.ARCControl');

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SYNOCOMMUNITY.ARCControl.TerminalHelper = {
    T: function (a, b) {
        return _T(a, b);
    },
    V: function (category, element) {
        return _TT("SYNOCOMMUNITY.ARCControl.AppInstance", category, element);
    },
    maskLoading: function (component) {
        component.getEl().mask(this.T("common", "loading"), "x-mask-loading");
    },
    unmask: function (component) {
        component?.getEl()?.unmask();
    },
    mask: function (component, message) {
        component?.getEl()?.mask(message, "x-mask-loading");
    },
    showMsg: function (msg) {
        Ext.Msg.alert('Message', msg);
    },

    /**
     * Starts the terminal by executing the ttyd command via the .cgi script.
     * @param {Object} options - Options for starting the terminal (e.g., title, shell).
     * @returns {Promise} - Resolves when the terminal starts successfully.
     */
    startTerminal: function (options = {}) {
        const title = encodeURIComponent(options.title || "Terminal");
        const shell = encodeURIComponent(options.shell || "login");
    
        return new Promise((resolve, reject) => {
            Ext.Ajax.request({
                url: `/webman/3rdparty/arc-control/scripts/terminal.cgi?action=start&shell=${shell}`,
                method: 'GET',
                success: function (response) {
                    const result = Ext.decode(response.responseText);
                    if (result.success) {
                        setTimeout(() => {
                            SYNOCOMMUNITY.ARCControl.TerminalHelper.showTerminalPopup({
                                title: options.title || 'Terminal'
                            });
                        }, 2000);
                        resolve(result);
                    } else if (result.error === "Terminal is already running") {
                        SYNOCOMMUNITY.ARCControl.TerminalHelper.showTerminalPopup({
                            title: options.title || 'Terminal'
                        });
                        resolve(result);
                    } else {
                        reject(result.error || 'Failed to start terminal');
                    }
                },
                failure: function (response) {
                    reject(`HTTP Error: ${response.status}`);
                }
            });
        });
    },

    /**
     * Stops the terminal by killing the ttyd process via the .cgi script.
     * @returns {Promise} - Resolves when the terminal stops successfully.
     */
    stopTerminal: function () {
        return new Promise((resolve, reject) => {
            Ext.Ajax.request({
                url: '/webman/3rdparty/arc-control/scripts/terminal.cgi?action=stop',
                method: 'GET',
                success: function (response) {
                    const result = Ext.decode(response.responseText);
                    if (result.success) {
                        resolve(result);
                    } else {
                        reject(result.error || 'Failed to stop terminal');
                    }
                },
                failure: function (response) {
                    reject(`HTTP Error: ${response.status}`);
                }
            });
        });
    },

    /**
     * Opens the terminal in a popup window using a similar approach to showSmartPopup.
     * @param {Object} options - Options for the terminal (e.g., title, shell).
     */
    showTerminalPopup: function (options = {}) {
        const title = options.title || 'Terminal';
        const url = `/terminal`; // Default ttyd URL
        const message = 'With great power comes great responsibility. Use the terminal wisely!';

        // Show the terminal in a new window with a message
        this.showPrompt(
            title,
            message,
            `<iframe src="${url}" style="width: 100%; height: 100%; border: none;"></iframe>`,
            null
        );
    },

    /**
     * Generic method to show a popup window with custom content.
     * @param {String} title - The title of the popup window.
     * @param {String} message - The message to display (optional).
     * @param {String} text - The content to display (e.g., iframe or HTML).
     * @param {Function} yesCallback - Callback for the "OK" button (optional).
     */
    showPrompt: function (title, message, text, yesCallback) {
        const window = new SYNOCOMMUNITY.ARCControl.Overview.UpdateAvailableDialog({
            owner: this.appWin || null,
            title: title,
            message: message,
            msg: text,
            msgItemCount: 3,
            confirmCheck: true,
            btnOKHandler: yesCallback
        });
        window.open();
    },

    /**
     * Closes the terminal popup window if it exists.
     */
    closeTerminalPopup: function () {
        if (this._terminalPopup) {
            this._terminalPopup.close();
            this._terminalPopup = null;
        }
    }
});

/***/ }),

/***/ "./src/src/utils/updateWizardHelper.js":
/*!*********************************************!*\
  !*** ./src/src/utils/updateWizardHelper.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return __WEBPACK_DEFAULT_EXPORT__; }
/* harmony export */ });
// Namespace definition
Ext.ns('SYNOCOMMUNITY.ARCControl');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SYNOCOMMUNITY.ARCControl.Helper = {
        T: function (a, b) {
            return _T(a, b);
        },
        V: function (category, element) {
            return _TT("SYNOCOMMUNITY.ARCControl.AppInstance", category, element)
        },
        formatString: function (str, ...args) {
            return str.replace(/{(\d+)}/g, function (match, number) {
                return typeof args[number] !== 'undefined' ? args[number] : match;
            });
        },
        maskLoading: function (a) {
            a.getEl().mask(this.T("common", "loading"), "x-mask-loading");
        },
        unmask: function (a) {
            a?.getEl()?.unmask();
        },
        mask: function (b, a) {
            b?.getEl()?.mask(a, "x-mask-loading");
        },
        diskSizeRenderer: function (a) {
            return Ext.util.Format.fileSize(a);
        },
        tryUnmaskAndReload: function (a, b, c) {
            this.unmask(a);
            // b.reload();
            // c();
        },
        getError: function (a) {
            return _T("error", a);
        },
    });

/***/ })

/******/ });
/************************************************************************/
/******/ // The module cache
/******/ var __webpack_module_cache__ = {};
/******/ 
/******/ // The require function
/******/ function __webpack_require__(moduleId) {
/******/ 	// Check if module is in cache
/******/ 	var cachedModule = __webpack_module_cache__[moduleId];
/******/ 	if (cachedModule !== undefined) {
/******/ 		return cachedModule.exports;
/******/ 	}
/******/ 	// Create a new module (and put it into the cache)
/******/ 	var module = __webpack_module_cache__[moduleId] = {
/******/ 		// no module.id needed
/******/ 		// no module.loaded needed
/******/ 		exports: {}
/******/ 	};
/******/ 
/******/ 	// Execute the module function
/******/ 	__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 
/******/ 	// Return the exports of the module
/******/ 	return module.exports;
/******/ }
/******/ 
/************************************************************************/
/******/ /* webpack/runtime/define property getters */
/******/ !function() {
/******/ 	// define getter functions for harmony exports
/******/ 	__webpack_require__.d = function(exports, definition) {
/******/ 		for(var key in definition) {
/******/ 			if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 				Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 			}
/******/ 		}
/******/ 	};
/******/ }();
/******/ 
/******/ /* webpack/runtime/hasOwnProperty shorthand */
/******/ !function() {
/******/ 	__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ }();
/******/ 
/******/ /* webpack/runtime/make namespace object */
/******/ !function() {
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/ }();
/******/ 
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
!function() {
/*!**************************!*\
  !*** ./src/src/index.js ***!
  \**************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _appWindow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./appWindow */ "./src/src/appWindow.js");
/* harmony import */ var _tabs_main__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tabs/main */ "./src/src/tabs/main.js");
/* harmony import */ var _panels_healthPanel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./panels/healthPanel */ "./src/src/panels/healthPanel.js");
/* harmony import */ var _components_statusBoxTmpl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/statusBoxTmpl */ "./src/src/components/statusBoxTmpl.js");
/* harmony import */ var _components_statusBox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/statusBox */ "./src/src/components/statusBox.js");
/* harmony import */ var _panels_statusBoxsPanel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./panels/statusBoxsPanel */ "./src/src/panels/statusBoxsPanel.js");
/* harmony import */ var _tabs_addons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./tabs/addons */ "./src/src/tabs/addons.js");
/* harmony import */ var _components_advancedSearchField__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/advancedSearchField */ "./src/src/components/advancedSearchField.js");
/* harmony import */ var _tabs_setting__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./tabs/setting */ "./src/src/tabs/setting.js");
/* harmony import */ var _panels_settings_generalTab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./panels/settings/generalTab */ "./src/src/panels/settings/generalTab.js");
/* harmony import */ var _panels_settings_arcConfigTab__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./panels/settings/arcConfigTab */ "./src/src/panels/settings/arcConfigTab.js");
/* harmony import */ var _panels_settings_bootInfoTab__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./panels/settings/bootInfoTab */ "./src/src/panels/settings/bootInfoTab.js");
/* harmony import */ var _tabs_debug__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./tabs/debug */ "./src/src/tabs/debug.js");
/* harmony import */ var _panels_debug_generalTab__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./panels/debug/generalTab */ "./src/src/panels/debug/generalTab.js");
/* harmony import */ var _tabs_disks__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./tabs/disks */ "./src/src/tabs/disks.js");
/* harmony import */ var _panels_disks_generalTab__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./panels/disks/generalTab */ "./src/src/panels/disks/generalTab.js");
/* harmony import */ var _tabs_service__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./tabs/service */ "./src/src/tabs/service.js");
/* harmony import */ var _panels_service_generalTab__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./panels/service/generalTab */ "./src/src/panels/service/generalTab.js");
/* harmony import */ var _tabs_loader__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./tabs/loader */ "./src/src/tabs/loader.js");
/* harmony import */ var _panels_loader_generalTab__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./panels/loader/generalTab */ "./src/src/panels/loader/generalTab.js");


//tab main






//tab addons



//tab settings(configuration)





//tab debug



//tab disks



//tab service



//tab loader



// Namespace definition
Ext.ns('SYNOCOMMUNITY.ARCControl');
// Application definition
Ext.define('SYNOCOMMUNITY.ARCControl.AppInstance', {
    extend: 'SYNO.SDS.AppInstance',
    appWindowName: 'SYNOCOMMUNITY.ARCControl.AppWindow',
    constructor: function () {
        this.callParent(arguments)
    }
});

SYNOCOMMUNITY.ARCControl.SetEmptyIcon = (e, t) => {
    let i = e.el.child(".contentwrapper");
    if (i) {
        for (; i.child(".contentwrapper");)
            i = i.child(".contentwrapper");
        t && !i.hasClass("san-is-empty") ? i.addClass("san-is-empty") : !t && i.hasClass("san-is-empty") && i.removeClass("san-is-empty")
    }
};
}();

//# sourceMappingURL=arc-control.js.map