#!/usr/bin/env sh

# Content-Type header for JSON output
echo "Content-type: application/json"
echo ""

# Parse QUERY_STRING for GET parameters
declare -A params
IFS='&' read -r -a query <<< "$QUERY_STRING"
for param in "${query[@]}"; do
  key="${param%%=*}"
  value="${param#*=}"
  params["$key"]="$value"
done

# Extract parameters
name="${params[name]}"
option="${params[option]}"
hddb="${params[hdd]}" # For HDD_BAY
ssdb="${params[ssd]}" # For SSD_BAY

# Validate parameters
if [ -z "$name" ] || [ -z "$option" ] && [ -z "$hddb" ] && [ -z "$ssdb" ]; then
  echo "{}" | jq --arg message "Invalid parameters: name and option are required" '.success = false | .message = $message'
  exit 1
fi

# Function to restart the storage panel
reset_storage_panel() {
  /usr/bin/arcsu nginx -s reload 2>/dev/null
}

# Handle storagepanel case with HDD_BAY and SSD_BAY options
if [ "$name" = "storagepanel" ] && [ -n "$hddb" ] && [ -n "$ssdb" ]; then
  if /usr/bin/arcsu storagepanel.sh "$hddb" "$ssdb" >/dev/null 2>&1; then
    /usr/bin/arcsu echo "$hddb-$ssdb" > /usr/arc/storagepanel.conf
    reset_storage_panel
    echo "{}" | jq --arg message "Storage panel set successfully with HDD_BAY: $hddb and SSD_BAY: $ssdb" '.success = true | .message = $message'
  else
    echo "{}" | jq --arg message "Failed to set storage panel with HDD_BAY: $hddb and SSD_BAY: $ssdb" '.success = false | .message = $message'
  fi
elif [ "$name" = "storagepanel" ] && [ "$option" = "read" ]; then
  if [ -f /usr/arc/storagepanel.conf ]; then
    ARCPANEL=$(/usr/bin/arcsu cat /usr/arc/storagepanel.conf 2>/dev/null)
    HDD_BAY="${ARCPANEL%-*}"
    SSD_BAY="${ARCPANEL#*-}"
    echo "{\"success\": true, \"hddBay\": \"$HDD_BAY\", \"ssdBay\": \"$SSD_BAY\"}"
  else
    echo "{\"success\": true, \"hddBay\": \"RACK_0_Bay\", \"ssdBay\": \"1X1\"}"
  fi
elif [ "$name" = "storagepanel" ] && [ "$option" = "auto" ]; then
  if /usr/bin/arcsu storagepanel.sh >/dev/null 2>&1; then
    /usr/bin/arcsu rm -f /usr/arc/storagepanel.conf 2>/dev/null
    restart_storage_panel
    echo "{}" | jq --arg message "Storage panel set to auto" '.success = true | .message = $message'
  else
    echo "{}" | jq --arg message "Failed to set storage panel to auto" '.success = false | .message = $message'
  fi
elif [ "$name" = "storagepanel" ] && [ "$option" = "reset" ]; then
  if /usr/bin/arcsu storagepanel.sh -r >/dev/null 2>&1; then
    /usr/bin/arcsu rm -f /usr/arc/storagepanel.conf
    restart_storage_panel
    echo "{}" | jq --arg message "Storage panel reset successfully" '.success = true | .message = $message'
  else
    echo "{}" | jq --arg message "Failed to reset storage panel" '.success = false | .message = $message'
  fi
elif [ "$name" = "hdddb" ] && [ "$option" = "patch" ]; then
  if /usr/bin/arcsu hdddb.sh -nrwpeSI >/dev/null 2>&1; then
    echo "{}" | jq --arg message "Drive Database patch applied successfully" '.success = true | .message = $message'
  else
    echo "{}" | jq --arg message "Failed to apply Drive Database patch" '.success = false | .message = $message'
  fi
elif [ "$name" = "apppatch" ] && [ "$option" = "localdisplay" ]; then
  if /usr/bin/arcsu apppatch.sh surveillance >/dev/null 2>&1; then
    echo "{}" | jq --arg message "Successfully applied apppatch localdisplay" '.success = true | .message = $message'
  else
    echo "{}" | jq --arg message "Failed to apply apppatch localdisplay" '.success = false | .message = $message'
  fi
elif [ "$name" = "apppatch" ] && [ "$option" = "photosface" ]; then
  if /usr/bin/arcsu apppatch.sh photosface >/dev/null 2>&1; then
    echo "{}" | jq --arg message "Successfully applied apppatch photosface" '.success = true | .message = $message'
  else
    echo "{}" | jq --arg message "Failed to apply apppatch photosface" '.success = false | .message = $message'
  fi
elif [ "$name" = "smartctl" ] && [ "$option" = "on" ]; then
  if /usr/bin/arcsu smartctl.sh >/dev/null 2>&1; then
    echo "{}" | jq --arg message "Successfully applied smartctl" '.success = true | .message = $message'
  else
    echo "{}" | jq --arg message "Failed to apply smartctl" '.success = false | .message = $message'
  fi
elif [ "$name" = "ledcontrol" ]; then
  if [ "$option" = "on" ] || [ "$option" = "off" ]; then
    if /usr/bin/arcsu ledcontrol.sh "$option" >/dev/null 2>&1; then
      echo "{}" | jq --arg message "Successfully set ledcontrol to $option" '.success = true | .message = $message'
    else
      echo "{}" | jq --arg message "Failed to set ledcontrol to $option" '.success = false | .message = $message'
    fi
  elif [ "$option" = "auto" ]; then
    if /usr/bin/arcsu ledcontrol.sh >/dev/null 2>&1; then
      echo "{}" | jq --arg message "Successfully set ledcontrol to auto" '.success = true | .message = $message'
    else
      echo "{}" | jq --arg message "Failed to set ledcontrol to auto" '.success = false | .message = $message'
    fi
  else
    echo "{}" | jq --arg message "Invalid option for ledcontrol" '.success = false | .message = $message'
  fi
elif [ "$name" = "fancontrol" ]; then
  if [ "$option" = "on" ]; then
    if /usr/bin/arcsu arc-sensors.sh "$option" >/dev/null 2>&1; then
      echo "{}" | jq --arg message "Successfully set fancontrol to $option" '.success = true | .message = $message'
    else
      echo "{}" | jq --arg message "Failed to set fancontrol to $option" '.success = false | .message = $message'
    fi
  elif [ "$option" = "off" ]; then
      if /usr/bin/arcsu /usr/bin/pkill -f "/usr/bin/arc-sensors.sh" 2>/dev/null && \
         /usr/bin/arcsu /usr/bin/pkill -f "/usr/sbin/fancontrol" 2>/dev/null && \
         /usr/bin/arcsu rm -f "/run/fancontrol.pid"; then
      echo "{}" | jq --arg message "Successfully set fancontrol to $option" '.success = true | .message = $message'
    else
      echo "{}" | jq --arg message "Failed to set fancontrol to $option" '.success = false | .message = $message'
    fi
  elif [ "$option" = "training" ]; then
    if /usr/bin/arcsu arc-pwm.sh >/dev/null 2>&1; then
      echo "{}" | jq --arg message "Successfully set fancontrol to training" '.success = true | .message = $message'
    else
      echo "{}" | jq --arg message "Failed to set fancontrol to training" '.success = false | .message = $message'
    fi
  else
    echo "{}" | jq --arg message "Invalid option for fancontrol" '.success = false | .message = $message'
  fi
else
  echo "{}" | jq --arg message "Invalid patch name or option" '.success = false | .message = $message'
fi