#!/usr/bin/env python3

import os
import json
import sys
import cgi
import subprocess
from pathlib import Path
path_root = Path(__file__).parents[1]
sys.path.append(str(path_root) + '/libs')

import libs.yaml as yaml
print("Content-type: application/json\n")

arguments = cgi.FieldStorage()
category = arguments.getvalue('category')

# Function to read only the "addons" section from the user configuration
def read_user_config():
    userConfigPath = "/mnt/p1/user-config.yml"
    try:
        with open(userConfigPath, 'r') as file:
            config = yaml.safe_load(file) or {}
            return config.get('addons', {})  # Return only the "addons" section
    except IOError as e:
        print(f"Error reading user-config.yml: {e}")
        return {}
    except Exception as e:
        print(f"Unexpected error: {e}")
        return {}

def read_manifests_in_subdirs(parent_directory, addons, category=None):
    manifests = []
    try:
        subdirs = next(os.walk(parent_directory))[1]
    except Exception as e:
        print(f"Error walking the directory {parent_directory}: {e}")
        return manifests

    for subdir in subdirs:
        try:
            manifest_path = os.path.join(parent_directory, subdir, 'manifest.yml')
            if os.path.exists(manifest_path):
                with open(manifest_path, 'r') as file:
                    try:
                        manifest = yaml.safe_load(file)
                        # Extract only the required fields
                        filtered_manifest = {
                            "name": manifest.get("name"),
                            "version": manifest.get("version"),
                            "description": manifest.get("description"),
                            "installed": subdir in addons
                        }
                        # Skip if 'system' key exists and is True
                        if manifest.get('system') is True:
                            continue
                        # Filter by category if specified
                        if category == "system":
                            if manifest.get('system') is True:
                                manifests.append(filtered_manifest)
                        else:
                            manifests.append(filtered_manifest)
                    except yaml.YAMLError as exc:
                        print(f"Error reading {manifest_path}: {exc}")
        except Exception as e:
            print(f"Error processing subdir {subdir}: {e}")

    return manifests

# Authenticate the user
f = os.popen('/usr/syno/synoman/webman/modules/authenticate.cgi', 'r')
user = f.read().strip()
ADDONS_PATH = '/mnt/p3/addons/'
response = {}

def callMountLoaderScript(action):
    subprocess.run(['arcsu', 'arc-loaderdisk.sh', action],
                   stdout=subprocess.DEVNULL,
                   stderr=subprocess.DEVNULL)

def mountLoader():
    callMountLoaderScript('mountLoaderDisk')

def unmountLoader():
    callMountLoaderScript('unmountLoaderDisk')

try:
    mountLoader()
    userConfig = read_user_config()
    addons = read_manifests_in_subdirs(ADDONS_PATH, userConfig, category)
    response['result'] = addons if isinstance(addons, list) else []
    response['success'] = True
    response['total'] = len(addons)
except Exception as e:
    response['error'] = f"An exception occurred: {e}"
    response['result'] = []
    response['success'] = False
    response['total'] = 0
finally:
    unmountLoader()

# Print the JSON response
print(json.dumps(response))