#!/usr/bin/env sh

# Specifies the content type to be JSON
echo "Content-type: application/json"
echo ""
# Initialize JSON structure with the result object
echo "{"
echo "  \"result\": {"
echo "    \"bootParameters\": {"

count=0
cmdline=$(cat /proc/cmdline)
# Splitting cmdline into key-value pairs
IFS=' ' read -ra ADDR <<< "$cmdline"
len=${#ADDR[@]}
for (( i=0; i<$len; i++ )); do
  key=$(echo ${ADDR[$i]} | cut -f1 -d=)
  value=$(echo ${ADDR[$i]} | cut -f2 -d=)
  if [ $i -lt $((len - 1)) ]; then
    echo "      \"$key\": \"$value\","
  else
    echo "      \"$key\": \"$value\""
  fi
done
echo "    },"

# Extract loaded Modules
echo "    \"modules\": ["
declare -a modules_list
for i in $(lsmod | awk '{print $1}'); do
  [ -n "${modules_list}" ] && modules_list+=" ${i}"
  [ -z "${modules_list}" ] && modules_list+="${i}"
done
echo "      {"
echo "        \"list\": \"list\","
echo "        \"modules_list\": \"${modules_list}\""
echo "      }"
echo "    ],"


echo "    \"syno_mac_addresses\": ["
file_path="/proc/sys/kernel/syno_mac_addresses"
declare -a mac_addresses
while IFS= read -r line; do
  # Append each line (MAC address) to the array
  mac_addresses+=("$line")
done < "$file_path"
# Get the length of the array for reference in the loop
len=${#mac_addresses[@]}
for (( i=0; i<$len; i++ )); do
  # Check if it's the last element to avoid adding a comma
  if [ $i -eq $((len-1)) ]; then
    echo "    \"${mac_addresses[$i]}\""
  else
    echo "    \"${mac_addresses[$i]}\","
  fi
done
echo "    ]"
echo "  }"
echo "}"