#!/usr/bin/env python3

import os
import json
import sys
import subprocess

from pathlib import Path
path_root = Path(__file__).parents[1]
sys.path.append(str(path_root)+'/libs')

import libs.yaml as yaml
print("Content-type: application/json\n")

#Function to read user configuration from a YAML file
def read_user_config():
    try:
        with open('/mnt/p1/user-config.yml', 'r') as file:
            return yaml.safe_load(file)  # Load and parse the YAML file
    except IOError as e:
        return f"Error reading user-config.yml: {e}"
    except e:
        return "{}"
    
def read_arccontrol_config(file_path):
    try:
        config = {}
        with open(file_path, 'r') as file:
            for line in file:
                line = line.strip()
                if line and not line.startswith('#'):
                    key, value = line.split('=')
                    config[key.strip()] = value.strip().replace('"', '')
        return config
    except IOError as e:
        return f"Error reading user-config.yml: {e}"
    except e:
        return "{}"

def read_arccontrol_privilege(file_path):
    try:
        with open(file_path, 'r') as file:
            # Parse JSON data directly into a Python dictionary
            config = json.load(file)
        return config
    except IOError as e:
        # Handle I/O errors (e.g., file not found)
        return f"Error reading {file_path}: {e}"
    except json.JSONDecodeError as e:
        # Handle errors caused by incorrect JSON formatting
        return f"Error decoding JSON from {file_path}: {e}"
    except Exception as e:
        # Generic exception handler for any other unforeseen errors
        return "{}"

def callMountLoaderScript(action):
    subprocess.run(['arcsu','arc-loaderdisk.sh', action],
                   stdout=subprocess.DEVNULL,
                   stderr=subprocess.DEVNULL)

def mountLoader():
    callMountLoaderScript('mountLoaderDisk')

def unmountLoader():
    callMountLoaderScript('unmountLoaderDisk')
# Authenticate the user
f = os.popen('/usr/syno/synoman/webman/modules/authenticate.cgi', 'r')
user = f.read().strip()

response = {}

if len(user) > 0:
    mountLoader()
    response["status"] = "authenticated"
    response["user"] = user

    # Read and add arc_version to the response
    arcData = read_arccontrol_config('/usr/arc/VERSION')
    response["arc_version"] = arcData.get('LOADERVERSION')
    response["arc_branch"] = arcData.get('LOADERBRANCH')
    # response["arc_data"] = arcData
    response["user_config"] = read_user_config()
    response["arc_control_config"] = read_arccontrol_config('/var/packages/arc-control/target/app/config.txt')
    response["arc_control_privilege"] = read_arccontrol_privilege('/var/packages/arc-control/conf/privilege')
    # response["arc_control_resource"] = read_arccontrol_privilege('/var/packages/arc-control/conf/resource')
    if not os.path.exists('/tmp/arc_update_progress'):
        response["arc_health"] = "healthy"
    else:
        response["arc_health"] = "awaiting_reboot"
    unmountLoader()
else:
    response["status"] = "not authenticated"

# Print the JSON response
print(json.dumps(response))
