#!/usr/bin/env sh

# Output the HTTP header
echo "Content-type: text/plain"
echo ""

# Check if the QUERY_STRING contains the action and disk parameters
if echo "$QUERY_STRING" | grep -q "action=smartctl"; then
    # Extract the disk parameter from the QUERY_STRING
    disk=$(echo "$QUERY_STRING" | sed -n 's/.*disk=\([^&]*\).*/\1/p')

    # Validate the disk parameter
    if [ -n "$disk" ]; then
        # Check if the disk is an NVMe device
        if echo "$disk" | grep -q "^nvme"; then
            # Append "n1" to the NVMe disk name
            nvme_disk="${disk}n1"

            # Run the synodisk and nvme smart-log commands
            /usr/bin/arcsu synodisk --info /dev/"$nvme_disk" 2>/dev/null
            echo ""
            /usr/bin/arcsu nvme smart-log /dev/"$nvme_disk" 2>/dev/null
        else
            # Run the smartctl command for non-NVMe disks
            /usr/bin/arcsu synodisk --info /dev/"$disk" 2>/dev/null
            echo ""
            /usr/bin/arcsu smartctl -H /dev/"$disk" 2>/dev/null | sed '1,3d'
            echo ""
            /usr/bin/arcsu smartctl -a /dev/"$disk" 2>/dev/null | sed '1,3d'
        fi
    else
        # Return an error if the disk parameter is missing
        echo "Error: Disk parameter is missing"
    fi
else
    # Return an error if the action parameter is not smartctl
    echo "Error: Invalid action"
fi