#!/usr/bin/env sh
# Assuming jq is installed on your system for parsing and generating JSON
# Content-Type header for JSON output

echo "Content-type: application/json"
echo ""

echo "{"
echo "  \"result\": {"
echo "    \"cpuInfo\": ["
cpumodel="$(grep -m1 'model name' /proc/cpuinfo 2>/dev/null | cut -d: -f2 | sed 's/CPU @.*//' | xargs)"
cpucores="$(grep -m1 'cpu cores' /proc/cpuinfo 2>/dev/null | cut -d: -f2 | xargs)"
mev="$(grep -o 'mev=[^ ]*' /proc/cmdline 2>/dev/null | cut -d'=' -f2 | xargs)"
if [ -n "${mev}" ] && [ "${mev}" = "physical" ]; then
    cpugovernor="$(grep -o 'governor=[^ ]*' /proc/cmdline 2>/dev/null | cut -d'=' -f2 | xargs)"
    [ -z "${cpugovernor}" ] && cpugovernor="performance (scaling not supported)"
else
    cpugovernor="performance (scaling not supported)"
fi
local b v
if [ -r /sys/class/dmi/id/product_name ]; then
    b="$(cat /sys/class/dmi/id/product_name 2>/dev/null || true)"
    b="$(echo "${b}" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')"
fi
if [ -z "${b}" ] || printf '%s\n' "${b}" | grep -Eiq "O\.E\.M\.|System|Synoden|To Be Filled By O\.E\.M\.|default"; then
    if [ -r /sys/class/dmi/id/board_name ]; then
      b="$(cat /sys/class/dmi/id/board_name 2>/dev/null || true)"
      b="$(echo "${b}" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')"
    fi
fi
if [ -r /sys/class/dmi/id/sys_vendor ]; then
    v="$(cat /sys/class/dmi/id/sys_vendor 2>/dev/null || true)"
    v="$(echo "${v}" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')"
fi
if [ -z "${v}" ] || printf '%s\n' "${v}" | grep -Eiq "O\.E\.M\.|System|Synoden|To Be Filled By O\.E\.M\.|default"; then
    if [ -r /sys/class/dmi/id/board_vendor ]; then
      v="$(cat /sys/class/dmi/id/board_vendor 2>/dev/null || true)"
      v="$(echo "${v}" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')"
    fi
fi
if [ -n "${v}" ] && [ -n "${b}" ]; then
    main="${v} ${b}"
elif [ -n "${v}" ]; then
    main="${v}"
elif [ -n "${b}" ]; then
    main="${b}"
else
    main="not available"
fi
memory="$(/usr/bin/arcsu dmidecode -t 17 | grep "Size.*B" | awk '{if ($3=="kB") {s+=$22} else if ($3=="MB") {s+=$2*1024} else if ($3=="GB") {s+=$2*1024*1024} else if ($3=="TB") {s+=$2*1024*1024*1024}} END {print s}')"
if [ -z "${memory}" ]; then
    memory="Unknown Memory"
else
    memory="$(echo "${memory}" | awk '{printf "%.2f", $1/1024/1024}' | sed -E 's/\.?0+$//') GB"
fi
echo "      {"
echo "        \"cpu\": \"Hardware\","
echo "        \"model\": \"${cpumodel}\","
echo "        \"cores\": \"${cpucores}\","
echo "        \"governor\": \"${cpugovernor}\","
echo "        \"board\": \"${main}\","
echo "        \"memory\": \"${memory}\""
echo "      }"
echo "    ],"
echo "    \"cpuSpeed\": ["
count=0
cpuspeeds=$(grep 'MHz' /proc/cpuinfo 2>/dev/null | cut -d: -f2 | cut -d. -f1)
while read -r core; do
    if [ ${count} -gt 0 ]; then
        echo "      },"
    fi
    ((count++))
    cpucore="Thread${count}"
    corespeed="${core}"
    echo "      {"
    echo "        \"cpu\": \"${cpucore}\","
    echo "        \"speed\": \"${corespeed}\""
done <<< "${cpuspeeds}"
if [ ${count} -gt 0 ]; then
    echo "      }"
fi
echo "    ],"
echo "    \"sysTemp\": ["
count=0
hwmonlist=$(ls -d /sys/class/hwmon/hwmon* 2>/dev/null | sort)
for hwmon in $hwmonlist; do
    chip=$(cat "$hwmon/name" 2>/dev/null)
    for temp in $(ls "$hwmon"/temp*_input 2>/dev/null | sort); do
        [ -f "$temp" ] || continue
        label=$(cat "${temp%_*}_label" 2>/dev/null)
        value=$(cat "$temp" 2>/dev/null)
        [ -z "$value" ] && continue
        celsius=$((value/1000))
        if [ "$celsius" -ne 0 ] && [ "$celsius" -le 90 ] && [ "$celsius" -ge 20 ]; then
            if [ $count -gt 0 ]; then
                echo "      },"
            fi
            count=$((count+1))
            raw_label="${label:-$(basename $temp)}"
            slabel="$(echo "${raw_label}" | sed -E 's/[Tt]emperature//g; s/[:\-]//g; s/^[[:space:]]+//; s/[[:space:]]+$//')"
            echo "      {"
            echo "        \"slabel\": \"${slabel}\","
            echo "        \"stemp\": \"${celsius}\""
        fi
    done
done
if [ $count -gt 0 ]; then
    echo "      }"
fi
echo "    ],"
echo "    \"iGPUInfo\": ["
count=0
CARDN="$(ls -d /sys/class/drm/card* 2>/dev/null | head -1)"
if [ -d "${CARDN}" ]; then
    PCIDN="$(awk -F= '/DEVNAME/ {print $2}' "${CARDN}/device/uevent" 2>/dev/null)"
    LNAME="$(/usr/bin/arcsu lspci -Q -s ${PCIDN:-"99:99.9"} 2>/dev/null | sed "s/.*: //" | xargs)"
    CLOCK="$(cat "${CARDN}/gt_max_freq_mhz" 2>/dev/null | xargs)"
    [ -n "${CLOCK}" ] && CLOCK="${CLOCK} MHz"
    RGPU=$(ls /dev/dri 2>/dev/null | grep 'render' | cut -d 'r' -f3)
    [ -z "$RGPU" ] && RGPU="Not supported"

    if [ -n "${LNAME}" ] && [ -n "${CLOCK}" ]; then
        echo "      {"
        echo "        \"iGPU\": \"GPU${count}\","
        echo "        \"iGPUN\": \"${LNAME}\","
        echo "        \"iGPUC\": \"${CLOCK}\","
        echo "        \"iGPURD\": \"$RGPU\""
        echo "      }"
        ((count++))
    fi
fi
echo "    ]"
echo "  }"
echo "}"