#!/usr/bin/env sh
echo "Content-type: application/json"
echo ""
echo "{"
echo "  \"result\": {"
echo "    \"cpuInfo\": ["
cpumodel="$(grep -m1 'model name' /proc/cpuinfo 2>/dev/null | cut -d: -f2 | sed 's/CPU @.*//' | xargs)"
cpucores="$(grep -m1 'cpu cores' /proc/cpuinfo 2>/dev/null | cut -d: -f2 | xargs)"
mev="$(grep -o 'mev=[^ ]*' /proc/cmdline 2>/dev/null | cut -d'=' -f2 | xargs)"
if [ -n "${mev}" ] && [ "${mev}" = "physical" ]; then
    cpugovernor="$(grep -o 'governor=[^ ]*' /proc/cmdline 2>/dev/null | cut -d'=' -f2 | xargs)"
    [ -z "${cpugovernor}" ] && cpugovernor="performance (scaling not supported)"
else
    cpugovernor="performance (scaling not supported)"
fi
if [ -r /sys/class/dmi/id/product_name ]; then
    b="$(cat /sys/class/dmi/id/product_name 2>/dev/null || true)"
    b="$(echo "${b}" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')"
fi
if [ -z "${b}" ] || printf '%s\n' "${b}" | grep -Eiq "O\.E\.M\.|System|Synoden|To Be Filled By O\.E\.M\.|default"; then
    if [ -r /sys/class/dmi/id/board_name ]; then
      b="$(cat /sys/class/dmi/id/board_name 2>/dev/null || true)"
      b="$(echo "${b}" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')"
    fi
fi
if [ -r /sys/class/dmi/id/sys_vendor ]; then
    v="$(cat /sys/class/dmi/id/sys_vendor 2>/dev/null || true)"
    v="$(echo "${v}" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')"
fi
if [ -z "${v}" ] || printf '%s\n' "${v}" | grep -Eiq "O\.E\.M\.|System|Synoden|To Be Filled By O\.E\.M\.|default"; then
    if [ -r /sys/class/dmi/id/board_vendor ]; then
      v="$(cat /sys/class/dmi/id/board_vendor 2>/dev/null || true)"
      v="$(echo "${v}" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')"
    fi
fi
if [ -n "${v}" ] && [ -n "${b}" ]; then
    main="${v} ${b}"
elif [ -n "${v}" ]; then
    main="${v}"
elif [ -n "${b}" ]; then
    main="${b}"
else
    main="not available"
fi
memory="$(/usr/bin/arcsu dmidecode -t 17 | grep "Size.*B" | awk '{if ($3=="kB") {s+=$22} else if ($3=="MB") {s+=$2*1024} else if ($3=="GB") {s+=$2*1024*1024} else if ($3=="TB") {s+=$2*1024*1024*1024}} END {print s}')"
if [ -z "${memory}" ]; then
    memory="Unknown Memory"
else
    memory="$(echo "${memory}" | awk '{printf "%.2f", $1/1024/1024}' | sed -E 's/\.?0+$//') GiB"
fi
echo "      {"
echo "        \"cpu\": \"Hardware\","
echo "        \"model\": \"${cpumodel}\","
echo "        \"cores\": \"${cpucores}\","
echo "        \"governor\": \"${cpugovernor}\","
echo "        \"board\": \"${main}\","
echo "        \"memory\": \"${memory}\""
echo "      }"
echo "    ],"
echo "    \"cpuSpeed\": ["
count=0
cpuspeeds=$(grep 'MHz' /proc/cpuinfo 2>/dev/null | cut -d: -f2 | cut -d. -f1)
while read -r core; do
    if [ ${count} -gt 0 ]; then
        echo "      },"
    fi
    ((count++))
    cpucore="Thread${count}"
    corespeed="${core}"
    echo "      {"
    echo "        \"cpu\": \"${cpucore}\","
    echo "        \"speed\": \"${corespeed}\""
done <<< "${cpuspeeds}"
if [ ${count} -gt 0 ]; then
    echo "      }"
fi
echo "    ],"
echo "    \"sysTemp\": ["
count=0
hwmonlist=$(ls -d /sys/class/hwmon/hwmon* 2>/dev/null | sort)
for hwmon in $hwmonlist; do
    chip=$(cat "$hwmon/name" 2>/dev/null)
    for temp in $(ls "$hwmon"/temp*_input 2>/dev/null | sort); do
        [ -f "$temp" ] || continue
        label=$(cat "${temp%_*}_label" 2>/dev/null)
        value=$(cat "$temp" 2>/dev/null)
        [ -z "$value" ] && continue
        celsius=$((value/1000))
        if [ "$celsius" -ne 0 ] && [ "$celsius" -le 90 ] && [ "$celsius" -ge 20 ]; then
            if [ $count -gt 0 ]; then
                echo "      },"
            fi
            count=$((count+1))
            raw_label="${label:-$(basename $temp)}"
            slabel="$(echo "${raw_label}" | sed -E 's/[Tt]emperature//g; s/[:\-]//g; s/^[[:space:]]+//; s/[[:space:]]+$//')"
            echo "      {"
            echo "        \"slabel\": \"${slabel}\","
            echo "        \"stemp\": \"${celsius}\""
        fi
    done
done
if [ $count -gt 0 ]; then
    echo "      }"
fi
echo "    ],"
echo "    \"iGPUInfo\": ["
count=0
CARDN="$(ls -d /sys/class/drm/card* 2>/dev/null | head -1)"
if [ -d "${CARDN}" ]; then
    PCIDN="$(awk -F= '/DEVNAME/ {print $2}' "${CARDN}/device/uevent" 2>/dev/null)"
    LNAME="$(/usr/bin/arcsu lspci -Q -s ${PCIDN:-"99:99.9"} 2>/dev/null | sed "s/.*: //" | xargs)"
    CLOCK="$(cat "${CARDN}/gt_max_freq_mhz" 2>/dev/null | xargs)"
    [ -n "${CLOCK}" ] && CLOCK="${CLOCK} MHz" || CLOCK="Unknown Clock"
    MEMORY="$(awk '{s=(strtonum($2)-strtonum($1)+1)/1048576} (and(strtonum($3),0x200))&&(and(strtonum($3),0x2000))&&(and(strtonum($3),0x40000))&&s>0{print int(s) " MiB"; exit}' "${CARDN}/device/resource" 2>/dev/null)"
    [ -n "${MEMORY}" ] && MEMORY="${MEMORY}" || MEMORY="Unknown Memory"
    RGPU=$(ls /dev/dri 2>/dev/null | grep 'render' | cut -d 'r' -f3)
    [ -z "$RGPU" ] && RGPU="Not supported"

    if [ -n "${LNAME}" ] && [ -n "${CLOCK}" ]; then
        echo "      {"
        echo "        \"iGPU\": \"GPU${count}\","
        echo "        \"iGPUN\": \"${LNAME}\","
        echo "        \"iGPUC\": \"${CLOCK}\","
        echo "        \"iGPUM\": \"${MEMORY}\","
        echo "        \"iGPURD\": \"$RGPU\""
        echo "      }"
        ((count++))
    fi
fi
echo "    ],"
# Device IDs for common storage controllers
device_ids=("::106" "::104" "::107" "::100" "::c03" "::805" "::108")
declare -A controller_disks

# List controllers and their disks
echo "    \"storageControllers\": ["
controller_count=0
for device_id in "${device_ids[@]}"; do
    for controller in $(lspci -d "${device_id}" 2>/dev/null | awk '{print $1}'); do
        name=""
        ports=""
        disks=0
        disks_json=""

        # Get controller name
        name=$(lspci -s "${controller}" 2>/dev/null | sed "s/\ .*://" | awk '{$1=""; print $0}' | xargs | tr -d '\n' | tr -d '\r')

        # Get ports for the controller
        ports=$(ls -l /sys/class/scsi_host 2>/dev/null | grep "${controller}" | awk -F'/' '{print $NF}' | sed 's/host//' | sort -n)

        # Count disks for each port and build disk_list JSON
        for port in ${ports}; do
            for disk in $(find /sys/class/scsi_host/host${port}/device/ -type d -name "block" -exec ls {} \; 2>/dev/null); do
                # Validate disk name
                if [ -z "${disk}" ] || [ "${disk}" = "synoboot" ]; then
                    continue
                fi

                # Increment the disk count
                disks=$((disks + 1))

                # Get disk information
                disk="/dev/$(basename ${disk})"
                diskstatus="$(/usr/bin/arcsu hdparm -C ${disk} 2>/dev/null | grep 'drive state is:' | cut -d: -f2 | xargs)"
                model="$(/usr/bin/arcsu synodisk --info ${disk} 2>/dev/null | grep 'Disk model:' | cut -d: -f2 | xargs)"
                capacity="$(/usr/bin/arcsu synodisk --info ${disk} 2>/dev/null | grep 'Total capacity:' | awk '{print $4}' | cut -d. -f1 | xargs)"
                smartstatus="$(/usr/bin/arcsu smartctl -H ${disk} 2>/dev/null | grep -E 'SMART Health Status: OK|SMART overall-health self-assessment test result: PASSED')"
                temp="$(/usr/bin/arcsu synodisk --info ${disk} 2>/dev/null | grep 'Tempeture:' | awk '{print $3}' | cut -d. -f1 | xargs)"

                # Provide default values for missing fields
                [ -z "${model}" ] && [ -z "${capacity}" ] && continue
                [ -z "${model}" ] && model="Unknown Model"
                [ -z "${capacity}" ] && capacity="Unknown Capacity"
                [ -z "${temp}" ] || [ "${temp}" -le 0 ] && temp="N/A"
                [ -z "${diskstatus}" ] && diskstatus="Unknown"
                [ -z "${smartstatus}" ] && smartstatus="Attention" || smartstatus="Good"

                # Append disk JSON to the list
                if [ -n "${disks_json}" ]; then
                    disks_json="${disks_json},"
                fi
                disks_json="${disks_json}
                {\"disk\": \"$(basename ${disk})\", \"model\": \"${model}\", \"capacity\": \"${capacity}\", \"temp\": \"${temp}\", \"status\": \"${diskstatus}\", \"smart\": \"Smart Status: ${smartstatus}\"}"
            done
        done

        # Skip controllers with no disks
        if [ -z "${disks_json}" ] || ! echo "${disks_json}" | grep -qv '"disk": "synoboot"'; then
            continue
        fi

        # Output controller JSON
        if [ ${controller_count} -gt 0 ]; then
            echo "      },"
        fi
        echo "      {"
        echo "        \"controller\": \"${name}\","
        echo "        \"disks\": ${disks},"
        echo "        \"disk_list\": [${disks_json}
        ]"
        controller_count=$((controller_count + 1))
    done
done
if [ ${controller_count} -gt 0 ]; then
    echo "      }"
fi
echo "    ],"
echo "    \"nvmeDisks\": ["
count=0
for dev in $(ls -l /dev/nvme[0-9] /dev/nvme[1-9][0-9] 2>/dev/null | awk '{print $10}'); do
    if [ ${count} -gt 0 ]; then
        echo "      },"
    fi

    # Unset all values before reread
    disk=""
    critwarn=""
    unsafeshutdown=""
    model=""
    capacity=""
    temp=""

    disk="/dev/$(basename ${dev})n1"
    critwarn="$(/usr/bin/arcsu nvme smart-log ${disk} | grep 'critical_warning' | awk '{print $3}' | xargs)"
    unsafeshutdown="$(/usr/bin/arcsu nvme smart-log ${disk} | grep 'unsafe_shutdowns' | awk '{print $3}' | xargs)"
    model="$(/usr/bin/arcsu synodisk --info ${disk} | grep 'Disk model:' | cut -d: -f2 | xargs)"
    capacity="$(/usr/bin/arcsu synodisk --info ${disk} | grep 'Total capacity:' | awk '{print $4}' | cut -d. -f1 | xargs)"
    temp="$(/usr/bin/arcsu synodisk --info ${disk} | grep 'Tempeture:' | awk '{print $3}' | cut -d. -f1 | xargs)"
    if [ -z "${temp}" ] || [ ${temp} -lt 0 ]; then
        temp="N/A"
    fi
    echo "      {"
    echo "        \"disk\": \"$(basename ${dev})\","
    echo "        \"model\": \"${model}\","
    echo "        \"capacity\": \"${capacity}\","
    echo "        \"temp\": \"${temp}\","
    echo "        \"unsafeshutdown\": \"${unsafeshutdown}\","
    echo "        \"critwarn\": \"${critwarn}\""
    ((count++))
done
if [ ${count} -gt 0 ]; then
    echo "      }"
fi
echo "    ],"
echo "    \"fanSpeeds\": ["
count=0
for dev in $(sensors 2>/dev/null | awk '/fan[0-9]+:/ {gsub(":", "", $1); print $1 "|" $2}'); do
    fanname=$(echo "$dev" | cut -d'|' -f1)
    rpm=$(echo "$dev" | cut -d'|' -f2)
    if [ -n "$rpm" ] && [ "$rpm" -gt 0 ] 2>/dev/null; then
        if [ $count -gt 0 ]; then
            echo "      },"
        fi
        echo "      {"
        echo "        \"fan\": \"${fanname}\","
        echo "        \"rpm\": \"${rpm}\""
        count=$((count+1))
    fi
done
if [ $count -gt 0 ]; then
    echo "      }"
fi
echo "    ],"
echo "    \"networkInfo\": ["
count=0
for eth in /sys/class/net/eth*; do
    if [ ${count} -gt 0 ]; then
        echo "      },"
    fi

    # Unset all values before reread
    dev=""
    model=""
    speed=""
    maxspeed=""
    mac=""
    status=""

    dev="$(basename "${eth}")"
    model="$(ls -ld /sys/class/net/${dev}/device/driver 2>/dev/null | awk -F '/' '{print $NF}' | xargs)"
    speed="$(/usr/bin/arcsu ethtool ${dev} 2>/dev/null | grep 'Speed:' | awk '{print $2}' | xargs)"
    maxspeed="$(/usr/bin/arcsu ethtool ${dev} 2>/dev/null | grep -o '[0-9]\+base[TX]/Full' | sort -rV | awk -F'base' '{print $1}' | head -n1 | xargs)"
    mac="$(cat "${eth}/address" 2>/dev/null | xargs)"
    status="$(cat "${eth}/operstate" 2>/dev/null | xargs)"
    echo "      {"
    echo "        \"net\": \"${dev}\","
    echo "        \"model\": \"${model}\","
    echo "        \"mac\": \"${mac}\","
    echo "        \"status\": \"${status}\","
    echo "        \"speed\": \"${speed}\","
    echo "        \"maxspeed\": \"${maxspeed}Mb/s\""
    ((count++))
done
if [ ${count} -gt 0 ]; then
    echo "      }"
fi
echo "    ]"
echo "  }"
echo "}"