#!/usr/bin/env sh

# Output the HTTP header
echo "Content-type: application/json"
echo ""

ACTION=$(echo "$QUERY_STRING" | sed -n 's/.*action=\([^&]*\).*/\1/p')

run_loaderdisk_action_mount() {
    COMMAND=$1
    if /usr/bin/arcsu arc-loaderdisk.sh mountLoaderDisk; then
        echo '{"success": true, "message": "Loader disk successfully mounted"}'
    else
        echo '{"success": false, "error": "Failed to mount loader disk"}'
    fi
}

run_loaderdisk_action_mount_all() {
    COMMAND=$1
    if /usr/bin/arcsu arc-loaderdisk.sh mountLoaderDisk -all; then
        echo '{"success": true, "message": "Loader disk successfully mounted"}'
    else
        echo '{"success": false, "error": "Failed to mount loader disk"}'
    fi
}

run_loaderdisk_action_unmount() {
    COMMAND=$1
    if /usr/bin/arcsu arc-loaderdisk.sh unmountLoaderDisk; then
        echo '{"success": true, "message": "Loader disk successfully unmounted"}'
    else
        echo '{"success": false, "error": "Failed to unmount loader disk"}'
    fi
}

check_mount_status() {
    if [ -f "/usr/arc/.mountloader" ] && [ -d "/mnt/p1" ] && [ -d "/mnt/p2" ] && [ -d "/mnt/p3" ]; then
        echo '{"success": true, "message": "Loader disk is mounted and ready"}'
    else
        echo '{"success": false, "message": "Loader disk is not mounted"}'
    fi
}

case "$ACTION" in
    mountall)
        run_loaderdisk_action_mount_all
        ;;
    mount)
        run_loaderdisk_action_mount
        ;;
    unmount)
        run_loaderdisk_action_unmount
        ;;
    status)
        check_mount_status
        ;;
    *)
        echo '{"success": false, "error": "Invalid action"}'
        ;;
esac

exit 0