#!/usr/bin/env python3

import os
import json
import subprocess

# Set the content type for the response
print("Content-type: application/json\n")

# Define the commands to execute
commands = [
    "/usr/bin/arcsu arc-loaderdisk.sh unmountLoaderDisk",
    "/usr/bin/arcsu loader-reboot.sh update"
]

results = []
all_success = True

for command in commands:
    try:
        result = subprocess.run(
            command,
            shell=True,
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
            text=True
        )
        if result.returncode == 0:
            results.append({"command": command, "success": True, "output": result.stdout.strip()})
        else:
            results.append({"command": command, "success": False, "error": result.stderr.strip()})
            all_success = False
            break
    except Exception as e:
        results.append({"command": command, "success": False, "error": str(e)})
        all_success = False
        break

if all_success:
    message = "System is rebooting to Update Mode!"
else:
    last = results[-1]
    message = last.get("error", "Failed to reboot to Update Mode.")

print(json.dumps({
    "success": all_success,
    "message": message,
    "results": results
}))