#!/usr/bin/env sh

# Output the HTTP header
echo "Content-type: application/json"
echo ""

ACTION=$(echo "$QUERY_STRING" | sed -n 's/.*action=\([^&]*\).*/\1/p')
SHELL_CMD=$(echo "$QUERY_STRING" | sed -n 's/.*shell=\([^&]*\).*/\1/p')

SCRIPT_DIR=$(dirname "$0")
TTYD_CMD="$SCRIPT_DIR/../bin/ttyd"
TTYD_PORT=17681
TTYD_SHELL=${SHELL_CMD:-"login"}
TTYD_OPTIONS="-p $TTYD_PORT --base-path /terminal/ -W $TTYD_SHELL"
NGINX_CONF_LINK="/etc/nginx/conf.d/alias.terminal.conf"
TERMINAL_CONF="$SCRIPT_DIR/../etc/terminal.conf"

configure_nginx() {
    /usr/bin/arcsu ln -sf "$TERMINAL_CONF" "$NGINX_CONF_LINK"

    if /usr/bin/arcsu nginx -t >/dev/null 2>&1; then
        /usr/bin/arcsu systemctl reload nginx
    else
        /usr/bin/arcsu rm -f "$NGINX_CONF_LINK"
    fi
}

start_terminal() {
    PID=$(ps aux | grep -v grep | grep "ttyd" | awk '{print $2}')
    if [ -n "$PID" ]; then
        /usr/bin/arcsu kill "$PID"
        sleep 2

        if ps -p "$PID" > /dev/null; then
            /usr/bin/arcsu kill -9 "$PID"
        fi
    fi

    configure_nginx

    /usr/bin/arcsu $TTYD_CMD $TTYD_OPTIONS > /dev/null 2>&1 &
    if [ $? -eq 0 ]; then
        echo '{"success": true, "message": "Terminal started successfully", "shell": "'"$TTYD_SHELL"'"}'
    else
        echo '{"success": false, "error": "Failed to start terminal"}'
    fi
}

stop_terminal() {
    PID=$(ps aux | grep -v grep | grep "ttyd" | awk '{print $2}')
    if [ -n "$PID" ]; then
        /usr/bin/arcsu kill "$PID"
        sleep 2

        if ps -p "$PID" > /dev/null; then
            /usr/bin/arcsu kill -9 "$PID"
            echo '{"success": true, "message": "Terminal forcefully stopped"}'
        else
            echo '{"success": true, "message": "Terminal stopped successfully"}'
        fi
    else
        echo '{"success": false, "error": "Failed to stop terminal or terminal not running"}'
    fi
}

status_terminal() {
    if ps aux | grep -v grep | grep "ttyd" > /dev/null; then
        echo '{"running": true}'
    else
        echo '{"running": false}'
    fi
}

case "$ACTION" in
    start)
        start_terminal
        ;;
    stop)
        stop_terminal
        ;;
    status)
        status_terminal
        ;;
    *)
        echo '{"success": false, "error": "Invalid action"}'
        ;;
esac

exit 0