#!/usr/bin/env python3

import os
import json
import sys
import cgi
import subprocess
from pathlib import Path
from http import cookies

path_root = Path(__file__).parents[1]
sys.path.append(str(path_root) + '/libs')

import libs.yaml as yaml
print("Content-type: application/json\n")

response = {}
response['success'] = False

# Authenticate the user
f = os.popen('/usr/syno/synoman/webman/modules/authenticate.cgi', 'r')
user = f.read().strip()
message = ""


def callMountLoaderScript(action):
    subprocess.run(['arcsu', '/usr/bin/arc-loaderdisk.sh', action],
                   stdout=subprocess.DEVNULL,
                   stderr=subprocess.DEVNULL)


def mountLoader():
    callMountLoaderScript('mountLoaderDisk')


def unmountLoader():
    callMountLoaderScript('unmountLoaderDisk')


def run_command(command):
    """Run a shell command and return the result."""
    try:
        result = subprocess.run(
            command,
            shell=True,
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
            text=True
        )
        return {
            "success": result.returncode == 0,
            "output": result.stdout.strip(),
            "error": result.stderr.strip()
        }
    except Exception as e:
        return {"success": False, "error": str(e)}


def write_config_key(key, value, file_path):
    """Write a key-value pair to a YAML file."""
    if isinstance(value, dict) or isinstance(value, list):
        value = json.dumps(value)  # Convert to JSON string for proper handling
        command = f"/usr/bin/arcsu yq eval '.{key} = {value}' --inplace {file_path}"
    else:
        command = f"/usr/bin/arcsu yq eval '.{key} = \"{value}\"' --inplace {file_path}"
    return run_command(command)


def read_config_keys(file_path):
    """Read all keys and values from a YAML file."""
    command = f"/usr/bin/arcsu yq eval -o=json '.' {file_path}"
    result = run_command(command)
    if not result["success"]:
        return None
    try:
        return json.loads(result["output"])
    except json.JSONDecodeError:
        return None


def filter_empty_values(obj):
    """Recursively remove keys with empty values from a dictionary."""
    if isinstance(obj, dict):
        return {k: filter_empty_values(v) for k, v in obj.items() if v not in [None, "", [], {}]}
    elif isinstance(obj, list):
        return [filter_empty_values(v) for v in obj if v not in [None, "", [], {}]]
    else:
        return obj


def convert_bools_to_yesno(obj):
    """Recursively convert booleans to 'yes'/'no'."""
    if isinstance(obj, dict):
        return {k: convert_bools_to_yesno(v) for k, v in obj.items()}
    elif isinstance(obj, list):
        return [convert_bools_to_yesno(v) for v in obj]
    elif obj is True:
        return "yes"
    elif obj is False:
        return "no"
    else:
        return obj


def convert_all_to_strings(obj):
    """Recursively convert all values to strings."""
    if isinstance(obj, dict):
        return {str(k): convert_all_to_strings(v) for k, v in obj.items()}
    elif isinstance(obj, list):
        return [convert_all_to_strings(v) for v in obj]
    elif obj is True:
        return "true"
    elif obj is False:
        return "false"
    else:
        return str(obj)


if len(user) > 0:
    mountLoader()

    # Read the request body to get the JSON data
    if os.environ.get("REQUEST_METHOD") == "POST":
        ctype, pdict = cgi.parse_header(os.environ["CONTENT_TYPE"])
        if ctype == 'application/json':
            length = int(os.environ["CONTENT_LENGTH"])
            request_body = sys.stdin.read(length)
            data = json.loads(request_body)

            # Process and clean the data
            data = convert_all_to_strings(data)

            # Convert JSON data to YAML
            yaml_data = yaml.dump(data, sort_keys=False, default_flow_style=False, allow_unicode=True)
            yaml_data = yaml_data.replace("'", '"')  # Ensure double quotes for all string values

            try:
                # Write the YAML data to a temporary file
                temp_file_path = '/tmp/user-config.yml'
                with open(temp_file_path, 'w') as yaml_file:
                    yaml_file.write(yaml_data)

                # Apply the configuration to the target file
                target_file_path = '/mnt/p1/user-config.yml'
                source_data = read_config_keys(temp_file_path)

                if source_data:
                    results = []
                    for key, value in source_data.items():
                        write_result = write_config_key(key, value, target_file_path)
                        results.append({
                            "key": key,
                            "value": value,
                            "success": write_result["success"],
                            "error": write_result.get("error", "")
                        })

                    response["results"] = results
                    response["success"] = True
                else:
                    response["error"] = "Failed to read temporary configuration file."

                # Create an empty progress file
                with open('/tmp/arc_update_progress', 'w') as progress_file:
                    progress_file.write('')

            except Exception as e:
                response["error"] = str(e)

            unmountLoader()
else:
    response["status"] = "not authenticated"

# Print the JSON response
print(json.dumps(response))